/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::eventId)).setter(Event.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::eventType)).setter(Event.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Event.getter(Event::properties)).setter(Event.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), JsonValueTrait.create()}).build();
    private static final SdkField<Instant> SENT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Event.getter(Event::sentAt)).setter(Event.setter(Builder::sentAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_FIELD, PROPERTIES_FIELD, SENT_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventType;
    private final String properties;
    private final Instant sentAt;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.properties = builder.properties;
        this.sentAt = builder.sentAt;
    }

    public String eventId() {
        return this.eventId;
    }

    public String eventType() {
        return this.eventType;
    }

    public String properties() {
        return this.properties;
    }

    public Instant sentAt() {
        return this.sentAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.sentAt(), other.sentAt());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventType()).add("Properties", (Object)this.properties()).add("SentAt", (Object)this.sentAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "sentAt": {
                return Optional.ofNullable(clazz.cast(this.sentAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventType;
        private String properties;
        private Instant sentAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.properties(model.properties);
            this.sentAt(model.sentAt);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final String getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        public final Instant getSentAt() {
            return this.sentAt;
        }

        @Override
        public final Builder sentAt(Instant sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public final void setSentAt(Instant sentAt) {
            this.sentAt = sentAt;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder properties(String var1);

        public Builder sentAt(Instant var1);
    }
}

