/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.personalizeevents.model.InvalidInputException;
import software.amazon.awssdk.services.personalizeevents.model.PersonalizeEventsException;
import software.amazon.awssdk.services.personalizeevents.model.PutActionInteractionsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutActionInteractionsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutActionsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutActionsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutEventsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutItemsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutUsersResponse;
import software.amazon.awssdk.services.personalizeevents.model.ResourceInUseException;
import software.amazon.awssdk.services.personalizeevents.model.ResourceNotFoundException;

/**
 * Service client for accessing Amazon Personalize Events. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Personalize can consume real-time user event data, such as <i>stream</i> or <i>click</i> data, and use it for
 * model training either alone or combined with historical data. For more information see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item
 * interaction events</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PersonalizeEventsClient extends AwsClient {
    String SERVICE_NAME = "personalize";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "personalize-events";

    /**
     * <p>
     * Records action interaction event data. An <i>action interaction</i> event is an interaction between a user and an
     * <i>action</i>. For example, a user taking an action, such a enrolling in a membership program or downloading your
     * app.
     * </p>
     * <p>
     * For more information about recording action interactions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-action-interaction-events.html">Recording
     * action interaction events</a>. For more information about actions in an Actions dataset, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/actions-datasets.html">Actions dataset</a>.
     * </p>
     *
     * @param putActionInteractionsRequest
     * @return Result of the PutActionInteractions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutActionInteractions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActionInteractions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutActionInteractionsResponse putActionInteractions(PutActionInteractionsRequest putActionInteractionsRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, PersonalizeEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records action interaction event data. An <i>action interaction</i> event is an interaction between a user and an
     * <i>action</i>. For example, a user taking an action, such a enrolling in a membership program or downloading your
     * app.
     * </p>
     * <p>
     * For more information about recording action interactions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-action-interaction-events.html">Recording
     * action interaction events</a>. For more information about actions in an Actions dataset, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/actions-datasets.html">Actions dataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutActionInteractionsRequest.Builder} avoiding the
     * need to create one manually via {@link PutActionInteractionsRequest#builder()}
     * </p>
     *
     * @param putActionInteractionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutActionInteractionsRequest.Builder} to
     *        create a request.
     * @return Result of the PutActionInteractions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutActionInteractions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActionInteractions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutActionInteractionsResponse putActionInteractions(
            Consumer<PutActionInteractionsRequest.Builder> putActionInteractionsRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            PersonalizeEventsException {
        return putActionInteractions(PutActionInteractionsRequest.builder().applyMutation(putActionInteractionsRequest).build());
    }

    /**
     * <p>
     * Adds one or more actions to an Actions dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions
     * individually</a>.
     * </p>
     *
     * @param putActionsRequest
     * @return Result of the PutActions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActions" target="_top">AWS
     *      API Documentation</a>
     */
    default PutActionsResponse putActions(PutActionsRequest putActionsRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            PersonalizeEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more actions to an Actions dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions
     * individually</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutActionsRequest.Builder} avoiding the need to
     * create one manually via {@link PutActionsRequest#builder()}
     * </p>
     *
     * @param putActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutActionsRequest.Builder} to create a
     *        request.
     * @return Result of the PutActions operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActions" target="_top">AWS
     *      API Documentation</a>
     */
    default PutActionsResponse putActions(Consumer<PutActionsRequest.Builder> putActionsRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            PersonalizeEventsException {
        return putActions(PutActionsRequest.builder().applyMutation(putActionsRequest).build());
    }

    /**
     * <p>
     * Records item interaction event data. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item
     * interaction events</a>.
     * </p>
     *
     * @param putEventsRequest
     * @return Result of the PutEvents operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws InvalidInputException, AwsServiceException,
            SdkClientException, PersonalizeEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records item interaction event data. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item
     * interaction events</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventsRequest#builder()}
     * </p>
     *
     * @param putEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest.Builder} to create a
     *        request.
     * @return Result of the PutEvents operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default PutEventsResponse putEvents(Consumer<PutEventsRequest.Builder> putEventsRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, PersonalizeEventsException {
        return putEvents(PutEventsRequest.builder().applyMutation(putEventsRequest).build());
    }

    /**
     * <p>
     * Adds one or more items to an Items dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing items individually</a>.
     * </p>
     *
     * @param putItemsRequest
     * @return Result of the PutItems operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutItems" target="_top">AWS
     *      API Documentation</a>
     */
    default PutItemsResponse putItems(PutItemsRequest putItemsRequest) throws InvalidInputException, ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more items to an Items dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing items individually</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutItemsRequest.Builder} avoiding the need to
     * create one manually via {@link PutItemsRequest#builder()}
     * </p>
     *
     * @param putItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest.Builder} to create a
     *        request.
     * @return Result of the PutItems operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutItems" target="_top">AWS
     *      API Documentation</a>
     */
    default PutItemsResponse putItems(Consumer<PutItemsRequest.Builder> putItemsRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            PersonalizeEventsException {
        return putItems(PutItemsRequest.builder().applyMutation(putItemsRequest).build());
    }

    /**
     * <p>
     * Adds one or more users to a Users dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.
     * </p>
     *
     * @param putUsersRequest
     * @return Result of the PutUsers operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default PutUsersResponse putUsers(PutUsersRequest putUsersRequest) throws InvalidInputException, ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeEventsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more users to a Users dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutUsersRequest.Builder} avoiding the need to
     * create one manually via {@link PutUsersRequest#builder()}
     * </p>
     *
     * @param putUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest.Builder} to create a
     *        request.
     * @return Result of the PutUsers operation returned by the service.
     * @throws InvalidInputException
     *         Provide a valid value for the field or parameter.
     * @throws ResourceNotFoundException
     *         Could not find the specified resource.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PersonalizeEventsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PersonalizeEventsClient.PutUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default PutUsersResponse putUsers(Consumer<PutUsersRequest.Builder> putUsersRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            PersonalizeEventsException {
        return putUsers(PutUsersRequest.builder().applyMutation(putUsersRequest).build());
    }

    /**
     * Create a {@link PersonalizeEventsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PersonalizeEventsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PersonalizeEventsClient}.
     */
    static PersonalizeEventsClientBuilder builder() {
        return new DefaultPersonalizeEventsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PersonalizeEventsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
