/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeevents.model.ActionInteraction;
import software.amazon.awssdk.services.personalizeevents.model.ActionInteractionsListCopier;
import software.amazon.awssdk.services.personalizeevents.model.PersonalizeEventsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutActionInteractionsRequest
extends PersonalizeEventsRequest
implements ToCopyableBuilder<Builder, PutActionInteractionsRequest> {
    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingId").getter(PutActionInteractionsRequest.getter(PutActionInteractionsRequest::trackingId)).setter(PutActionInteractionsRequest.setter(Builder::trackingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()}).build();
    private static final SdkField<List<ActionInteraction>> ACTION_INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionInteractions").getter(PutActionInteractionsRequest.getter(PutActionInteractionsRequest::actionInteractions)).setter(PutActionInteractionsRequest.setter(Builder::actionInteractions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionInteractions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionInteraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_ID_FIELD, ACTION_INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutActionInteractionsRequest.memberNameToFieldInitializer();
    private final String trackingId;
    private final List<ActionInteraction> actionInteractions;

    private PutActionInteractionsRequest(BuilderImpl builder) {
        super(builder);
        this.trackingId = builder.trackingId;
        this.actionInteractions = builder.actionInteractions;
    }

    public final String trackingId() {
        return this.trackingId;
    }

    public final boolean hasActionInteractions() {
        return this.actionInteractions != null && !(this.actionInteractions instanceof SdkAutoConstructList);
    }

    public final List<ActionInteraction> actionInteractions() {
        return this.actionInteractions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionInteractions() ? this.actionInteractions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionInteractionsRequest)) {
            return false;
        }
        PutActionInteractionsRequest other = (PutActionInteractionsRequest)((Object)obj);
        return Objects.equals(this.trackingId(), other.trackingId()) && this.hasActionInteractions() == other.hasActionInteractions() && Objects.equals(this.actionInteractions(), other.actionInteractions());
    }

    public final String toString() {
        return ToString.builder((String)"PutActionInteractionsRequest").add("TrackingId", (Object)this.trackingId()).add("ActionInteractions", this.hasActionInteractions() ? this.actionInteractions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trackingId": {
                return Optional.ofNullable(clazz.cast(this.trackingId()));
            }
            case "actionInteractions": {
                return Optional.ofNullable(clazz.cast(this.actionInteractions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trackingId", TRACKING_ID_FIELD);
        map.put("actionInteractions", ACTION_INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutActionInteractionsRequest, T> g) {
        return obj -> g.apply((PutActionInteractionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeEventsRequest.BuilderImpl
    implements Builder {
        private String trackingId;
        private List<ActionInteraction> actionInteractions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionInteractionsRequest model) {
            super(model);
            this.trackingId(model.trackingId);
            this.actionInteractions(model.actionInteractions);
        }

        public final String getTrackingId() {
            return this.trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public final List<ActionInteraction.Builder> getActionInteractions() {
            List<ActionInteraction.Builder> result = ActionInteractionsListCopier.copyToBuilder(this.actionInteractions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionInteractions(Collection<ActionInteraction.BuilderImpl> actionInteractions) {
            this.actionInteractions = ActionInteractionsListCopier.copyFromBuilder(actionInteractions);
        }

        @Override
        public final Builder actionInteractions(Collection<ActionInteraction> actionInteractions) {
            this.actionInteractions = ActionInteractionsListCopier.copy(actionInteractions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionInteractions(ActionInteraction ... actionInteractions) {
            this.actionInteractions(Arrays.asList(actionInteractions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionInteractions(Consumer<ActionInteraction.Builder> ... actionInteractions) {
            this.actionInteractions(Stream.of(actionInteractions).map(c -> (ActionInteraction)((ActionInteraction.Builder)ActionInteraction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutActionInteractionsRequest build() {
            return new PutActionInteractionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutActionInteractionsRequest> {
        public Builder trackingId(String var1);

        public Builder actionInteractions(Collection<ActionInteraction> var1);

        public Builder actionInteractions(ActionInteraction ... var1);

        public Builder actionInteractions(Consumer<ActionInteraction.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

