/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalizeevents.model.ActionImpressionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionInteraction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionInteraction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(ActionInteraction.getter(ActionInteraction::actionId)).setter(ActionInteraction.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ActionInteraction.getter(ActionInteraction::userId)).setter(ActionInteraction.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(ActionInteraction.getter(ActionInteraction::sessionId)).setter(ActionInteraction.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(ActionInteraction.getter(ActionInteraction::timestamp)).setter(ActionInteraction.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(ActionInteraction.getter(ActionInteraction::eventType)).setter(ActionInteraction.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(ActionInteraction.getter(ActionInteraction::eventId)).setter(ActionInteraction.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(ActionInteraction.getter(ActionInteraction::recommendationId)).setter(ActionInteraction.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<List<String>> IMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impression").getter(ActionInteraction.getter(ActionInteraction::impression)).setter(ActionInteraction.setter(Builder::impression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("properties").getter(ActionInteraction.getter(ActionInteraction::properties)).setter(ActionInteraction.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, USER_ID_FIELD, SESSION_ID_FIELD, TIMESTAMP_FIELD, EVENT_TYPE_FIELD, EVENT_ID_FIELD, RECOMMENDATION_ID_FIELD, IMPRESSION_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String userId;
    private final String sessionId;
    private final Instant timestamp;
    private final String eventType;
    private final String eventId;
    private final String recommendationId;
    private final List<String> impression;
    private final String properties;

    private ActionInteraction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.userId = builder.userId;
        this.sessionId = builder.sessionId;
        this.timestamp = builder.timestamp;
        this.eventType = builder.eventType;
        this.eventId = builder.eventId;
        this.recommendationId = builder.recommendationId;
        this.impression = builder.impression;
        this.properties = builder.properties;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final boolean hasImpression() {
        return this.impression != null && !(this.impression instanceof SdkAutoConstructList);
    }

    public final List<String> impression() {
        return this.impression;
    }

    public final String properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpression() ? this.impression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionInteraction)) {
            return false;
        }
        ActionInteraction other = (ActionInteraction)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.recommendationId(), other.recommendationId()) && this.hasImpression() == other.hasImpression() && Objects.equals(this.impression(), other.impression()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"ActionInteraction").add("ActionId", (Object)(this.actionId() == null ? null : "*** Sensitive Data Redacted ***")).add("UserId", (Object)(this.userId() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionId", (Object)this.sessionId()).add("Timestamp", (Object)this.timestamp()).add("EventType", (Object)this.eventType()).add("EventId", (Object)this.eventId()).add("RecommendationId", (Object)this.recommendationId()).add("Impression", (Object)(this.impression() == null ? null : "*** Sensitive Data Redacted ***")).add("Properties", (Object)(this.properties() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "impression": {
                return Optional.ofNullable(clazz.cast(this.impression()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionInteraction, T> g) {
        return obj -> g.apply((ActionInteraction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String userId;
        private String sessionId;
        private Instant timestamp;
        private String eventType;
        private String eventId;
        private String recommendationId;
        private List<String> impression = DefaultSdkAutoConstructList.getInstance();
        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionInteraction model) {
            this.actionId(model.actionId);
            this.userId(model.userId);
            this.sessionId(model.sessionId);
            this.timestamp(model.timestamp);
            this.eventType(model.eventType);
            this.eventId(model.eventId);
            this.recommendationId(model.recommendationId);
            this.impression(model.impression);
            this.properties(model.properties);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Collection<String> getImpression() {
            if (this.impression instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impression;
        }

        public final void setImpression(Collection<String> impression) {
            this.impression = ActionImpressionCopier.copy(impression);
        }

        @Override
        public final Builder impression(Collection<String> impression) {
            this.impression = ActionImpressionCopier.copy(impression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impression(String ... impression) {
            this.impression(Arrays.asList(impression));
            return this;
        }

        public final String getProperties() {
            return this.properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public ActionInteraction build() {
            return new ActionInteraction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionInteraction> {
        public Builder actionId(String var1);

        public Builder userId(String var1);

        public Builder sessionId(String var1);

        public Builder timestamp(Instant var1);

        public Builder eventType(String var1);

        public Builder eventId(String var1);

        public Builder recommendationId(String var1);

        public Builder impression(Collection<String> var1);

        public Builder impression(String ... var1);

        public Builder properties(String var1);
    }
}

