/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a metric attribution associated with an event. For more information about metric
 * attributions, see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of
 * recommendations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricAttribution implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricAttribution.Builder, MetricAttribution> {
    private static final SdkField<String> EVENT_ATTRIBUTION_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventAttributionSource").getter(getter(MetricAttribution::eventAttributionSource))
            .setter(setter(Builder::eventAttributionSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventAttributionSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVENT_ATTRIBUTION_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventAttributionSource;

    private MetricAttribution(BuilderImpl builder) {
        this.eventAttributionSource = builder.eventAttributionSource;
    }

    /**
     * <p>
     * The source of the event, such as a third party.
     * </p>
     * 
     * @return The source of the event, such as a third party.
     */
    public final String eventAttributionSource() {
        return eventAttributionSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventAttributionSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAttribution)) {
            return false;
        }
        MetricAttribution other = (MetricAttribution) obj;
        return Objects.equals(eventAttributionSource(), other.eventAttributionSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricAttribution").add("EventAttributionSource", eventAttributionSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventAttributionSource":
            return Optional.ofNullable(clazz.cast(eventAttributionSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricAttribution, T> g) {
        return obj -> g.apply((MetricAttribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricAttribution> {
        /**
         * <p>
         * The source of the event, such as a third party.
         * </p>
         * 
         * @param eventAttributionSource
         *        The source of the event, such as a third party.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventAttributionSource(String eventAttributionSource);
    }

    static final class BuilderImpl implements Builder {
        private String eventAttributionSource;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAttribution model) {
            eventAttributionSource(model.eventAttributionSource);
        }

        public final String getEventAttributionSource() {
            return eventAttributionSource;
        }

        public final void setEventAttributionSource(String eventAttributionSource) {
            this.eventAttributionSource = eventAttributionSource;
        }

        @Override
        public final Builder eventAttributionSource(String eventAttributionSource) {
            this.eventAttributionSource = eventAttributionSource;
            return this;
        }

        @Override
        public MetricAttribution build() {
            return new MetricAttribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
