/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Item
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Item> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemId").getter(Item.getter(Item::itemId)).setter(Item.setter(Builder::itemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()}).build();
    private static final SdkField<String> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("properties").getter(Item.getter(Item::properties)).setter(Item.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), JsonValueTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String itemId;
    private final String properties;

    private Item(BuilderImpl builder) {
        this.itemId = builder.itemId;
        this.properties = builder.properties;
    }

    public final String itemId() {
        return this.itemId;
    }

    public final String properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        return Objects.equals(this.itemId(), other.itemId()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"Item").add("ItemId", (Object)this.itemId()).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemId": {
                return Optional.ofNullable(clazz.cast(this.itemId()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String itemId;
        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            this.itemId(model.itemId);
            this.properties(model.properties);
        }

        public final String getItemId() {
            return this.itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public final String getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        public Item build() {
            return new Item(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Item> {
        public Builder itemId(String var1);

        public Builder properties(String var1);
    }
}

