/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCampaignRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, UpdateCampaignRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::campaignArn)).setter(UpdateCampaignRequest.setter(Builder::campaignArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::solutionVersionArn)).setter(UpdateCampaignRequest.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<Integer> MIN_PROVISIONED_TPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateCampaignRequest.getter(UpdateCampaignRequest::minProvisionedTPS)).setter(UpdateCampaignRequest.setter(Builder::minProvisionedTPS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedTPS").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD, SOLUTION_VERSION_ARN_FIELD, MIN_PROVISIONED_TPS_FIELD));
    private final String campaignArn;
    private final String solutionVersionArn;
    private final Integer minProvisionedTPS;

    private UpdateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.minProvisionedTPS = builder.minProvisionedTPS;
    }

    public String campaignArn() {
        return this.campaignArn;
    }

    public String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public Integer minProvisionedTPS() {
        return this.minProvisionedTPS;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minProvisionedTPS());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignRequest)) {
            return false;
        }
        UpdateCampaignRequest other = (UpdateCampaignRequest)((Object)obj);
        return Objects.equals(this.campaignArn(), other.campaignArn()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.minProvisionedTPS(), other.minProvisionedTPS());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCampaignRequest").add("CampaignArn", (Object)this.campaignArn()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("MinProvisionedTPS", (Object)this.minProvisionedTPS()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignArn": {
                return Optional.ofNullable(clazz.cast(this.campaignArn()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "minProvisionedTPS": {
                return Optional.ofNullable(clazz.cast(this.minProvisionedTPS()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignRequest, T> g) {
        return obj -> g.apply((UpdateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String campaignArn;
        private String solutionVersionArn;
        private Integer minProvisionedTPS;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignRequest model) {
            super(model);
            this.campaignArn(model.campaignArn);
            this.solutionVersionArn(model.solutionVersionArn);
            this.minProvisionedTPS(model.minProvisionedTPS);
        }

        public final String getCampaignArn() {
            return this.campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final Integer getMinProvisionedTPS() {
            return this.minProvisionedTPS;
        }

        @Override
        public final Builder minProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
            return this;
        }

        public final void setMinProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignRequest build() {
            return new UpdateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCampaignRequest> {
        public Builder campaignArn(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder minProvisionedTPS(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

