/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMetricAttributionRequest extends PersonalizeRequest implements
        ToCopyableBuilder<UpdateMetricAttributionRequest.Builder, UpdateMetricAttributionRequest> {
    private static final SdkField<List<MetricAttribute>> ADD_METRICS_FIELD = SdkField
            .<List<MetricAttribute>> builder(MarshallingType.LIST)
            .memberName("addMetrics")
            .getter(getter(UpdateMetricAttributionRequest::addMetrics))
            .setter(setter(Builder::addMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("removeMetrics")
            .getter(getter(UpdateMetricAttributionRequest::removeMetrics))
            .setter(setter(Builder::removeMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MetricAttributionOutput> METRICS_OUTPUT_CONFIG_FIELD = SdkField
            .<MetricAttributionOutput> builder(MarshallingType.SDK_POJO).memberName("metricsOutputConfig")
            .getter(getter(UpdateMetricAttributionRequest::metricsOutputConfig)).setter(setter(Builder::metricsOutputConfig))
            .constructor(MetricAttributionOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsOutputConfig").build())
            .build();

    private static final SdkField<String> METRIC_ATTRIBUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricAttributionArn").getter(getter(UpdateMetricAttributionRequest::metricAttributionArn))
            .setter(setter(Builder::metricAttributionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttributionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_METRICS_FIELD,
            REMOVE_METRICS_FIELD, METRICS_OUTPUT_CONFIG_FIELD, METRIC_ATTRIBUTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MetricAttribute> addMetrics;

    private final List<String> removeMetrics;

    private final MetricAttributionOutput metricsOutputConfig;

    private final String metricAttributionArn;

    private UpdateMetricAttributionRequest(BuilderImpl builder) {
        super(builder);
        this.addMetrics = builder.addMetrics;
        this.removeMetrics = builder.removeMetrics;
        this.metricsOutputConfig = builder.metricsOutputConfig;
        this.metricAttributionArn = builder.metricAttributionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddMetrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddMetrics() {
        return addMetrics != null && !(addMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Add new metric attributes to the metric attribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddMetrics} method.
     * </p>
     * 
     * @return Add new metric attributes to the metric attribution.
     */
    public final List<MetricAttribute> addMetrics() {
        return addMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveMetrics() {
        return removeMetrics != null && !(removeMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remove metric attributes from the metric attribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveMetrics} method.
     * </p>
     * 
     * @return Remove metric attributes from the metric attribution.
     */
    public final List<String> removeMetrics() {
        return removeMetrics;
    }

    /**
     * <p>
     * An output config for the metric attribution.
     * </p>
     * 
     * @return An output config for the metric attribution.
     */
    public final MetricAttributionOutput metricsOutputConfig() {
        return metricsOutputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the metric attribution to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the metric attribution to update.
     */
    public final String metricAttributionArn() {
        return metricAttributionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddMetrics() ? addMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveMetrics() ? removeMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricsOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(metricAttributionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMetricAttributionRequest)) {
            return false;
        }
        UpdateMetricAttributionRequest other = (UpdateMetricAttributionRequest) obj;
        return hasAddMetrics() == other.hasAddMetrics() && Objects.equals(addMetrics(), other.addMetrics())
                && hasRemoveMetrics() == other.hasRemoveMetrics() && Objects.equals(removeMetrics(), other.removeMetrics())
                && Objects.equals(metricsOutputConfig(), other.metricsOutputConfig())
                && Objects.equals(metricAttributionArn(), other.metricAttributionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMetricAttributionRequest").add("AddMetrics", hasAddMetrics() ? addMetrics() : null)
                .add("RemoveMetrics", hasRemoveMetrics() ? removeMetrics() : null)
                .add("MetricsOutputConfig", metricsOutputConfig()).add("MetricAttributionArn", metricAttributionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addMetrics":
            return Optional.ofNullable(clazz.cast(addMetrics()));
        case "removeMetrics":
            return Optional.ofNullable(clazz.cast(removeMetrics()));
        case "metricsOutputConfig":
            return Optional.ofNullable(clazz.cast(metricsOutputConfig()));
        case "metricAttributionArn":
            return Optional.ofNullable(clazz.cast(metricAttributionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addMetrics", ADD_METRICS_FIELD);
        map.put("removeMetrics", REMOVE_METRICS_FIELD);
        map.put("metricsOutputConfig", METRICS_OUTPUT_CONFIG_FIELD);
        map.put("metricAttributionArn", METRIC_ATTRIBUTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMetricAttributionRequest, T> g) {
        return obj -> g.apply((UpdateMetricAttributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMetricAttributionRequest> {
        /**
         * <p>
         * Add new metric attributes to the metric attribution.
         * </p>
         * 
         * @param addMetrics
         *        Add new metric attributes to the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addMetrics(Collection<MetricAttribute> addMetrics);

        /**
         * <p>
         * Add new metric attributes to the metric attribution.
         * </p>
         * 
         * @param addMetrics
         *        Add new metric attributes to the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addMetrics(MetricAttribute... addMetrics);

        /**
         * <p>
         * Add new metric attributes to the metric attribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.MetricAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.personalize.model.MetricAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.MetricAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #addMetrics(List<MetricAttribute>)}.
         * 
         * @param addMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.MetricAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addMetrics(java.util.Collection<MetricAttribute>)
         */
        Builder addMetrics(Consumer<MetricAttribute.Builder>... addMetrics);

        /**
         * <p>
         * Remove metric attributes from the metric attribution.
         * </p>
         * 
         * @param removeMetrics
         *        Remove metric attributes from the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeMetrics(Collection<String> removeMetrics);

        /**
         * <p>
         * Remove metric attributes from the metric attribution.
         * </p>
         * 
         * @param removeMetrics
         *        Remove metric attributes from the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeMetrics(String... removeMetrics);

        /**
         * <p>
         * An output config for the metric attribution.
         * </p>
         * 
         * @param metricsOutputConfig
         *        An output config for the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig);

        /**
         * <p>
         * An output config for the metric attribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricAttributionOutput.Builder} avoiding
         * the need to create one manually via {@link MetricAttributionOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricAttributionOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #metricsOutputConfig(MetricAttributionOutput)}.
         * 
         * @param metricsOutputConfig
         *        a consumer that will call methods on {@link MetricAttributionOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsOutputConfig(MetricAttributionOutput)
         */
        default Builder metricsOutputConfig(Consumer<MetricAttributionOutput.Builder> metricsOutputConfig) {
            return metricsOutputConfig(MetricAttributionOutput.builder().applyMutation(metricsOutputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the metric attribution to update.
         * </p>
         * 
         * @param metricAttributionArn
         *        The Amazon Resource Name (ARN) for the metric attribution to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAttributionArn(String metricAttributionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private List<MetricAttribute> addMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeMetrics = DefaultSdkAutoConstructList.getInstance();

        private MetricAttributionOutput metricsOutputConfig;

        private String metricAttributionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMetricAttributionRequest model) {
            super(model);
            addMetrics(model.addMetrics);
            removeMetrics(model.removeMetrics);
            metricsOutputConfig(model.metricsOutputConfig);
            metricAttributionArn(model.metricAttributionArn);
        }

        public final List<MetricAttribute.Builder> getAddMetrics() {
            List<MetricAttribute.Builder> result = MetricAttributesCopier.copyToBuilder(this.addMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddMetrics(Collection<MetricAttribute.BuilderImpl> addMetrics) {
            this.addMetrics = MetricAttributesCopier.copyFromBuilder(addMetrics);
        }

        @Override
        public final Builder addMetrics(Collection<MetricAttribute> addMetrics) {
            this.addMetrics = MetricAttributesCopier.copy(addMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMetrics(MetricAttribute... addMetrics) {
            addMetrics(Arrays.asList(addMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addMetrics(Consumer<MetricAttribute.Builder>... addMetrics) {
            addMetrics(Stream.of(addMetrics).map(c -> MetricAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveMetrics() {
            if (removeMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return removeMetrics;
        }

        public final void setRemoveMetrics(Collection<String> removeMetrics) {
            this.removeMetrics = MetricAttributesNamesListCopier.copy(removeMetrics);
        }

        @Override
        public final Builder removeMetrics(Collection<String> removeMetrics) {
            this.removeMetrics = MetricAttributesNamesListCopier.copy(removeMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeMetrics(String... removeMetrics) {
            removeMetrics(Arrays.asList(removeMetrics));
            return this;
        }

        public final MetricAttributionOutput.Builder getMetricsOutputConfig() {
            return metricsOutputConfig != null ? metricsOutputConfig.toBuilder() : null;
        }

        public final void setMetricsOutputConfig(MetricAttributionOutput.BuilderImpl metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig != null ? metricsOutputConfig.build() : null;
        }

        @Override
        public final Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig;
            return this;
        }

        public final String getMetricAttributionArn() {
            return metricAttributionArn;
        }

        public final void setMetricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
        }

        @Override
        public final Builder metricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMetricAttributionRequest build() {
            return new UpdateMetricAttributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
