/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the hyperparameters and their default ranges. Hyperparameters can be categorical, continuous, or
 * integer-valued.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultHyperParameterRanges implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultHyperParameterRanges.Builder, DefaultHyperParameterRanges> {
    private static final SdkField<List<DefaultIntegerHyperParameterRange>> INTEGER_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<DefaultIntegerHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("integerHyperParameterRanges")
            .getter(getter(DefaultHyperParameterRanges::integerHyperParameterRanges))
            .setter(setter(Builder::integerHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefaultIntegerHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefaultIntegerHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DefaultContinuousHyperParameterRange>> CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<DefaultContinuousHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("continuousHyperParameterRanges")
            .getter(getter(DefaultHyperParameterRanges::continuousHyperParameterRanges))
            .setter(setter(Builder::continuousHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefaultContinuousHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefaultContinuousHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DefaultCategoricalHyperParameterRange>> CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<DefaultCategoricalHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("categoricalHyperParameterRanges")
            .getter(getter(DefaultHyperParameterRanges::categoricalHyperParameterRanges))
            .setter(setter(Builder::categoricalHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoricalHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DefaultCategoricalHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DefaultCategoricalHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGER_HYPER_PARAMETER_RANGES_FIELD, CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD,
            CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DefaultIntegerHyperParameterRange> integerHyperParameterRanges;

    private final List<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges;

    private final List<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges;

    private DefaultHyperParameterRanges(BuilderImpl builder) {
        this.integerHyperParameterRanges = builder.integerHyperParameterRanges;
        this.continuousHyperParameterRanges = builder.continuousHyperParameterRanges;
        this.categoricalHyperParameterRanges = builder.categoricalHyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerHyperParameterRanges property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIntegerHyperParameterRanges() {
        return integerHyperParameterRanges != null && !(integerHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The integer-valued hyperparameters and their default ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerHyperParameterRanges} method.
     * </p>
     * 
     * @return The integer-valued hyperparameters and their default ranges.
     */
    public final List<DefaultIntegerHyperParameterRange> integerHyperParameterRanges() {
        return integerHyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContinuousHyperParameterRanges property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContinuousHyperParameterRanges() {
        return continuousHyperParameterRanges != null && !(continuousHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The continuous hyperparameters and their default ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContinuousHyperParameterRanges} method.
     * </p>
     * 
     * @return The continuous hyperparameters and their default ranges.
     */
    public final List<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges() {
        return continuousHyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoricalHyperParameterRanges
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCategoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges != null && !(categoricalHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categorical hyperparameters and their default ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoricalHyperParameterRanges}
     * method.
     * </p>
     * 
     * @return The categorical hyperparameters and their default ranges.
     */
    public final List<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerHyperParameterRanges() ? integerHyperParameterRanges() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasContinuousHyperParameterRanges() ? continuousHyperParameterRanges() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCategoricalHyperParameterRanges() ? categoricalHyperParameterRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultHyperParameterRanges)) {
            return false;
        }
        DefaultHyperParameterRanges other = (DefaultHyperParameterRanges) obj;
        return hasIntegerHyperParameterRanges() == other.hasIntegerHyperParameterRanges()
                && Objects.equals(integerHyperParameterRanges(), other.integerHyperParameterRanges())
                && hasContinuousHyperParameterRanges() == other.hasContinuousHyperParameterRanges()
                && Objects.equals(continuousHyperParameterRanges(), other.continuousHyperParameterRanges())
                && hasCategoricalHyperParameterRanges() == other.hasCategoricalHyperParameterRanges()
                && Objects.equals(categoricalHyperParameterRanges(), other.categoricalHyperParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DefaultHyperParameterRanges")
                .add("IntegerHyperParameterRanges", hasIntegerHyperParameterRanges() ? integerHyperParameterRanges() : null)
                .add("ContinuousHyperParameterRanges",
                        hasContinuousHyperParameterRanges() ? continuousHyperParameterRanges() : null)
                .add("CategoricalHyperParameterRanges",
                        hasCategoricalHyperParameterRanges() ? categoricalHyperParameterRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integerHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(integerHyperParameterRanges()));
        case "continuousHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(continuousHyperParameterRanges()));
        case "categoricalHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalHyperParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integerHyperParameterRanges", INTEGER_HYPER_PARAMETER_RANGES_FIELD);
        map.put("continuousHyperParameterRanges", CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD);
        map.put("categoricalHyperParameterRanges", CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultHyperParameterRanges, T> g) {
        return obj -> g.apply((DefaultHyperParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultHyperParameterRanges> {
        /**
         * <p>
         * The integer-valued hyperparameters and their default ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(Collection<DefaultIntegerHyperParameterRange> integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their default ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(DefaultIntegerHyperParameterRange... integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their default ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #integerHyperParameterRanges(List<DefaultIntegerHyperParameterRange>)}.
         * 
         * @param integerHyperParameterRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.DefaultIntegerHyperParameterRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerHyperParameterRanges(java.util.Collection<DefaultIntegerHyperParameterRange>)
         */
        Builder integerHyperParameterRanges(Consumer<DefaultIntegerHyperParameterRange.Builder>... integerHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their default ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(Collection<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their default ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(DefaultContinuousHyperParameterRange... continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their default ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #continuousHyperParameterRanges(List<DefaultContinuousHyperParameterRange>)}.
         * 
         * @param continuousHyperParameterRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.DefaultContinuousHyperParameterRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousHyperParameterRanges(java.util.Collection<DefaultContinuousHyperParameterRange>)
         */
        Builder continuousHyperParameterRanges(
                Consumer<DefaultContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their default ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(Collection<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their default ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their default ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(DefaultCategoricalHyperParameterRange... categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their default ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #categoricalHyperParameterRanges(List<DefaultCategoricalHyperParameterRange>)}.
         * 
         * @param categoricalHyperParameterRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.DefaultCategoricalHyperParameterRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalHyperParameterRanges(java.util.Collection<DefaultCategoricalHyperParameterRange>)
         */
        Builder categoricalHyperParameterRanges(
                Consumer<DefaultCategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<DefaultIntegerHyperParameterRange> integerHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges = DefaultSdkAutoConstructList
                .getInstance();

        private List<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultHyperParameterRanges model) {
            integerHyperParameterRanges(model.integerHyperParameterRanges);
            continuousHyperParameterRanges(model.continuousHyperParameterRanges);
            categoricalHyperParameterRanges(model.categoricalHyperParameterRanges);
        }

        public final List<DefaultIntegerHyperParameterRange.Builder> getIntegerHyperParameterRanges() {
            List<DefaultIntegerHyperParameterRange.Builder> result = DefaultIntegerHyperParameterRangesCopier
                    .copyToBuilder(this.integerHyperParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegerHyperParameterRanges(
                Collection<DefaultIntegerHyperParameterRange.BuilderImpl> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = DefaultIntegerHyperParameterRangesCopier
                    .copyFromBuilder(integerHyperParameterRanges);
        }

        @Override
        public final Builder integerHyperParameterRanges(Collection<DefaultIntegerHyperParameterRange> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = DefaultIntegerHyperParameterRangesCopier.copy(integerHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(DefaultIntegerHyperParameterRange... integerHyperParameterRanges) {
            integerHyperParameterRanges(Arrays.asList(integerHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(
                Consumer<DefaultIntegerHyperParameterRange.Builder>... integerHyperParameterRanges) {
            integerHyperParameterRanges(Stream.of(integerHyperParameterRanges)
                    .map(c -> DefaultIntegerHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DefaultContinuousHyperParameterRange.Builder> getContinuousHyperParameterRanges() {
            List<DefaultContinuousHyperParameterRange.Builder> result = DefaultContinuousHyperParameterRangesCopier
                    .copyToBuilder(this.continuousHyperParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContinuousHyperParameterRanges(
                Collection<DefaultContinuousHyperParameterRange.BuilderImpl> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = DefaultContinuousHyperParameterRangesCopier
                    .copyFromBuilder(continuousHyperParameterRanges);
        }

        @Override
        public final Builder continuousHyperParameterRanges(
                Collection<DefaultContinuousHyperParameterRange> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = DefaultContinuousHyperParameterRangesCopier
                    .copy(continuousHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(
                DefaultContinuousHyperParameterRange... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Arrays.asList(continuousHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(
                Consumer<DefaultContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Stream.of(continuousHyperParameterRanges)
                    .map(c -> DefaultContinuousHyperParameterRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DefaultCategoricalHyperParameterRange.Builder> getCategoricalHyperParameterRanges() {
            List<DefaultCategoricalHyperParameterRange.Builder> result = DefaultCategoricalHyperParameterRangesCopier
                    .copyToBuilder(this.categoricalHyperParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoricalHyperParameterRanges(
                Collection<DefaultCategoricalHyperParameterRange.BuilderImpl> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = DefaultCategoricalHyperParameterRangesCopier
                    .copyFromBuilder(categoricalHyperParameterRanges);
        }

        @Override
        public final Builder categoricalHyperParameterRanges(
                Collection<DefaultCategoricalHyperParameterRange> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = DefaultCategoricalHyperParameterRangesCopier
                    .copy(categoricalHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(
                DefaultCategoricalHyperParameterRange... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Arrays.asList(categoricalHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(
                Consumer<DefaultCategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Stream.of(categoricalHyperParameterRanges)
                    .map(c -> DefaultCategoricalHyperParameterRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DefaultHyperParameterRanges build() {
            return new DefaultHyperParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
