/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.DataDeletionJobSummary;
import software.amazon.awssdk.services.personalize.model.DataDeletionJobsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataDeletionJobsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListDataDeletionJobsResponse> {
    private static final SdkField<List<DataDeletionJobSummary>> DATA_DELETION_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataDeletionJobs").getter(ListDataDeletionJobsResponse.getter(ListDataDeletionJobsResponse::dataDeletionJobs)).setter(ListDataDeletionJobsResponse.setter(Builder::dataDeletionJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataDeletionJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataDeletionJobsResponse.getter(ListDataDeletionJobsResponse::nextToken)).setter(ListDataDeletionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_DELETION_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataDeletionJobsResponse.memberNameToFieldInitializer();
    private final List<DataDeletionJobSummary> dataDeletionJobs;
    private final String nextToken;

    private ListDataDeletionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.dataDeletionJobs = builder.dataDeletionJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataDeletionJobs() {
        return this.dataDeletionJobs != null && !(this.dataDeletionJobs instanceof SdkAutoConstructList);
    }

    public final List<DataDeletionJobSummary> dataDeletionJobs() {
        return this.dataDeletionJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataDeletionJobs() ? this.dataDeletionJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataDeletionJobsResponse)) {
            return false;
        }
        ListDataDeletionJobsResponse other = (ListDataDeletionJobsResponse)((Object)obj);
        return this.hasDataDeletionJobs() == other.hasDataDeletionJobs() && Objects.equals(this.dataDeletionJobs(), other.dataDeletionJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataDeletionJobsResponse").add("DataDeletionJobs", this.hasDataDeletionJobs() ? this.dataDeletionJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataDeletionJobs": {
                return Optional.ofNullable(clazz.cast(this.dataDeletionJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataDeletionJobs", DATA_DELETION_JOBS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataDeletionJobsResponse, T> g) {
        return obj -> g.apply((ListDataDeletionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<DataDeletionJobSummary> dataDeletionJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataDeletionJobsResponse model) {
            super(model);
            this.dataDeletionJobs(model.dataDeletionJobs);
            this.nextToken(model.nextToken);
        }

        public final List<DataDeletionJobSummary.Builder> getDataDeletionJobs() {
            List<DataDeletionJobSummary.Builder> result = DataDeletionJobsCopier.copyToBuilder(this.dataDeletionJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataDeletionJobs(Collection<DataDeletionJobSummary.BuilderImpl> dataDeletionJobs) {
            this.dataDeletionJobs = DataDeletionJobsCopier.copyFromBuilder(dataDeletionJobs);
        }

        @Override
        public final Builder dataDeletionJobs(Collection<DataDeletionJobSummary> dataDeletionJobs) {
            this.dataDeletionJobs = DataDeletionJobsCopier.copy(dataDeletionJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDeletionJobs(DataDeletionJobSummary ... dataDeletionJobs) {
            this.dataDeletionJobs(Arrays.asList(dataDeletionJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataDeletionJobs(Consumer<DataDeletionJobSummary.Builder> ... dataDeletionJobs) {
            this.dataDeletionJobs(Stream.of(dataDeletionJobs).map(c -> (DataDeletionJobSummary)((DataDeletionJobSummary.Builder)DataDeletionJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataDeletionJobsResponse build() {
            return new ListDataDeletionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataDeletionJobsResponse> {
        public Builder dataDeletionJobs(Collection<DataDeletionJobSummary> var1);

        public Builder dataDeletionJobs(DataDeletionJobSummary ... var1);

        public Builder dataDeletionJobs(Consumer<DataDeletionJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

