/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput;
import software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchSegmentJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchSegmentJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(BatchSegmentJob.getter(BatchSegmentJob::jobName)).setter(BatchSegmentJob.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> BATCH_SEGMENT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("batchSegmentJobArn").getter(BatchSegmentJob.getter(BatchSegmentJob::batchSegmentJobArn)).setter(BatchSegmentJob.setter(Builder::batchSegmentJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSegmentJobArn").build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(BatchSegmentJob.getter(BatchSegmentJob::filterArn)).setter(BatchSegmentJob.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(BatchSegmentJob.getter(BatchSegmentJob::failureReason)).setter(BatchSegmentJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(BatchSegmentJob.getter(BatchSegmentJob::solutionVersionArn)).setter(BatchSegmentJob.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numResults").getter(BatchSegmentJob.getter(BatchSegmentJob::numResults)).setter(BatchSegmentJob.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()}).build();
    private static final SdkField<BatchSegmentJobInput> JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobInput").getter(BatchSegmentJob.getter(BatchSegmentJob::jobInput)).setter(BatchSegmentJob.setter(Builder::jobInput)).constructor(BatchSegmentJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()}).build();
    private static final SdkField<BatchSegmentJobOutput> JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobOutput").getter(BatchSegmentJob.getter(BatchSegmentJob::jobOutput)).setter(BatchSegmentJob.setter(Builder::jobOutput)).constructor(BatchSegmentJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(BatchSegmentJob.getter(BatchSegmentJob::roleArn)).setter(BatchSegmentJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchSegmentJob.getter(BatchSegmentJob::status)).setter(BatchSegmentJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(BatchSegmentJob.getter(BatchSegmentJob::creationDateTime)).setter(BatchSegmentJob.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(BatchSegmentJob.getter(BatchSegmentJob::lastUpdatedDateTime)).setter(BatchSegmentJob.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, BATCH_SEGMENT_JOB_ARN_FIELD, FILTER_ARN_FIELD, FAILURE_REASON_FIELD, SOLUTION_VERSION_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchSegmentJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String batchSegmentJobArn;
    private final String filterArn;
    private final String failureReason;
    private final String solutionVersionArn;
    private final Integer numResults;
    private final BatchSegmentJobInput jobInput;
    private final BatchSegmentJobOutput jobOutput;
    private final String roleArn;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private BatchSegmentJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.batchSegmentJobArn = builder.batchSegmentJobArn;
        this.filterArn = builder.filterArn;
        this.failureReason = builder.failureReason;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String batchSegmentJobArn() {
        return this.batchSegmentJobArn;
    }

    public final String filterArn() {
        return this.filterArn;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final BatchSegmentJobInput jobInput() {
        return this.jobInput;
    }

    public final BatchSegmentJobOutput jobOutput() {
        return this.jobOutput;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSegmentJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSegmentJob)) {
            return false;
        }
        BatchSegmentJob other = (BatchSegmentJob)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.batchSegmentJobArn(), other.batchSegmentJobArn()) && Objects.equals(this.filterArn(), other.filterArn()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.jobInput(), other.jobInput()) && Objects.equals(this.jobOutput(), other.jobOutput()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BatchSegmentJob").add("JobName", (Object)this.jobName()).add("BatchSegmentJobArn", (Object)this.batchSegmentJobArn()).add("FilterArn", (Object)this.filterArn()).add("FailureReason", (Object)this.failureReason()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("NumResults", (Object)this.numResults()).add("JobInput", (Object)this.jobInput()).add("JobOutput", (Object)this.jobOutput()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "batchSegmentJobArn": {
                return Optional.ofNullable(clazz.cast(this.batchSegmentJobArn()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "numResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "jobInput": {
                return Optional.ofNullable(clazz.cast(this.jobInput()));
            }
            case "jobOutput": {
                return Optional.ofNullable(clazz.cast(this.jobOutput()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobName", JOB_NAME_FIELD);
        map.put("batchSegmentJobArn", BATCH_SEGMENT_JOB_ARN_FIELD);
        map.put("filterArn", FILTER_ARN_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("solutionVersionArn", SOLUTION_VERSION_ARN_FIELD);
        map.put("numResults", NUM_RESULTS_FIELD);
        map.put("jobInput", JOB_INPUT_FIELD);
        map.put("jobOutput", JOB_OUTPUT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchSegmentJob, T> g) {
        return obj -> g.apply((BatchSegmentJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String batchSegmentJobArn;
        private String filterArn;
        private String failureReason;
        private String solutionVersionArn;
        private Integer numResults;
        private BatchSegmentJobInput jobInput;
        private BatchSegmentJobOutput jobOutput;
        private String roleArn;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchSegmentJob model) {
            this.jobName(model.jobName);
            this.batchSegmentJobArn(model.batchSegmentJobArn);
            this.filterArn(model.filterArn);
            this.failureReason(model.failureReason);
            this.solutionVersionArn(model.solutionVersionArn);
            this.numResults(model.numResults);
            this.jobInput(model.jobInput);
            this.jobOutput(model.jobOutput);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getBatchSegmentJobArn() {
            return this.batchSegmentJobArn;
        }

        public final void setBatchSegmentJobArn(String batchSegmentJobArn) {
            this.batchSegmentJobArn = batchSegmentJobArn;
        }

        @Override
        public final Builder batchSegmentJobArn(String batchSegmentJobArn) {
            this.batchSegmentJobArn = batchSegmentJobArn;
            return this;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final BatchSegmentJobInput.Builder getJobInput() {
            return this.jobInput != null ? this.jobInput.toBuilder() : null;
        }

        public final void setJobInput(BatchSegmentJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        @Override
        public final Builder jobInput(BatchSegmentJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final BatchSegmentJobOutput.Builder getJobOutput() {
            return this.jobOutput != null ? this.jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(BatchSegmentJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(BatchSegmentJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public BatchSegmentJob build() {
            return new BatchSegmentJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchSegmentJob> {
        public Builder jobName(String var1);

        public Builder batchSegmentJobArn(String var1);

        public Builder filterArn(String var1);

        public Builder failureReason(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder numResults(Integer var1);

        public Builder jobInput(BatchSegmentJobInput var1);

        default public Builder jobInput(Consumer<BatchSegmentJobInput.Builder> jobInput) {
            return this.jobInput((BatchSegmentJobInput)((BatchSegmentJobInput.Builder)BatchSegmentJobInput.builder().applyMutation(jobInput)).build());
        }

        public Builder jobOutput(BatchSegmentJobOutput var1);

        default public Builder jobOutput(Consumer<BatchSegmentJobOutput.Builder> jobOutput) {
            return this.jobOutput((BatchSegmentJobOutput)((BatchSegmentJobOutput.Builder)BatchSegmentJobOutput.builder().applyMutation(jobOutput)).build());
        }

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

