/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.MetricAttribute;

public class ListMetricAttributionMetricsIterable
implements SdkIterable<ListMetricAttributionMetricsResponse> {
    private final PersonalizeClient client;
    private final ListMetricAttributionMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricAttributionMetricsIterable(PersonalizeClient client, ListMetricAttributionMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMetricAttributionMetricsResponseFetcher();
    }

    public Iterator<ListMetricAttributionMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricAttribute> metrics() {
        Function<ListMetricAttributionMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metrics() != null) {
                return response.metrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMetricAttributionMetricsResponseFetcher
    implements SyncPageFetcher<ListMetricAttributionMetricsResponse> {
        private ListMetricAttributionMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricAttributionMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetricAttributionMetricsResponse nextPage(ListMetricAttributionMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricAttributionMetricsIterable.this.client.listMetricAttributionMetrics(ListMetricAttributionMetricsIterable.this.firstRequest);
            }
            return ListMetricAttributionMetricsIterable.this.client.listMetricAttributionMetrics((ListMetricAttributionMetricsRequest)((Object)ListMetricAttributionMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

