/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.CampaignConfig;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.Tag;
import software.amazon.awssdk.services.personalize.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCampaignRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCampaignRequest.getter(CreateCampaignRequest::name)).setter(CreateCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(CreateCampaignRequest.getter(CreateCampaignRequest::solutionVersionArn)).setter(CreateCampaignRequest.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<Integer> MIN_PROVISIONED_TPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minProvisionedTPS").getter(CreateCampaignRequest.getter(CreateCampaignRequest::minProvisionedTPS)).setter(CreateCampaignRequest.setter(Builder::minProvisionedTPS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedTPS").build()}).build();
    private static final SdkField<CampaignConfig> CAMPAIGN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("campaignConfig").getter(CreateCampaignRequest.getter(CreateCampaignRequest::campaignConfig)).setter(CreateCampaignRequest.setter(Builder::campaignConfig)).constructor(CampaignConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCampaignRequest.getter(CreateCampaignRequest::tags)).setter(CreateCampaignRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOLUTION_VERSION_ARN_FIELD, MIN_PROVISIONED_TPS_FIELD, CAMPAIGN_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCampaignRequest.memberNameToFieldInitializer();
    private final String name;
    private final String solutionVersionArn;
    private final Integer minProvisionedTPS;
    private final CampaignConfig campaignConfig;
    private final List<Tag> tags;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.minProvisionedTPS = builder.minProvisionedTPS;
        this.campaignConfig = builder.campaignConfig;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public final Integer minProvisionedTPS() {
        return this.minProvisionedTPS;
    }

    public final CampaignConfig campaignConfig() {
        return this.campaignConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minProvisionedTPS());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.minProvisionedTPS(), other.minProvisionedTPS()) && Objects.equals(this.campaignConfig(), other.campaignConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCampaignRequest").add("Name", (Object)this.name()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("MinProvisionedTPS", (Object)this.minProvisionedTPS()).add("CampaignConfig", (Object)this.campaignConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "minProvisionedTPS": {
                return Optional.ofNullable(clazz.cast(this.minProvisionedTPS()));
            }
            case "campaignConfig": {
                return Optional.ofNullable(clazz.cast(this.campaignConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("solutionVersionArn", SOLUTION_VERSION_ARN_FIELD);
        map.put("minProvisionedTPS", MIN_PROVISIONED_TPS_FIELD);
        map.put("campaignConfig", CAMPAIGN_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String solutionVersionArn;
        private Integer minProvisionedTPS;
        private CampaignConfig campaignConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            this.name(model.name);
            this.solutionVersionArn(model.solutionVersionArn);
            this.minProvisionedTPS(model.minProvisionedTPS);
            this.campaignConfig(model.campaignConfig);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final Integer getMinProvisionedTPS() {
            return this.minProvisionedTPS;
        }

        public final void setMinProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
        }

        @Override
        public final Builder minProvisionedTPS(Integer minProvisionedTPS) {
            this.minProvisionedTPS = minProvisionedTPS;
            return this;
        }

        public final CampaignConfig.Builder getCampaignConfig() {
            return this.campaignConfig != null ? this.campaignConfig.toBuilder() : null;
        }

        public final void setCampaignConfig(CampaignConfig.BuilderImpl campaignConfig) {
            this.campaignConfig = campaignConfig != null ? campaignConfig.build() : null;
        }

        @Override
        public final Builder campaignConfig(CampaignConfig campaignConfig) {
            this.campaignConfig = campaignConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCampaignRequest> {
        public Builder name(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder minProvisionedTPS(Integer var1);

        public Builder campaignConfig(CampaignConfig var1);

        default public Builder campaignConfig(Consumer<CampaignConfig.Builder> campaignConfig) {
            return this.campaignConfig((CampaignConfig)((CampaignConfig.Builder)CampaignConfig.builder().applyMutation(campaignConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

