/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmImage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AlgorithmImage.getter(AlgorithmImage::name)).setter(AlgorithmImage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DOCKER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dockerURI").getter(AlgorithmImage.getter(AlgorithmImage::dockerURI)).setter(AlgorithmImage.setter(Builder::dockerURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerURI").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCKER_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlgorithmImage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dockerURI;

    private AlgorithmImage(BuilderImpl builder) {
        this.name = builder.name;
        this.dockerURI = builder.dockerURI;
    }

    public final String name() {
        return this.name;
    }

    public final String dockerURI() {
        return this.dockerURI;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerURI());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmImage)) {
            return false;
        }
        AlgorithmImage other = (AlgorithmImage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dockerURI(), other.dockerURI());
    }

    public final String toString() {
        return ToString.builder((String)"AlgorithmImage").add("Name", (Object)this.name()).add("DockerURI", (Object)this.dockerURI()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dockerURI": {
                return Optional.ofNullable(clazz.cast(this.dockerURI()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("name", NAME_FIELD);
        map.put("dockerURI", DOCKER_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmImage, T> g) {
        return obj -> g.apply((AlgorithmImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dockerURI;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmImage model) {
            this.name(model.name);
            this.dockerURI(model.dockerURI);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDockerURI() {
            return this.dockerURI;
        }

        public final void setDockerURI(String dockerURI) {
            this.dockerURI = dockerURI;
        }

        @Override
        public final Builder dockerURI(String dockerURI) {
            this.dockerURI = dockerURI;
            return this;
        }

        public AlgorithmImage build() {
            return new AlgorithmImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmImage> {
        public Builder name(String var1);

        public Builder dockerURI(String var1);
    }
}

