/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.DatasetUpdateSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dataset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dataset> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Dataset.getter(Dataset::name)).setter(Dataset.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(Dataset.getter(Dataset::datasetArn)).setter(Dataset.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(Dataset.getter(Dataset::datasetGroupArn)).setter(Dataset.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetType").getter(Dataset.getter(Dataset::datasetType)).setter(Dataset.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetType").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaArn").getter(Dataset.getter(Dataset::schemaArn)).setter(Dataset.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Dataset.getter(Dataset::status)).setter(Dataset.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(Dataset.getter(Dataset::creationDateTime)).setter(Dataset.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(Dataset.getter(Dataset::lastUpdatedDateTime)).setter(Dataset.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<DatasetUpdateSummary> LATEST_DATASET_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestDatasetUpdate").getter(Dataset.getter(Dataset::latestDatasetUpdate)).setter(Dataset.setter(Builder::latestDatasetUpdate)).constructor(DatasetUpdateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestDatasetUpdate").build()}).build();
    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingId").getter(Dataset.getter(Dataset::trackingId)).setter(Dataset.setter(Builder::trackingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATASET_ARN_FIELD, DATASET_GROUP_ARN_FIELD, DATASET_TYPE_FIELD, SCHEMA_ARN_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, LATEST_DATASET_UPDATE_FIELD, TRACKING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("datasetArn", DATASET_ARN_FIELD);
            this.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
            this.put("datasetType", DATASET_TYPE_FIELD);
            this.put("schemaArn", SCHEMA_ARN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
            this.put("latestDatasetUpdate", LATEST_DATASET_UPDATE_FIELD);
            this.put("trackingId", TRACKING_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String datasetArn;
    private final String datasetGroupArn;
    private final String datasetType;
    private final String schemaArn;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final DatasetUpdateSummary latestDatasetUpdate;
    private final String trackingId;

    private Dataset(BuilderImpl builder) {
        this.name = builder.name;
        this.datasetArn = builder.datasetArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.datasetType = builder.datasetType;
        this.schemaArn = builder.schemaArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.latestDatasetUpdate = builder.latestDatasetUpdate;
        this.trackingId = builder.trackingId;
    }

    public final String name() {
        return this.name;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final String datasetType() {
        return this.datasetType;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final DatasetUpdateSummary latestDatasetUpdate() {
        return this.latestDatasetUpdate;
    }

    public final String trackingId() {
        return this.trackingId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestDatasetUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.datasetType(), other.datasetType()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.latestDatasetUpdate(), other.latestDatasetUpdate()) && Objects.equals(this.trackingId(), other.trackingId());
    }

    public final String toString() {
        return ToString.builder((String)"Dataset").add("Name", (Object)this.name()).add("DatasetArn", (Object)this.datasetArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("DatasetType", (Object)this.datasetType()).add("SchemaArn", (Object)this.schemaArn()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("LatestDatasetUpdate", (Object)this.latestDatasetUpdate()).add("TrackingId", (Object)this.trackingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "datasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetType()));
            }
            case "schemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "latestDatasetUpdate": {
                return Optional.ofNullable(clazz.cast(this.latestDatasetUpdate()));
            }
            case "trackingId": {
                return Optional.ofNullable(clazz.cast(this.trackingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Dataset, T> g) {
        return obj -> g.apply((Dataset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String datasetArn;
        private String datasetGroupArn;
        private String datasetType;
        private String schemaArn;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private DatasetUpdateSummary latestDatasetUpdate;
        private String trackingId;

        private BuilderImpl() {
        }

        private BuilderImpl(Dataset model) {
            this.name(model.name);
            this.datasetArn(model.datasetArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.datasetType(model.datasetType);
            this.schemaArn(model.schemaArn);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.latestDatasetUpdate(model.latestDatasetUpdate);
            this.trackingId(model.trackingId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final DatasetUpdateSummary.Builder getLatestDatasetUpdate() {
            return this.latestDatasetUpdate != null ? this.latestDatasetUpdate.toBuilder() : null;
        }

        public final void setLatestDatasetUpdate(DatasetUpdateSummary.BuilderImpl latestDatasetUpdate) {
            this.latestDatasetUpdate = latestDatasetUpdate != null ? latestDatasetUpdate.build() : null;
        }

        @Override
        public final Builder latestDatasetUpdate(DatasetUpdateSummary latestDatasetUpdate) {
            this.latestDatasetUpdate = latestDatasetUpdate;
            return this;
        }

        public final String getTrackingId() {
            return this.trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public Dataset build() {
            return new Dataset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dataset> {
        public Builder name(String var1);

        public Builder datasetArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder datasetType(String var1);

        public Builder schemaArn(String var1);

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder latestDatasetUpdate(DatasetUpdateSummary var1);

        default public Builder latestDatasetUpdate(Consumer<DatasetUpdateSummary.Builder> latestDatasetUpdate) {
            return this.latestDatasetUpdate((DatasetUpdateSummary)((DatasetUpdateSummary.Builder)DatasetUpdateSummary.builder().applyMutation(latestDatasetUpdate)).build());
        }

        public Builder trackingId(String var1);
    }
}

