/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventTracker
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventTracker> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EventTracker.getter(EventTracker::name)).setter(EventTracker.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> EVENT_TRACKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTrackerArn").getter(EventTracker.getter(EventTracker::eventTrackerArn)).setter(EventTracker.setter(Builder::eventTrackerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrackerArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(EventTracker.getter(EventTracker::accountId)).setter(EventTracker.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackingId").getter(EventTracker.getter(EventTracker::trackingId)).setter(EventTracker.setter(Builder::trackingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(EventTracker.getter(EventTracker::datasetGroupArn)).setter(EventTracker.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EventTracker.getter(EventTracker::status)).setter(EventTracker.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(EventTracker.getter(EventTracker::creationDateTime)).setter(EventTracker.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(EventTracker.getter(EventTracker::lastUpdatedDateTime)).setter(EventTracker.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EVENT_TRACKER_ARN_FIELD, ACCOUNT_ID_FIELD, TRACKING_ID_FIELD, DATASET_GROUP_ARN_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("eventTrackerArn", EVENT_TRACKER_ARN_FIELD);
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("trackingId", TRACKING_ID_FIELD);
            this.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String eventTrackerArn;
    private final String accountId;
    private final String trackingId;
    private final String datasetGroupArn;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private EventTracker(BuilderImpl builder) {
        this.name = builder.name;
        this.eventTrackerArn = builder.eventTrackerArn;
        this.accountId = builder.accountId;
        this.trackingId = builder.trackingId;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String name() {
        return this.name;
    }

    public final String eventTrackerArn() {
        return this.eventTrackerArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String trackingId() {
        return this.trackingId;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTrackerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTracker)) {
            return false;
        }
        EventTracker other = (EventTracker)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.eventTrackerArn(), other.eventTrackerArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.trackingId(), other.trackingId()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"EventTracker").add("Name", (Object)this.name()).add("EventTrackerArn", (Object)this.eventTrackerArn()).add("AccountId", (Object)this.accountId()).add("TrackingId", (Object)this.trackingId()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "eventTrackerArn": {
                return Optional.ofNullable(clazz.cast(this.eventTrackerArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "trackingId": {
                return Optional.ofNullable(clazz.cast(this.trackingId()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventTracker, T> g) {
        return obj -> g.apply((EventTracker)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String eventTrackerArn;
        private String accountId;
        private String trackingId;
        private String datasetGroupArn;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTracker model) {
            this.name(model.name);
            this.eventTrackerArn(model.eventTrackerArn);
            this.accountId(model.accountId);
            this.trackingId(model.trackingId);
            this.datasetGroupArn(model.datasetGroupArn);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEventTrackerArn() {
            return this.eventTrackerArn;
        }

        public final void setEventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
        }

        @Override
        public final Builder eventTrackerArn(String eventTrackerArn) {
            this.eventTrackerArn = eventTrackerArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getTrackingId() {
            return this.trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public EventTracker build() {
            return new EventTracker(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventTracker> {
        public Builder name(String var1);

        public Builder eventTrackerArn(String var1);

        public Builder accountId(String var1);

        public Builder trackingId(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

