/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.RecommenderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommenderSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommenderSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RecommenderSummary.getter(RecommenderSummary::name)).setter(RecommenderSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECOMMENDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommenderArn").getter(RecommenderSummary.getter(RecommenderSummary::recommenderArn)).setter(RecommenderSummary.setter(Builder::recommenderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(RecommenderSummary.getter(RecommenderSummary::datasetGroupArn)).setter(RecommenderSummary.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeArn").getter(RecommenderSummary.getter(RecommenderSummary::recipeArn)).setter(RecommenderSummary.setter(Builder::recipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()}).build();
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommenderConfig").getter(RecommenderSummary.getter(RecommenderSummary::recommenderConfig)).setter(RecommenderSummary.setter(Builder::recommenderConfig)).constructor(RecommenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommenderConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RecommenderSummary.getter(RecommenderSummary::status)).setter(RecommenderSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(RecommenderSummary.getter(RecommenderSummary::creationDateTime)).setter(RecommenderSummary.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(RecommenderSummary.getter(RecommenderSummary::lastUpdatedDateTime)).setter(RecommenderSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RECOMMENDER_ARN_FIELD, DATASET_GROUP_ARN_FIELD, RECIPE_ARN_FIELD, RECOMMENDER_CONFIG_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("recommenderArn", RECOMMENDER_ARN_FIELD);
            this.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
            this.put("recipeArn", RECIPE_ARN_FIELD);
            this.put("recommenderConfig", RECOMMENDER_CONFIG_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creationDateTime", CREATION_DATE_TIME_FIELD);
            this.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String recommenderArn;
    private final String datasetGroupArn;
    private final String recipeArn;
    private final RecommenderConfig recommenderConfig;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private RecommenderSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.recommenderArn = builder.recommenderArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.recipeArn = builder.recipeArn;
        this.recommenderConfig = builder.recommenderConfig;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String name() {
        return this.name;
    }

    public final String recommenderArn() {
        return this.recommenderArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final String recipeArn() {
        return this.recipeArn;
    }

    public final RecommenderConfig recommenderConfig() {
        return this.recommenderConfig;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderSummary)) {
            return false;
        }
        RecommenderSummary other = (RecommenderSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.recommenderArn(), other.recommenderArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.recipeArn(), other.recipeArn()) && Objects.equals(this.recommenderConfig(), other.recommenderConfig()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"RecommenderSummary").add("Name", (Object)this.name()).add("RecommenderArn", (Object)this.recommenderArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("RecipeArn", (Object)this.recipeArn()).add("RecommenderConfig", (Object)this.recommenderConfig()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recommenderArn": {
                return Optional.ofNullable(clazz.cast(this.recommenderArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "recipeArn": {
                return Optional.ofNullable(clazz.cast(this.recipeArn()));
            }
            case "recommenderConfig": {
                return Optional.ofNullable(clazz.cast(this.recommenderConfig()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecommenderSummary, T> g) {
        return obj -> g.apply((RecommenderSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String recommenderArn;
        private String datasetGroupArn;
        private String recipeArn;
        private RecommenderConfig recommenderConfig;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderSummary model) {
            this.name(model.name);
            this.recommenderArn(model.recommenderArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.recipeArn(model.recipeArn);
            this.recommenderConfig(model.recommenderConfig);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecommenderArn() {
            return this.recommenderArn;
        }

        public final void setRecommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
        }

        @Override
        public final Builder recommenderArn(String recommenderArn) {
            this.recommenderArn = recommenderArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getRecipeArn() {
            return this.recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return this.recommenderConfig != null ? this.recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public RecommenderSummary build() {
            return new RecommenderSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommenderSummary> {
        public Builder name(String var1);

        public Builder recommenderArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder recipeArn(String var1);

        public Builder recommenderConfig(RecommenderConfig var1);

        default public Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return this.recommenderConfig((RecommenderConfig)((RecommenderConfig.Builder)RecommenderConfig.builder().applyMutation(recommenderConfig)).build());
        }

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

