/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse;

public class ListDatasetImportJobsIterable
implements SdkIterable<ListDatasetImportJobsResponse> {
    private final PersonalizeClient client;
    private final ListDatasetImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetImportJobsIterable(PersonalizeClient client, ListDatasetImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatasetImportJobsResponseFetcher();
    }

    public Iterator<ListDatasetImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatasetImportJobSummary> datasetImportJobs() {
        Function<ListDatasetImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetImportJobs() != null) {
                return response.datasetImportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetImportJobsResponseFetcher
    implements SyncPageFetcher<ListDatasetImportJobsResponse> {
        private ListDatasetImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetImportJobsResponse nextPage(ListDatasetImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetImportJobsIterable.this.client.listDatasetImportJobs(ListDatasetImportJobsIterable.this.firstRequest);
            }
            return ListDatasetImportJobsIterable.this.client.listDatasetImportJobs((ListDatasetImportJobsRequest)((Object)ListDatasetImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

