/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the hyperparameters and their ranges. Hyperparameters can be categorical, continuous, or integer-valued.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterRanges implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterRanges.Builder, HyperParameterRanges> {
    private static final SdkField<List<IntegerHyperParameterRange>> INTEGER_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<IntegerHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("integerHyperParameterRanges")
            .getter(getter(HyperParameterRanges::integerHyperParameterRanges))
            .setter(setter(Builder::integerHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegerHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegerHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContinuousHyperParameterRange>> CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<ContinuousHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("continuousHyperParameterRanges")
            .getter(getter(HyperParameterRanges::continuousHyperParameterRanges))
            .setter(setter(Builder::continuousHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuousHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContinuousHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContinuousHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CategoricalHyperParameterRange>> CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD = SdkField
            .<List<CategoricalHyperParameterRange>> builder(MarshallingType.LIST)
            .memberName("categoricalHyperParameterRanges")
            .getter(getter(HyperParameterRanges::categoricalHyperParameterRanges))
            .setter(setter(Builder::categoricalHyperParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoricalHyperParameterRanges")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoricalHyperParameterRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoricalHyperParameterRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGER_HYPER_PARAMETER_RANGES_FIELD, CONTINUOUS_HYPER_PARAMETER_RANGES_FIELD,
            CATEGORICAL_HYPER_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<IntegerHyperParameterRange> integerHyperParameterRanges;

    private final List<ContinuousHyperParameterRange> continuousHyperParameterRanges;

    private final List<CategoricalHyperParameterRange> categoricalHyperParameterRanges;

    private HyperParameterRanges(BuilderImpl builder) {
        this.integerHyperParameterRanges = builder.integerHyperParameterRanges;
        this.continuousHyperParameterRanges = builder.continuousHyperParameterRanges;
        this.categoricalHyperParameterRanges = builder.categoricalHyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerHyperParameterRanges property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIntegerHyperParameterRanges() {
        return integerHyperParameterRanges != null && !(integerHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The integer-valued hyperparameters and their ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerHyperParameterRanges} method.
     * </p>
     * 
     * @return The integer-valued hyperparameters and their ranges.
     */
    public final List<IntegerHyperParameterRange> integerHyperParameterRanges() {
        return integerHyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContinuousHyperParameterRanges property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContinuousHyperParameterRanges() {
        return continuousHyperParameterRanges != null && !(continuousHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The continuous hyperparameters and their ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContinuousHyperParameterRanges} method.
     * </p>
     * 
     * @return The continuous hyperparameters and their ranges.
     */
    public final List<ContinuousHyperParameterRange> continuousHyperParameterRanges() {
        return continuousHyperParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoricalHyperParameterRanges
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCategoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges != null && !(categoricalHyperParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categorical hyperparameters and their ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoricalHyperParameterRanges}
     * method.
     * </p>
     * 
     * @return The categorical hyperparameters and their ranges.
     */
    public final List<CategoricalHyperParameterRange> categoricalHyperParameterRanges() {
        return categoricalHyperParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerHyperParameterRanges() ? integerHyperParameterRanges() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasContinuousHyperParameterRanges() ? continuousHyperParameterRanges() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCategoricalHyperParameterRanges() ? categoricalHyperParameterRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterRanges)) {
            return false;
        }
        HyperParameterRanges other = (HyperParameterRanges) obj;
        return hasIntegerHyperParameterRanges() == other.hasIntegerHyperParameterRanges()
                && Objects.equals(integerHyperParameterRanges(), other.integerHyperParameterRanges())
                && hasContinuousHyperParameterRanges() == other.hasContinuousHyperParameterRanges()
                && Objects.equals(continuousHyperParameterRanges(), other.continuousHyperParameterRanges())
                && hasCategoricalHyperParameterRanges() == other.hasCategoricalHyperParameterRanges()
                && Objects.equals(categoricalHyperParameterRanges(), other.categoricalHyperParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("HyperParameterRanges")
                .add("IntegerHyperParameterRanges", hasIntegerHyperParameterRanges() ? integerHyperParameterRanges() : null)
                .add("ContinuousHyperParameterRanges",
                        hasContinuousHyperParameterRanges() ? continuousHyperParameterRanges() : null)
                .add("CategoricalHyperParameterRanges",
                        hasCategoricalHyperParameterRanges() ? categoricalHyperParameterRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integerHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(integerHyperParameterRanges()));
        case "continuousHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(continuousHyperParameterRanges()));
        case "categoricalHyperParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalHyperParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterRanges, T> g) {
        return obj -> g.apply((HyperParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterRanges> {
        /**
         * <p>
         * The integer-valued hyperparameters and their ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(Collection<IntegerHyperParameterRange> integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their ranges.
         * </p>
         * 
         * @param integerHyperParameterRanges
         *        The integer-valued hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHyperParameterRanges(IntegerHyperParameterRange... integerHyperParameterRanges);

        /**
         * <p>
         * The integer-valued hyperparameters and their ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #integerHyperParameterRanges(List<IntegerHyperParameterRange>)}.
         * 
         * @param integerHyperParameterRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.IntegerHyperParameterRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerHyperParameterRanges(java.util.Collection<IntegerHyperParameterRange>)
         */
        Builder integerHyperParameterRanges(Consumer<IntegerHyperParameterRange.Builder>... integerHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(Collection<ContinuousHyperParameterRange> continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their ranges.
         * </p>
         * 
         * @param continuousHyperParameterRanges
         *        The continuous hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousHyperParameterRanges(ContinuousHyperParameterRange... continuousHyperParameterRanges);

        /**
         * <p>
         * The continuous hyperparameters and their ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #continuousHyperParameterRanges(List<ContinuousHyperParameterRange>)}.
         * 
         * @param continuousHyperParameterRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.ContinuousHyperParameterRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousHyperParameterRanges(java.util.Collection<ContinuousHyperParameterRange>)
         */
        Builder continuousHyperParameterRanges(Consumer<ContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(Collection<CategoricalHyperParameterRange> categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their ranges.
         * </p>
         * 
         * @param categoricalHyperParameterRanges
         *        The categorical hyperparameters and their ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalHyperParameterRanges(CategoricalHyperParameterRange... categoricalHyperParameterRanges);

        /**
         * <p>
         * The categorical hyperparameters and their ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #categoricalHyperParameterRanges(List<CategoricalHyperParameterRange>)}.
         * 
         * @param categoricalHyperParameterRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.CategoricalHyperParameterRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalHyperParameterRanges(java.util.Collection<CategoricalHyperParameterRange>)
         */
        Builder categoricalHyperParameterRanges(
                Consumer<CategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<IntegerHyperParameterRange> integerHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<ContinuousHyperParameterRange> continuousHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private List<CategoricalHyperParameterRange> categoricalHyperParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterRanges model) {
            integerHyperParameterRanges(model.integerHyperParameterRanges);
            continuousHyperParameterRanges(model.continuousHyperParameterRanges);
            categoricalHyperParameterRanges(model.categoricalHyperParameterRanges);
        }

        public final List<IntegerHyperParameterRange.Builder> getIntegerHyperParameterRanges() {
            List<IntegerHyperParameterRange.Builder> result = IntegerHyperParameterRangesCopier
                    .copyToBuilder(this.integerHyperParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegerHyperParameterRanges(
                Collection<IntegerHyperParameterRange.BuilderImpl> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = IntegerHyperParameterRangesCopier.copyFromBuilder(integerHyperParameterRanges);
        }

        @Override
        public final Builder integerHyperParameterRanges(Collection<IntegerHyperParameterRange> integerHyperParameterRanges) {
            this.integerHyperParameterRanges = IntegerHyperParameterRangesCopier.copy(integerHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(IntegerHyperParameterRange... integerHyperParameterRanges) {
            integerHyperParameterRanges(Arrays.asList(integerHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerHyperParameterRanges(
                Consumer<IntegerHyperParameterRange.Builder>... integerHyperParameterRanges) {
            integerHyperParameterRanges(Stream.of(integerHyperParameterRanges)
                    .map(c -> IntegerHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContinuousHyperParameterRange.Builder> getContinuousHyperParameterRanges() {
            List<ContinuousHyperParameterRange.Builder> result = ContinuousHyperParameterRangesCopier
                    .copyToBuilder(this.continuousHyperParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContinuousHyperParameterRanges(
                Collection<ContinuousHyperParameterRange.BuilderImpl> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = ContinuousHyperParameterRangesCopier
                    .copyFromBuilder(continuousHyperParameterRanges);
        }

        @Override
        public final Builder continuousHyperParameterRanges(
                Collection<ContinuousHyperParameterRange> continuousHyperParameterRanges) {
            this.continuousHyperParameterRanges = ContinuousHyperParameterRangesCopier.copy(continuousHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(ContinuousHyperParameterRange... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Arrays.asList(continuousHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousHyperParameterRanges(
                Consumer<ContinuousHyperParameterRange.Builder>... continuousHyperParameterRanges) {
            continuousHyperParameterRanges(Stream.of(continuousHyperParameterRanges)
                    .map(c -> ContinuousHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CategoricalHyperParameterRange.Builder> getCategoricalHyperParameterRanges() {
            List<CategoricalHyperParameterRange.Builder> result = CategoricalHyperParameterRangesCopier
                    .copyToBuilder(this.categoricalHyperParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoricalHyperParameterRanges(
                Collection<CategoricalHyperParameterRange.BuilderImpl> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = CategoricalHyperParameterRangesCopier
                    .copyFromBuilder(categoricalHyperParameterRanges);
        }

        @Override
        public final Builder categoricalHyperParameterRanges(
                Collection<CategoricalHyperParameterRange> categoricalHyperParameterRanges) {
            this.categoricalHyperParameterRanges = CategoricalHyperParameterRangesCopier.copy(categoricalHyperParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(CategoricalHyperParameterRange... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Arrays.asList(categoricalHyperParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalHyperParameterRanges(
                Consumer<CategoricalHyperParameterRange.Builder>... categoricalHyperParameterRanges) {
            categoricalHyperParameterRanges(Stream.of(categoricalHyperParameterRanges)
                    .map(c -> CategoricalHyperParameterRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HyperParameterRanges build() {
            return new HyperParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
