/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.CreateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetResponse;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.CreateFilterRequest;
import software.amazon.awssdk.services.personalize.model.CreateFilterResponse;
import software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.CreateRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.CreateSchemaRequest;
import software.amazon.awssdk.services.personalize.model.CreateSchemaResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DeleteFilterRequest;
import software.amazon.awssdk.services.personalize.model.DeleteFilterResponse;
import software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.DeleteRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFilterRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFilterResponse;
import software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.InvalidInputException;
import software.amazon.awssdk.services.personalize.model.InvalidNextTokenException;
import software.amazon.awssdk.services.personalize.model.LimitExceededException;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListCampaignsRequest;
import software.amazon.awssdk.services.personalize.model.ListCampaignsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetsResponse;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse;
import software.amazon.awssdk.services.personalize.model.ListFiltersRequest;
import software.amazon.awssdk.services.personalize.model.ListFiltersResponse;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse;
import software.amazon.awssdk.services.personalize.model.ListRecipesRequest;
import software.amazon.awssdk.services.personalize.model.ListRecipesResponse;
import software.amazon.awssdk.services.personalize.model.ListRecommendersRequest;
import software.amazon.awssdk.services.personalize.model.ListRecommendersResponse;
import software.amazon.awssdk.services.personalize.model.ListSchemasRequest;
import software.amazon.awssdk.services.personalize.model.ListSchemasResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionsResponse;
import software.amazon.awssdk.services.personalize.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.personalize.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.personalize.model.PersonalizeException;
import software.amazon.awssdk.services.personalize.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.personalize.model.ResourceInUseException;
import software.amazon.awssdk.services.personalize.model.ResourceNotFoundException;
import software.amazon.awssdk.services.personalize.model.StartRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.StartRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.StopRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.StopRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest;
import software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationResponse;
import software.amazon.awssdk.services.personalize.model.TagResourceRequest;
import software.amazon.awssdk.services.personalize.model.TagResourceResponse;
import software.amazon.awssdk.services.personalize.model.TooManyTagKeysException;
import software.amazon.awssdk.services.personalize.model.TooManyTagsException;
import software.amazon.awssdk.services.personalize.model.UntagResourceRequest;
import software.amazon.awssdk.services.personalize.model.UntagResourceResponse;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse;
import software.amazon.awssdk.services.personalize.transform.CreateBatchInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateBatchSegmentJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetExportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSolutionVersionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeBatchInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeBatchSegmentJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetExportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeFeatureTransformationRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeRecipeRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSolutionVersionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.GetSolutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListBatchInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListBatchSegmentJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetGroupsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListEventTrackersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListMetricAttributionMetricsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListMetricAttributionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListRecipesRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListRecommendersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSolutionVersionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSolutionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.StartRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.StopRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.StopSolutionVersionCreationRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateRecommenderRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link PersonalizeAsyncClient}.
 *
 * @see PersonalizeAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPersonalizeAsyncClient implements PersonalizeAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPersonalizeAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final PersonalizeServiceClientConfiguration serviceClientConfiguration;

    protected DefaultPersonalizeAsyncClient(PersonalizeServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a batch inference job. The operation can handle up to 50 million records and the input file must be in
     * JSON format. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/creating-batch-inference-job.html">Creating a batch
     * inference job</a>.
     * </p>
     *
     * @param createBatchInferenceJobRequest
     * @return A Java Future containing the result of the CreateBatchInferenceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateBatchInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBatchInferenceJobResponse> createBatchInferenceJob(
            CreateBatchInferenceJobRequest createBatchInferenceJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBatchInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBatchInferenceJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBatchInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBatchInferenceJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBatchInferenceJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBatchInferenceJobRequest, CreateBatchInferenceJobResponse>()
                            .withOperationName("CreateBatchInferenceJob")
                            .withMarshaller(new CreateBatchInferenceJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBatchInferenceJobRequest));
            CompletableFuture<CreateBatchInferenceJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON
     * format. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html">Getting batch recommendations
     * and user segments</a>.
     * </p>
     *
     * @param createBatchSegmentJobRequest
     * @return A Java Future containing the result of the CreateBatchSegmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateBatchSegmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchSegmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBatchSegmentJobResponse> createBatchSegmentJob(
            CreateBatchSegmentJobRequest createBatchSegmentJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBatchSegmentJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBatchSegmentJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBatchSegmentJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBatchSegmentJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBatchSegmentJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBatchSegmentJobRequest, CreateBatchSegmentJobResponse>()
                            .withOperationName("CreateBatchSegmentJob")
                            .withMarshaller(new CreateBatchSegmentJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBatchSegmentJobRequest));
            CompletableFuture<CreateBatchSegmentJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a campaign that deploys a solution version. When a client calls the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * and <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html">
     * GetPersonalizedRanking</a> APIs, a campaign is specified in the request.
     * </p>
     * <p>
     * <b>Minimum Provisioned TPS and Auto-Scaling</b>
     * </p>
     * <important>
     * <p>
     * A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for
     * <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * </important>
     * <p>
     * A transaction is a single <code>GetRecommendations</code> or <code>GetPersonalizedRanking</code> call.
     * Transactions per second (TPS) is the throughput and unit of billing for Amazon Personalize. The minimum
     * provisioned TPS (<code>minProvisionedTPS</code>) specifies the baseline throughput provisioned by Amazon
     * Personalize, and thus, the minimum billing charge.
     * </p>
     * <p>
     * If your TPS increases beyond <code>minProvisionedTPS</code>, Amazon Personalize auto-scales the provisioned
     * capacity up and down, but never below <code>minProvisionedTPS</code>. There's a short time delay while the
     * capacity is increased that might cause loss of transactions.
     * </p>
     * <p>
     * The actual TPS used is calculated as the average requests/second within a 5-minute window. You pay for maximum of
     * either the minimum provisioned TPS or the actual TPS. We recommend starting with a low
     * <code>minProvisionedTPS</code>, track your usage using Amazon CloudWatch metrics, and then increase the
     * <code>minProvisionedTPS</code> as necessary.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the campaign status, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>.
     * </p>
     * <note>
     * <p>
     * Wait until the <code>status</code> of the campaign is <code>ACTIVE</code> before asking the campaign for
     * recommendations.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html">UpdateCampaign</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html">DeleteCampaign</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createCampaignRequest
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                            .withOperationName("CreateCampaign")
                            .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCampaignRequest));
            CompletableFuture<CreateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty dataset and adds it to the specified dataset group. Use <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a> to import your training data to a dataset.
     * </p>
     * <p>
     * There are three types of datasets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each dataset type has an associated schema with required field types. Only the <code>Interactions</code> dataset
     * is required in order to train a model (also referred to as creating a solution).
     * </p>
     * <p>
     * A dataset can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the dataset, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html">ListDatasets</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html">DeleteDataset</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDatasetRequest
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDatasetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDatasetRequest, CreateDatasetResponse>()
                            .withOperationName("CreateDataset")
                            .withMarshaller(new CreateDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDatasetRequest));
            CompletableFuture<CreateDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export
     * the training data, you must specify an service-linked IAM role that gives Amazon Personalize
     * <code>PutObject</code> permissions for your Amazon S3 bucket. For information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/export-data.html">Exporting a dataset</a> in the Amazon
     * Personalize developer guide.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A dataset export job can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the export job, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html"
     * >DescribeDatasetExportJob</a>, and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset
     * export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a
     * <code>failureReason</code> key, which describes why the job failed.
     * </p>
     *
     * @param createDatasetExportJobRequest
     * @return A Java Future containing the result of the CreateDatasetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateDatasetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDatasetExportJobResponse> createDatasetExportJob(
            CreateDatasetExportJobRequest createDatasetExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatasetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDatasetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDatasetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDatasetExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDatasetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDatasetExportJobRequest, CreateDatasetExportJobResponse>()
                            .withOperationName("CreateDatasetExportJob")
                            .withMarshaller(new CreateDatasetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDatasetExportJobRequest));
            CompletableFuture<CreateDatasetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group
     * can contain at most three datasets, one for each type of dataset:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Interactions
     * </p>
     * </li>
     * <li>
     * <p>
     * Items
     * </p>
     * </li>
     * <li>
     * <p>
     * Users
     * </p>
     * </li>
     * </ul>
     * <p>
     * A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like
     * recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution
     * version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom
     * resources such as solutions and solution versions trained with recipes for custom use cases and deployed with
     * campaigns.
     * </p>
     * <p>
     * A dataset group can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the dataset group, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>.
     * If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why
     * the creation failed.
     * </p>
     * <note>
     * <p>
     * You must wait until the <code>status</code> of the dataset group is <code>ACTIVE</code> before adding a dataset
     * to the group.
     * </p>
     * </note>
     * <p>
     * You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS
     * key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.
     * </p>
     * <p class="title">
     * <b>APIs that require a dataset group ARN in the request</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * </li>
     * </ul>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html">ListDatasetGroups</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html">DeleteDatasetGroup</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDatasetGroupRequest
     * @return A Java Future containing the result of the CreateDatasetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDatasetGroupResponse> createDatasetGroup(CreateDatasetGroupRequest createDatasetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatasetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDatasetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDatasetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDatasetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDatasetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDatasetGroupRequest, CreateDatasetGroupResponse>()
                            .withOperationName("CreateDatasetGroup")
                            .withMarshaller(new CreateDatasetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDatasetGroupRequest));
            CompletableFuture<CreateDatasetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize
     * dataset. To allow Amazon Personalize to ACTIVE -or- CREATE FAILED
     * </p>
     * </li> </ul>
     * <p>
     * To get the status of the import job, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a>, providing the Amazon Resource Name (ARN) of the dataset import job. The dataset
     * import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a
     * <code>failureReason</code> key, which describes why the job failed.
     * </p>
     * <note>
     * <p>
     * Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html">
     * DescribeDatasetImportJob</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDatasetImportJobRequest
     * @return A Java Future containing the result of the CreateDatasetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDatasetImportJobResponse> createDatasetImportJob(
            CreateDatasetImportJobRequest createDatasetImportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatasetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDatasetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDatasetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDatasetImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDatasetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDatasetImportJobRequest, CreateDatasetImportJobResponse>()
                            .withOperationName("CreateDatasetImportJob")
                            .withMarshaller(new CreateDatasetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDatasetImportJobRequest));
            CompletableFuture<CreateDatasetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an event tracker that you use when adding event data to a specified dataset group using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.
     * </p>
     * <note>
     * <p>
     * Only one event tracker can be associated with a dataset group. You will get an error if you call
     * <code>CreateEventTracker</code> using the same dataset group as an existing event tracker.
     * </p>
     * </note>
     * <p>
     * When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use
     * the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> operation.
     * Amazon Personalize then appends the event data to the Interactions dataset of the dataset group you specify in
     * your event tracker.
     * </p>
     * <p>
     * The event tracker can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the event tracker, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>.
     * </p>
     * <note>
     * <p>
     * The event tracker must be in the ACTIVE state before using the tracking ID.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html">ListEventTrackers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html">DeleteEventTracker</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventTrackerRequest
     * @return A Java Future containing the result of the CreateEventTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventTrackerResponse> createEventTracker(CreateEventTrackerRequest createEventTrackerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventTrackerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventTracker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventTrackerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEventTrackerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEventTrackerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventTrackerRequest, CreateEventTrackerResponse>()
                            .withOperationName("CreateEventTracker")
                            .withMarshaller(new CreateEventTrackerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEventTrackerRequest));
            CompletableFuture<CreateEventTrackerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a recommendation filter. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user
     * segments</a>.
     * </p>
     *
     * @param createFilterRequest
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFilterResponse> createFilter(CreateFilterRequest createFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFilterRequest, CreateFilterResponse>()
                            .withOperationName("CreateFilter").withMarshaller(new CreateFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFilterRequest));
            CompletableFuture<CreateFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon
     * Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of
     * recommendations</a>.
     * </p>
     *
     * @param createMetricAttributionRequest
     * @return A Java Future containing the result of the CreateMetricAttribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateMetricAttribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateMetricAttribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMetricAttributionResponse> createMetricAttribution(
            CreateMetricAttributionRequest createMetricAttributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMetricAttributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMetricAttribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMetricAttributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMetricAttributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMetricAttributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMetricAttributionRequest, CreateMetricAttributionResponse>()
                            .withOperationName("CreateMetricAttribution")
                            .withMarshaller(new CreateMetricAttributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createMetricAttributionRequest));
            CompletableFuture<CreateMetricAttributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for
     * a Domain dataset group and specify the recommender's Amazon Resource Name (ARN) when you make a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request.
     * </p>
     * <p>
     * <b>Minimum recommendation requests per second</b>
     * </p>
     * <important>
     * <p>
     * A high <code>minRecommendationRequestsPerSecond</code> will increase your bill. We recommend starting with 1 for
     * <code>minRecommendationRequestsPerSecond</code> (the default). Track your usage using Amazon CloudWatch metrics,
     * and increase the <code>minRecommendationRequestsPerSecond</code> as necessary.
     * </p>
     * </important>
     * <p>
     * When you create a recommender, you can configure the recommender's minimum recommendation requests per second.
     * The minimum recommendation requests per second (<code>minRecommendationRequestsPerSecond</code>) specifies the
     * baseline recommendation request throughput provisioned by Amazon Personalize. The default
     * minRecommendationRequestsPerSecond is <code>1</code>. A recommendation request is a single
     * <code>GetRecommendations</code> operation. Request throughput is measured in requests per second and Amazon
     * Personalize uses your requests per second to derive your requests per hour and the price of your recommender
     * usage.
     * </p>
     * <p>
     * If your requests per second increases beyond <code>minRecommendationRequestsPerSecond</code>, Amazon Personalize
     * auto-scales the provisioned capacity up and down, but never below <code>minRecommendationRequestsPerSecond</code>
     * . There's a short time delay while the capacity is increased that might cause loss of requests.
     * </p>
     * <p>
     * Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or
     * the actual number of requests. The actual request throughput used is calculated as the average requests/second
     * within a one-hour window. We recommend starting with the default <code>minRecommendationRequestsPerSecond</code>,
     * track your usage using Amazon CloudWatch metrics, and then increase the
     * <code>minRecommendationRequestsPerSecond</code> as necessary.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP PENDING &gt; STOP IN_PROGRESS &gt; INACTIVE &gt; START PENDING &gt; START IN_PROGRESS &gt; ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the recommender status, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>.
     * </p>
     * <note>
     * <p>
     * Wait until the <code>status</code> of the recommender is <code>ACTIVE</code> before asking the recommender for
     * recommendations.
     * </p>
     * </note>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html">ListRecommenders</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html">UpdateRecommender</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html">DeleteRecommender</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createRecommenderRequest
     * @return A Java Future containing the result of the CreateRecommender operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRecommenderResponse> createRecommender(CreateRecommenderRequest createRecommenderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRecommenderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommender");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRecommenderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRecommenderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRecommenderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRecommenderRequest, CreateRecommenderResponse>()
                            .withOperationName("CreateRecommender")
                            .withMarshaller(new CreateRecommenderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRecommenderRequest));
            CompletableFuture<CreateRecommenderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON
     * format.
     * </p>
     * <p>
     * Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set
     * of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide
     * the domain of the Domain dataset group. You specify a schema when you call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html">ListSchemas</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html">DescribeSchema</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html">DeleteSchema</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSchemaRequest
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSchemaRequest, CreateSchemaResponse>()
                            .withOperationName("CreateSchema").withMarshaller(new CreateSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSchemaRequest));
            CompletableFuture<CreateSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the configuration for training a model. A trained model is known as a solution version. After the
     * configuration is created, you train the model (create a solution version) by calling the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a>
     * operation. Every time you call <code>CreateSolutionVersion</code>, a new version of the solution is created.
     * </p>
     * <p>
     * After creating a solution version, you check its accuracy by calling <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html">GetSolutionMetrics</a>. When
     * you are satisfied with the version, you deploy it using <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>. The campaign
     * provides recommendations to a client through the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * API.
     * </p>
     * <p>
     * To train a model, Amazon Personalize requires training data and a recipe. The training data comes from the
     * dataset group that you provide in the request. A recipe specifies the training algorithm and a feature
     * transformation. You can specify one of the predefined recipes provided by Amazon Personalize.
     * </p>
     * <note>
     * <p>
     * Amazon Personalize doesn't support configuring the <code>hpoObjective</code> for solution hyperparameter
     * optimization at this time.
     * </p>
     * </note>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A solution can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the solution, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>. Wait
     * until the status shows as ACTIVE before calling <code>CreateSolutionVersion</code>.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a>
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">
     * DescribeSolutionVersion</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSolutionRequest
     * @return A Java Future containing the result of the CreateSolution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSolutionResponse> createSolution(CreateSolutionRequest createSolutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSolutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSolution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSolutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSolutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSolutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSolutionRequest, CreateSolutionResponse>()
                            .withOperationName("CreateSolution")
                            .withMarshaller(new CreateSolutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSolutionRequest));
            CompletableFuture<CreateSolutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Trains or retrains an active solution in a Custom dataset group. A solution is created using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> operation and
     * must be in the ACTIVE state before calling <code>CreateSolutionVersion</code>. A new version of the solution is
     * created every time you call this operation.
     * </p>
     * <p>
     * <b>Status</b>
     * </p>
     * <p>
     * A solution version can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE IN_PROGRESS
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE STOPPING
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the status of the version, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html"
     * >DescribeSolutionVersion</a>. Wait until the status shows as ACTIVE before calling <code>CreateCampaign</code>.
     * </p>
     * <p>
     * If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why
     * the job failed.
     * </p>
     * <p class="title">
     * <b>Related APIs</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">
     * DescribeSolutionVersion</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSolutionVersionRequest
     * @return A Java Future containing the result of the CreateSolutionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.CreateSolutionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSolutionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSolutionVersionResponse> createSolutionVersion(
            CreateSolutionVersionRequest createSolutionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSolutionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSolutionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSolutionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSolutionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSolutionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSolutionVersionRequest, CreateSolutionVersionResponse>()
                            .withOperationName("CreateSolutionVersion")
                            .withMarshaller(new CreateSolutionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSolutionVersionRequest));
            CompletableFuture<CreateSolutionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted
     * and can be redeployed when needed. A deleted campaign can no longer be specified in a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request. For information on creating campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                            .withOperationName("DeleteCampaign")
                            .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCampaignRequest));
            CompletableFuture<DeleteCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dataset. You can't delete a dataset if an associated <code>DatasetImportJob</code> or
     * <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDatasetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDatasetRequest, DeleteDatasetResponse>()
                            .withOperationName("DeleteDataset")
                            .withMarshaller(new DeleteDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDatasetRequest));
            CompletableFuture<DeleteDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dataset group. Before you delete a dataset group, you must delete the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All associated event trackers.
     * </p>
     * </li>
     * <li>
     * <p>
     * All associated solutions.
     * </p>
     * </li>
     * <li>
     * <p>
     * All datasets in the dataset group.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteDatasetGroupRequest
     * @return A Java Future containing the result of the DeleteDatasetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDatasetGroupResponse> deleteDatasetGroup(DeleteDatasetGroupRequest deleteDatasetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDatasetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDatasetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDatasetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDatasetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDatasetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDatasetGroupRequest, DeleteDatasetGroupResponse>()
                            .withOperationName("DeleteDatasetGroup")
                            .withMarshaller(new DeleteDatasetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDatasetGroupRequest));
            CompletableFuture<DeleteDatasetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the event tracker. Does not delete the event-interactions dataset from the associated dataset group. For
     * more information on event trackers, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     *
     * @param deleteEventTrackerRequest
     * @return A Java Future containing the result of the DeleteEventTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventTrackerResponse> deleteEventTracker(DeleteEventTrackerRequest deleteEventTrackerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventTrackerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventTracker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventTrackerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventTrackerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventTrackerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventTrackerRequest, DeleteEventTrackerResponse>()
                            .withOperationName("DeleteEventTracker")
                            .withMarshaller(new DeleteEventTrackerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEventTrackerRequest));
            CompletableFuture<DeleteEventTrackerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a filter.
     * </p>
     *
     * @param deleteFilterRequest
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFilterResponse> deleteFilter(DeleteFilterRequest deleteFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFilterRequest, DeleteFilterResponse>()
                            .withOperationName("DeleteFilter").withMarshaller(new DeleteFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFilterRequest));
            CompletableFuture<DeleteFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a metric attribution.
     * </p>
     *
     * @param deleteMetricAttributionRequest
     * @return A Java Future containing the result of the DeleteMetricAttribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteMetricAttribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteMetricAttribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMetricAttributionResponse> deleteMetricAttribution(
            DeleteMetricAttributionRequest deleteMetricAttributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMetricAttributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMetricAttribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMetricAttributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMetricAttributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMetricAttributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMetricAttributionRequest, DeleteMetricAttributionResponse>()
                            .withOperationName("DeleteMetricAttribution")
                            .withMarshaller(new DeleteMetricAttributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMetricAttributionRequest));
            CompletableFuture<DeleteMetricAttributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates and removes a recommender. A deleted recommender can no longer be specified in a <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * request.
     * </p>
     *
     * @param deleteRecommenderRequest
     * @return A Java Future containing the result of the DeleteRecommender operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRecommenderResponse> deleteRecommender(DeleteRecommenderRequest deleteRecommenderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRecommenderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommender");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRecommenderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRecommenderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRecommenderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommenderRequest, DeleteRecommenderResponse>()
                            .withOperationName("DeleteRecommender")
                            .withMarshaller(new DeleteRecommenderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRecommenderRequest));
            CompletableFuture<DeleteRecommenderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more
     * information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSchemaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSchemaRequest, DeleteSchemaResponse>()
                            .withOperationName("DeleteSchema").withMarshaller(new DeleteSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSchemaRequest));
            CompletableFuture<DeleteSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all versions of a solution and the <code>Solution</code> object itself. Before deleting a solution, you
     * must delete all campaigns based on the solution. To determine what campaigns are using the solution, call <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a> and supply the
     * Amazon Resource Name (ARN) of the solution. You can't delete a solution if an associated
     * <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on solutions,
     * see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     *
     * @param deleteSolutionRequest
     * @return A Java Future containing the result of the DeleteSolution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DeleteSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DeleteSolution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSolutionResponse> deleteSolution(DeleteSolutionRequest deleteSolutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSolutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSolution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSolutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSolutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSolutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSolutionRequest, DeleteSolutionResponse>()
                            .withOperationName("DeleteSolution")
                            .withMarshaller(new DeleteSolutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSolutionRequest));
            CompletableFuture<DeleteSolutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the given algorithm.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return A Java Future containing the result of the DescribeAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAlgorithmResponse> describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAlgorithmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAlgorithm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAlgorithmResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAlgorithmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAlgorithmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAlgorithmRequest, DescribeAlgorithmResponse>()
                            .withOperationName("DescribeAlgorithm")
                            .withMarshaller(new DescribeAlgorithmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAlgorithmRequest));
            CompletableFuture<DescribeAlgorithmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output
     * configurations, and the ARN of the solution version used to generate the recommendations.
     * </p>
     *
     * @param describeBatchInferenceJobRequest
     * @return A Java Future containing the result of the DescribeBatchInferenceJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeBatchInferenceJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchInferenceJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBatchInferenceJobResponse> describeBatchInferenceJob(
            DescribeBatchInferenceJobRequest describeBatchInferenceJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBatchInferenceJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBatchInferenceJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBatchInferenceJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBatchInferenceJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBatchInferenceJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBatchInferenceJobRequest, DescribeBatchInferenceJobResponse>()
                            .withOperationName("DescribeBatchInferenceJob")
                            .withMarshaller(new DescribeBatchInferenceJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBatchInferenceJobRequest));
            CompletableFuture<DescribeBatchInferenceJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output
     * configurations, and the ARN of the solution version used to generate segments.
     * </p>
     *
     * @param describeBatchSegmentJobRequest
     * @return A Java Future containing the result of the DescribeBatchSegmentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeBatchSegmentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeBatchSegmentJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBatchSegmentJobResponse> describeBatchSegmentJob(
            DescribeBatchSegmentJobRequest describeBatchSegmentJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBatchSegmentJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBatchSegmentJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBatchSegmentJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBatchSegmentJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBatchSegmentJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBatchSegmentJobRequest, DescribeBatchSegmentJobResponse>()
                            .withOperationName("DescribeBatchSegmentJob")
                            .withMarshaller(new DescribeBatchSegmentJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBatchSegmentJobRequest));
            CompletableFuture<DescribeBatchSegmentJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the given campaign, including its status.
     * </p>
     * <p>
     * A campaign can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code>
     * key, which describes why.
     * </p>
     * <p>
     * For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param describeCampaignRequest
     * @return A Java Future containing the result of the DescribeCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCampaignResponse> describeCampaign(DescribeCampaignRequest describeCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCampaignRequest, DescribeCampaignResponse>()
                            .withOperationName("DescribeCampaign")
                            .withMarshaller(new DescribeCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCampaignRequest));
            CompletableFuture<DescribeCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the given dataset. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param describeDatasetRequest
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDataset" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDatasetRequest, DescribeDatasetResponse>()
                            .withOperationName("DescribeDataset")
                            .withMarshaller(new DescribeDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDatasetRequest));
            CompletableFuture<DescribeDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the dataset export job created by <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>, including the export job status.
     * </p>
     *
     * @param describeDatasetExportJobRequest
     * @return A Java Future containing the result of the DescribeDatasetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeDatasetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDatasetExportJobResponse> describeDatasetExportJob(
            DescribeDatasetExportJobRequest describeDatasetExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDatasetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDatasetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDatasetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDatasetExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDatasetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDatasetExportJobRequest, DescribeDatasetExportJobResponse>()
                            .withOperationName("DescribeDatasetExportJob")
                            .withMarshaller(new DescribeDatasetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDatasetExportJobRequest));
            CompletableFuture<DescribeDatasetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the given dataset group. For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     *
     * @param describeDatasetGroupRequest
     * @return A Java Future containing the result of the DescribeDatasetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDatasetGroupResponse> describeDatasetGroup(
            DescribeDatasetGroupRequest describeDatasetGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDatasetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDatasetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDatasetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDatasetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDatasetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDatasetGroupRequest, DescribeDatasetGroupResponse>()
                            .withOperationName("DescribeDatasetGroup")
                            .withMarshaller(new DescribeDatasetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDatasetGroupRequest));
            CompletableFuture<DescribeDatasetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the dataset import job created by <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>, including the import job status.
     * </p>
     *
     * @param describeDatasetImportJobRequest
     * @return A Java Future containing the result of the DescribeDatasetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDatasetImportJobResponse> describeDatasetImportJob(
            DescribeDatasetImportJobRequest describeDatasetImportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDatasetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDatasetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDatasetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDatasetImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDatasetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDatasetImportJobRequest, DescribeDatasetImportJobResponse>()
                            .withOperationName("DescribeDatasetImportJob")
                            .withMarshaller(new DescribeDatasetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDatasetImportJobRequest));
            CompletableFuture<DescribeDatasetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an event tracker. The response includes the <code>trackingId</code> and <code>status</code> of the
     * event tracker. For more information on event trackers, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     *
     * @param describeEventTrackerRequest
     * @return A Java Future containing the result of the DescribeEventTracker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeEventTracker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeEventTracker"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventTrackerResponse> describeEventTracker(
            DescribeEventTrackerRequest describeEventTrackerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventTrackerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventTracker");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventTrackerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventTrackerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEventTrackerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventTrackerRequest, DescribeEventTrackerResponse>()
                            .withOperationName("DescribeEventTracker")
                            .withMarshaller(new DescribeEventTrackerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEventTrackerRequest));
            CompletableFuture<DescribeEventTrackerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the given feature transformation.
     * </p>
     *
     * @param describeFeatureTransformationRequest
     * @return A Java Future containing the result of the DescribeFeatureTransformation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeFeatureTransformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFeatureTransformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFeatureTransformationResponse> describeFeatureTransformation(
            DescribeFeatureTransformationRequest describeFeatureTransformationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFeatureTransformationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFeatureTransformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFeatureTransformationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFeatureTransformationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFeatureTransformationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFeatureTransformationRequest, DescribeFeatureTransformationResponse>()
                            .withOperationName("DescribeFeatureTransformation")
                            .withMarshaller(new DescribeFeatureTransformationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFeatureTransformationRequest));
            CompletableFuture<DescribeFeatureTransformationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a filter's properties.
     * </p>
     *
     * @param describeFilterRequest
     * @return A Java Future containing the result of the DescribeFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFilterResponse> describeFilter(DescribeFilterRequest describeFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFilterRequest, DescribeFilterResponse>()
                            .withOperationName("DescribeFilter")
                            .withMarshaller(new DescribeFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFilterRequest));
            CompletableFuture<DescribeFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a metric attribution.
     * </p>
     *
     * @param describeMetricAttributionRequest
     * @return A Java Future containing the result of the DescribeMetricAttribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeMetricAttribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeMetricAttribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetricAttributionResponse> describeMetricAttribution(
            DescribeMetricAttributionRequest describeMetricAttributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMetricAttributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetricAttribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetricAttributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMetricAttributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMetricAttributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetricAttributionRequest, DescribeMetricAttributionResponse>()
                            .withOperationName("DescribeMetricAttribution")
                            .withMarshaller(new DescribeMetricAttributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMetricAttributionRequest));
            CompletableFuture<DescribeMetricAttributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a recipe.
     * </p>
     * <p>
     * A recipe contains three items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An algorithm that trains a model.
     * </p>
     * </li>
     * <li>
     * <p>
     * Hyperparameters that govern the training.
     * </p>
     * </li>
     * <li>
     * <p>
     * Feature transformation information for modifying the input data before training.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the
     * <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> API.
     * <code>CreateSolution</code> trains a model by using the algorithm in the specified recipe and a training dataset.
     * The solution, when deployed as a campaign, can provide recommendations using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a>
     * API.
     * </p>
     *
     * @param describeRecipeRequest
     * @return A Java Future containing the result of the DescribeRecipe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeRecipe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecipe" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRecipeResponse> describeRecipe(DescribeRecipeRequest describeRecipeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecipeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecipe");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRecipeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRecipeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRecipeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRecipeRequest, DescribeRecipeResponse>()
                            .withOperationName("DescribeRecipe")
                            .withMarshaller(new DescribeRecipeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRecipeRequest));
            CompletableFuture<DescribeRecipeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the given recommender, including its status.
     * </p>
     * <p>
     * A recommender can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP PENDING &gt; STOP IN_PROGRESS &gt; INACTIVE &gt; START PENDING &gt; START IN_PROGRESS &gt; ACTIVE
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE PENDING &gt; DELETE IN_PROGRESS
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code>
     * key, which describes why.
     * </p>
     * <p>
     * The <code>modelMetrics</code> key is null when the recommender is being created or deleted.
     * </p>
     * <p>
     * For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     *
     * @param describeRecommenderRequest
     * @return A Java Future containing the result of the DescribeRecommender operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeRecommender"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRecommenderResponse> describeRecommender(
            DescribeRecommenderRequest describeRecommenderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecommenderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecommender");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRecommenderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRecommenderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRecommenderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRecommenderRequest, DescribeRecommenderResponse>()
                            .withOperationName("DescribeRecommender")
                            .withMarshaller(new DescribeRecommenderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRecommenderRequest));
            CompletableFuture<DescribeRecommenderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a schema. For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     *
     * @param describeSchemaRequest
     * @return A Java Future containing the result of the DescribeSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSchemaResponse> describeSchema(DescribeSchemaRequest describeSchemaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSchemaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSchemaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSchemaRequest, DescribeSchemaResponse>()
                            .withOperationName("DescribeSchema")
                            .withMarshaller(new DescribeSchemaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSchemaRequest));
            CompletableFuture<DescribeSchemaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a solution. For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     *
     * @param describeSolutionRequest
     * @return A Java Future containing the result of the DescribeSolution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeSolution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSolutionResponse> describeSolution(DescribeSolutionRequest describeSolutionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSolutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSolution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSolutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSolutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSolutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSolutionRequest, DescribeSolutionResponse>()
                            .withOperationName("DescribeSolution")
                            .withMarshaller(new DescribeSolutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSolutionRequest));
            CompletableFuture<DescribeSolutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a specific version of a solution. For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>
     * </p>
     *
     * @param describeSolutionVersionRequest
     * @return A Java Future containing the result of the DescribeSolutionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.DescribeSolutionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/DescribeSolutionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSolutionVersionResponse> describeSolutionVersion(
            DescribeSolutionVersionRequest describeSolutionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSolutionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSolutionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSolutionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSolutionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSolutionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSolutionVersionRequest, DescribeSolutionVersionResponse>()
                            .withOperationName("DescribeSolutionVersion")
                            .withMarshaller(new DescribeSolutionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSolutionVersionRequest));
            CompletableFuture<DescribeSolutionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the metrics for the specified solution version.
     * </p>
     *
     * @param getSolutionMetricsRequest
     * @return A Java Future containing the result of the GetSolutionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.GetSolutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSolutionMetricsResponse> getSolutionMetrics(GetSolutionMetricsRequest getSolutionMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSolutionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSolutionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSolutionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSolutionMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSolutionMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSolutionMetricsRequest, GetSolutionMetricsResponse>()
                            .withOperationName("GetSolutionMetrics")
                            .withMarshaller(new GetSolutionMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSolutionMetricsRequest));
            CompletableFuture<GetSolutionMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the batch inference jobs that have been performed off of a solution version.
     * </p>
     *
     * @param listBatchInferenceJobsRequest
     * @return A Java Future containing the result of the ListBatchInferenceJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListBatchInferenceJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBatchInferenceJobsResponse> listBatchInferenceJobs(
            ListBatchInferenceJobsRequest listBatchInferenceJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBatchInferenceJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBatchInferenceJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBatchInferenceJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBatchInferenceJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBatchInferenceJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBatchInferenceJobsRequest, ListBatchInferenceJobsResponse>()
                            .withOperationName("ListBatchInferenceJobs")
                            .withMarshaller(new ListBatchInferenceJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBatchInferenceJobsRequest));
            CompletableFuture<ListBatchInferenceJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.
     * </p>
     *
     * @param listBatchSegmentJobsRequest
     * @return A Java Future containing the result of the ListBatchSegmentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListBatchSegmentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchSegmentJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBatchSegmentJobsResponse> listBatchSegmentJobs(
            ListBatchSegmentJobsRequest listBatchSegmentJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBatchSegmentJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBatchSegmentJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBatchSegmentJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBatchSegmentJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBatchSegmentJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBatchSegmentJobsRequest, ListBatchSegmentJobsResponse>()
                            .withOperationName("ListBatchSegmentJobs")
                            .withMarshaller(new ListBatchSegmentJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBatchSegmentJobsRequest));
            CompletableFuture<ListBatchSegmentJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns
     * associated with the account are listed. The response provides the properties for each campaign, including the
     * Amazon Resource Name (ARN). For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param listCampaignsRequest
     * @return A Java Future containing the result of the ListCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCampaignsResponse> listCampaigns(ListCampaignsRequest listCampaignsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCampaignsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCampaignsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCampaignsRequest, ListCampaignsResponse>()
                            .withOperationName("ListCampaigns")
                            .withMarshaller(new ListCampaignsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCampaignsRequest));
            CompletableFuture<ListCampaignsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the
     * dataset export jobs associated with the account are listed. The response provides the properties for each dataset
     * export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html"
     * >CreateDatasetExportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param listDatasetExportJobsRequest
     * @return A Java Future containing the result of the ListDatasetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListDatasetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDatasetExportJobsResponse> listDatasetExportJobs(
            ListDatasetExportJobsRequest listDatasetExportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasetExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDatasetExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatasetExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetExportJobsRequest, ListDatasetExportJobsResponse>()
                            .withOperationName("ListDatasetExportJobs")
                            .withMarshaller(new ListDatasetExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDatasetExportJobsRequest));
            CompletableFuture<ListDatasetExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of dataset groups. The response provides the properties for each dataset group, including the
     * Amazon Resource Name (ARN). For more information on dataset groups, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.
     * </p>
     *
     * @param listDatasetGroupsRequest
     * @return A Java Future containing the result of the ListDatasetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDatasetGroupsResponse> listDatasetGroups(ListDatasetGroupsRequest listDatasetGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasetGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDatasetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatasetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetGroupsRequest, ListDatasetGroupsResponse>()
                            .withOperationName("ListDatasetGroups")
                            .withMarshaller(new ListDatasetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDatasetGroupsRequest));
            CompletableFuture<ListDatasetGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the
     * dataset import jobs associated with the account are listed. The response provides the properties for each dataset
     * import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html"
     * >CreateDatasetImportJob</a>. For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param listDatasetImportJobsRequest
     * @return A Java Future containing the result of the ListDatasetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDatasetImportJobsResponse> listDatasetImportJobs(
            ListDatasetImportJobsRequest listDatasetImportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasetImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDatasetImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatasetImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetImportJobsRequest, ListDatasetImportJobsResponse>()
                            .withOperationName("ListDatasetImportJobs")
                            .withMarshaller(new ListDatasetImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDatasetImportJobsRequest));
            CompletableFuture<ListDatasetImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of datasets contained in the given dataset group. The response provides the properties for each
     * dataset, including the Amazon Resource Name (ARN). For more information on datasets, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.
     * </p>
     *
     * @param listDatasetsRequest
     * @return A Java Future containing the result of the ListDatasets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDatasetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatasetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetsRequest, ListDatasetsResponse>()
                            .withOperationName("ListDatasets").withMarshaller(new ListDatasetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDatasetsRequest));
            CompletableFuture<ListDatasetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of event trackers associated with the account. The response provides the properties for each
     * event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers,
     * see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.
     * </p>
     *
     * @param listEventTrackersRequest
     * @return A Java Future containing the result of the ListEventTrackers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListEventTrackers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListEventTrackers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventTrackersResponse> listEventTrackers(ListEventTrackersRequest listEventTrackersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventTrackersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventTrackers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventTrackersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventTrackersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventTrackersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventTrackersRequest, ListEventTrackersResponse>()
                            .withOperationName("ListEventTrackers")
                            .withMarshaller(new ListEventTrackersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEventTrackersRequest));
            CompletableFuture<ListEventTrackersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all filters that belong to a given dataset group.
     * </p>
     *
     * @param listFiltersRequest
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFiltersResponse> listFilters(ListFiltersRequest listFiltersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFiltersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFilters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFiltersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFiltersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFiltersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFiltersRequest, ListFiltersResponse>()
                            .withOperationName("ListFilters").withMarshaller(new ListFiltersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFiltersRequest));
            CompletableFuture<ListFiltersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the metrics for the metric attribution.
     * </p>
     *
     * @param listMetricAttributionMetricsRequest
     * @return A Java Future containing the result of the ListMetricAttributionMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListMetricAttributionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListMetricAttributionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMetricAttributionMetricsResponse> listMetricAttributionMetrics(
            ListMetricAttributionMetricsRequest listMetricAttributionMetricsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMetricAttributionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMetricAttributionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMetricAttributionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMetricAttributionMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMetricAttributionMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMetricAttributionMetricsRequest, ListMetricAttributionMetricsResponse>()
                            .withOperationName("ListMetricAttributionMetrics")
                            .withMarshaller(new ListMetricAttributionMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMetricAttributionMetricsRequest));
            CompletableFuture<ListMetricAttributionMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists metric attributions.
     * </p>
     *
     * @param listMetricAttributionsRequest
     * @return A Java Future containing the result of the ListMetricAttributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListMetricAttributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListMetricAttributions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMetricAttributionsResponse> listMetricAttributions(
            ListMetricAttributionsRequest listMetricAttributionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMetricAttributionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMetricAttributions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMetricAttributionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMetricAttributionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMetricAttributionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMetricAttributionsRequest, ListMetricAttributionsResponse>()
                            .withOperationName("ListMetricAttributions")
                            .withMarshaller(new ListMetricAttributionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMetricAttributionsRequest));
            CompletableFuture<ListMetricAttributionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of available recipes. The response provides the properties for each recipe, including the recipe's
     * Amazon Resource Name (ARN).
     * </p>
     *
     * @param listRecipesRequest
     * @return A Java Future containing the result of the ListRecipes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListRecipes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecipes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecipesResponse> listRecipes(ListRecipesRequest listRecipesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecipesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecipes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecipesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListRecipesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecipesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecipesRequest, ListRecipesResponse>()
                            .withOperationName("ListRecipes").withMarshaller(new ListRecipesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listRecipesRequest));
            CompletableFuture<ListRecipesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all
     * the recommenders associated with the account are listed. The response provides the properties for each
     * recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.
     * </p>
     *
     * @param listRecommendersRequest
     * @return A Java Future containing the result of the ListRecommenders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListRecommenders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListRecommenders" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecommendersResponse> listRecommenders(ListRecommendersRequest listRecommendersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommenders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecommendersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecommendersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecommendersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecommendersRequest, ListRecommendersResponse>()
                            .withOperationName("ListRecommenders")
                            .withMarshaller(new ListRecommendersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listRecommendersRequest));
            CompletableFuture<ListRecommendersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of schemas associated with the account. The response provides the properties for each schema,
     * including the Amazon Resource Name (ARN). For more information on schemas, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.
     * </p>
     *
     * @param listSchemasRequest
     * @return A Java Future containing the result of the ListSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSchemasResponse> listSchemas(ListSchemasRequest listSchemasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSchemasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSchemasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSchemasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSchemasRequest, ListSchemasResponse>()
                            .withOperationName("ListSchemas").withMarshaller(new ListSchemasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSchemasRequest));
            CompletableFuture<ListSchemasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of solution versions for the given solution. When a solution is not specified, all the solution
     * versions associated with the account are listed. The response provides the properties for each solution version,
     * including the Amazon Resource Name (ARN).
     * </p>
     *
     * @param listSolutionVersionsRequest
     * @return A Java Future containing the result of the ListSolutionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListSolutionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSolutionVersionsResponse> listSolutionVersions(
            ListSolutionVersionsRequest listSolutionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSolutionVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSolutionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSolutionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSolutionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSolutionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSolutionVersionsRequest, ListSolutionVersionsResponse>()
                            .withOperationName("ListSolutionVersions")
                            .withMarshaller(new ListSolutionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSolutionVersionsRequest));
            CompletableFuture<ListSolutionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of solutions that use the given dataset group. When a dataset group is not specified, all the
     * solutions associated with the account are listed. The response provides the properties for each solution,
     * including the Amazon Resource Name (ARN). For more information on solutions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.
     * </p>
     *
     * @param listSolutionsRequest
     * @return A Java Future containing the result of the ListSolutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>InvalidNextTokenException The token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListSolutions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSolutionsResponse> listSolutions(ListSolutionsRequest listSolutionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSolutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSolutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSolutionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSolutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSolutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSolutionsRequest, ListSolutionsResponse>()
                            .withOperationName("ListSolutions")
                            .withMarshaller(new ListSolutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSolutionsRequest));
            CompletableFuture<ListSolutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a>
     * attached to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing
     * and automatic retraining for the recommender.
     * </p>
     *
     * @param startRecommenderRequest
     * @return A Java Future containing the result of the StartRecommender operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.StartRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StartRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartRecommenderResponse> startRecommender(StartRecommenderRequest startRecommenderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRecommenderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRecommender");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRecommenderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRecommenderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartRecommenderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRecommenderRequest, StartRecommenderResponse>()
                            .withOperationName("StartRecommender")
                            .withMarshaller(new StartRecommenderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startRecommenderRequest));
            CompletableFuture<StartRecommenderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the
     * recommender.
     * </p>
     *
     * @param stopRecommenderRequest
     * @return A Java Future containing the result of the StopRecommender operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.StopRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopRecommenderResponse> stopRecommender(StopRecommenderRequest stopRecommenderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRecommenderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRecommender");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopRecommenderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopRecommenderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopRecommenderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopRecommenderRequest, StopRecommenderResponse>()
                            .withOperationName("StopRecommender")
                            .withMarshaller(new StopRecommenderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopRecommenderRequest));
            CompletableFuture<StopRecommenderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS.
     * </p>
     * <p>
     * Depending on the current state of the solution version, the solution version state changes as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CREATE_PENDING &gt; CREATE_STOPPED
     * </p>
     * <p>
     * or
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATE_IN_PROGRESS &gt; CREATE_STOPPING &gt; CREATE_STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * You are billed for all of the training completed up until you stop the solution version creation. You cannot
     * resume creating a solution version once it has been stopped.
     * </p>
     *
     * @param stopSolutionVersionCreationRequest
     * @return A Java Future containing the result of the StopSolutionVersionCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.StopSolutionVersionCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/StopSolutionVersionCreation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopSolutionVersionCreationResponse> stopSolutionVersionCreation(
            StopSolutionVersionCreationRequest stopSolutionVersionCreationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSolutionVersionCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSolutionVersionCreation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopSolutionVersionCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopSolutionVersionCreationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopSolutionVersionCreationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopSolutionVersionCreationRequest, StopSolutionVersionCreationResponse>()
                            .withOperationName("StopSolutionVersionCreation")
                            .withMarshaller(new StopSolutionVersionCreationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopSolutionVersionCreationRequest));
            CompletableFuture<StopSolutionVersionCreationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add a list of tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>TooManyTagsException You have exceeded the maximum number of tags you can apply to this resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>LimitExceededException The limit on the number of requests per second has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> that are
     * attached to a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>TooManyTagKeysException The request contains more tag keys than can be associated with a resource (50
     *         tag keys per resource).</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a campaign by either deploying a new solution or changing the value of the campaign's
     * <code>minProvisionedTPS</code> parameter.
     * </p>
     * <p>
     * To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * You can still get recommendations from a campaign while an update is in progress. The campaign will use the
     * previous solution version and campaign configuration to generate recommendations until the latest campaign update
     * status is <code>Active</code>.
     * </p>
     * </note>
     * <p>
     * For more information on campaigns, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.
     * </p>
     *
     * @param updateCampaignRequest
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateCampaign" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                            .withOperationName("UpdateCampaign")
                            .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateCampaignRequest));
            CompletableFuture<UpdateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a metric attribution.
     * </p>
     *
     * @param updateMetricAttributionRequest
     * @return A Java Future containing the result of the UpdateMetricAttribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.UpdateMetricAttribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateMetricAttribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMetricAttributionResponse> updateMetricAttribution(
            UpdateMetricAttributionRequest updateMetricAttributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMetricAttributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMetricAttribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMetricAttributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMetricAttributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMetricAttributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMetricAttributionRequest, UpdateMetricAttributionResponse>()
                            .withOperationName("UpdateMetricAttribution")
                            .withMarshaller(new UpdateMetricAttributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMetricAttributionRequest));
            CompletableFuture<UpdateMetricAttributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the recommender to modify the recommender configuration. If you update the recommender to modify the
     * columns used in training, Amazon Personalize automatically starts a full retraining of the models backing your
     * recommender. While the update completes, you can still get recommendations from the recommender. The recommender
     * uses the previous configuration until the update completes. To track the status of this update, use the
     * <code>latestRecommenderUpdate</code> returned in the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>
     * operation.
     * </p>
     *
     * @param updateRecommenderRequest
     * @return A Java Future containing the result of the UpdateRecommender operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PersonalizeAsyncClient.UpdateRecommender
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/UpdateRecommender" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRecommenderResponse> updateRecommender(UpdateRecommenderRequest updateRecommenderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRecommenderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRecommender");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRecommenderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRecommenderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRecommenderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRecommenderRequest, UpdateRecommenderResponse>()
                            .withOperationName("UpdateRecommender")
                            .withMarshaller(new UpdateRecommenderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRecommenderRequest));
            CompletableFuture<UpdateRecommenderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final PersonalizeServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PersonalizeException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagKeysException")
                                .exceptionBuilderSupplier(TooManyTagKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInputException")
                                .exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
