/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.MetricAttributionOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricAttribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricAttribution> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MetricAttribution.getter(MetricAttribution::name)).setter(MetricAttribution.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> METRIC_ATTRIBUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricAttributionArn").getter(MetricAttribution.getter(MetricAttribution::metricAttributionArn)).setter(MetricAttribution.setter(Builder::metricAttributionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttributionArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(MetricAttribution.getter(MetricAttribution::datasetGroupArn)).setter(MetricAttribution.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<MetricAttributionOutput> METRICS_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricsOutputConfig").getter(MetricAttribution.getter(MetricAttribution::metricsOutputConfig)).setter(MetricAttribution.setter(Builder::metricsOutputConfig)).constructor(MetricAttributionOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsOutputConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(MetricAttribution.getter(MetricAttribution::status)).setter(MetricAttribution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(MetricAttribution.getter(MetricAttribution::creationDateTime)).setter(MetricAttribution.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(MetricAttribution.getter(MetricAttribution::lastUpdatedDateTime)).setter(MetricAttribution.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(MetricAttribution.getter(MetricAttribution::failureReason)).setter(MetricAttribution.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_ATTRIBUTION_ARN_FIELD, DATASET_GROUP_ARN_FIELD, METRICS_OUTPUT_CONFIG_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String metricAttributionArn;
    private final String datasetGroupArn;
    private final MetricAttributionOutput metricsOutputConfig;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String failureReason;

    private MetricAttribution(BuilderImpl builder) {
        this.name = builder.name;
        this.metricAttributionArn = builder.metricAttributionArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.metricsOutputConfig = builder.metricsOutputConfig;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.failureReason = builder.failureReason;
    }

    public final String name() {
        return this.name;
    }

    public final String metricAttributionArn() {
        return this.metricAttributionArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final MetricAttributionOutput metricsOutputConfig() {
        return this.metricsOutputConfig;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAttributionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAttribution)) {
            return false;
        }
        MetricAttribution other = (MetricAttribution)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.metricAttributionArn(), other.metricAttributionArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.metricsOutputConfig(), other.metricsOutputConfig()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"MetricAttribution").add("Name", (Object)this.name()).add("MetricAttributionArn", (Object)this.metricAttributionArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("MetricsOutputConfig", (Object)this.metricsOutputConfig()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "metricAttributionArn": {
                return Optional.ofNullable(clazz.cast(this.metricAttributionArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "metricsOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.metricsOutputConfig()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricAttribution, T> g) {
        return obj -> g.apply((MetricAttribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String metricAttributionArn;
        private String datasetGroupArn;
        private MetricAttributionOutput metricsOutputConfig;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricAttribution model) {
            this.name(model.name);
            this.metricAttributionArn(model.metricAttributionArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.metricsOutputConfig(model.metricsOutputConfig);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.failureReason(model.failureReason);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMetricAttributionArn() {
            return this.metricAttributionArn;
        }

        public final void setMetricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
        }

        @Override
        public final Builder metricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final MetricAttributionOutput.Builder getMetricsOutputConfig() {
            return this.metricsOutputConfig != null ? this.metricsOutputConfig.toBuilder() : null;
        }

        public final void setMetricsOutputConfig(MetricAttributionOutput.BuilderImpl metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig != null ? metricsOutputConfig.build() : null;
        }

        @Override
        public final Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public MetricAttribution build() {
            return new MetricAttribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricAttribution> {
        public Builder name(String var1);

        public Builder metricAttributionArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder metricsOutputConfig(MetricAttributionOutput var1);

        default public Builder metricsOutputConfig(Consumer<MetricAttributionOutput.Builder> metricsOutputConfig) {
            return this.metricsOutputConfig((MetricAttributionOutput)((MetricAttributionOutput.Builder)MetricAttributionOutput.builder().applyMutation(metricsOutputConfig)).build());
        }

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

