/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.ListSolutionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionsResponse;
import software.amazon.awssdk.services.personalize.model.SolutionSummary;

public class ListSolutionsIterable
implements SdkIterable<ListSolutionsResponse> {
    private final PersonalizeClient client;
    private final ListSolutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolutionsIterable(PersonalizeClient client, ListSolutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSolutionsResponseFetcher();
    }

    public Iterator<ListSolutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SolutionSummary> solutions() {
        Function<ListSolutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.solutions() != null) {
                return response.solutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolutionsResponseFetcher
    implements SyncPageFetcher<ListSolutionsResponse> {
        private ListSolutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolutionsResponse nextPage(ListSolutionsResponse previousPage) {
            if (previousPage == null) {
                return ListSolutionsIterable.this.client.listSolutions(ListSolutionsIterable.this.firstRequest);
            }
            return ListSolutionsIterable.this.client.listSolutions((ListSolutionsRequest)((Object)ListSolutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

