/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.EventTrackerSummary;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse;

public class ListEventTrackersPublisher
implements SdkPublisher<ListEventTrackersResponse> {
    private final PersonalizeAsyncClient client;
    private final ListEventTrackersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventTrackersPublisher(PersonalizeAsyncClient client, ListEventTrackersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventTrackersPublisher(PersonalizeAsyncClient client, ListEventTrackersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventTrackersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventTrackersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventTrackerSummary> eventTrackers() {
        Function<ListEventTrackersResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventTrackers() != null) {
                return response.eventTrackers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventTrackersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventTrackersResponseFetcher
    implements AsyncPageFetcher<ListEventTrackersResponse> {
        private ListEventTrackersResponseFetcher() {
        }

        public boolean hasNextPage(ListEventTrackersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventTrackersResponse> nextPage(ListEventTrackersResponse previousPage) {
            if (previousPage == null) {
                return ListEventTrackersPublisher.this.client.listEventTrackers(ListEventTrackersPublisher.this.firstRequest);
            }
            return ListEventTrackersPublisher.this.client.listEventTrackers((ListEventTrackersRequest)((Object)ListEventTrackersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

