/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse;
import software.amazon.awssdk.services.personalize.model.SolutionVersionSummary;

public class ListSolutionVersionsPublisher
implements SdkPublisher<ListSolutionVersionsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListSolutionVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSolutionVersionsPublisher(PersonalizeAsyncClient client, ListSolutionVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSolutionVersionsPublisher(PersonalizeAsyncClient client, ListSolutionVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSolutionVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSolutionVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SolutionVersionSummary> solutionVersions() {
        Function<ListSolutionVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.solutionVersions() != null) {
                return response.solutionVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSolutionVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSolutionVersionsResponseFetcher
    implements AsyncPageFetcher<ListSolutionVersionsResponse> {
        private ListSolutionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolutionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSolutionVersionsResponse> nextPage(ListSolutionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListSolutionVersionsPublisher.this.client.listSolutionVersions(ListSolutionVersionsPublisher.this.firstRequest);
            }
            return ListSolutionVersionsPublisher.this.client.listSolutionVersions((ListSolutionVersionsRequest)((Object)ListSolutionVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

