/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.DatasetGroupSummary;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse;

public class ListDatasetGroupsIterable
implements SdkIterable<ListDatasetGroupsResponse> {
    private final PersonalizeClient client;
    private final ListDatasetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetGroupsIterable(PersonalizeClient client, ListDatasetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatasetGroupsResponseFetcher();
    }

    public Iterator<ListDatasetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatasetGroupSummary> datasetGroups() {
        Function<ListDatasetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetGroups() != null) {
                return response.datasetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetGroupsResponseFetcher
    implements SyncPageFetcher<ListDatasetGroupsResponse> {
        private ListDatasetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetGroupsResponse nextPage(ListDatasetGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetGroupsIterable.this.client.listDatasetGroups(ListDatasetGroupsIterable.this.firstRequest);
            }
            return ListDatasetGroupsIterable.this.client.listDatasetGroups((ListDatasetGroupsRequest)((Object)ListDatasetGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

