/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.CampaignSummary;
import software.amazon.awssdk.services.personalize.model.ListCampaignsRequest;
import software.amazon.awssdk.services.personalize.model.ListCampaignsResponse;

public class ListCampaignsIterable
implements SdkIterable<ListCampaignsResponse> {
    private final PersonalizeClient client;
    private final ListCampaignsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCampaignsIterable(PersonalizeClient client, ListCampaignsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCampaignsResponseFetcher();
    }

    public Iterator<ListCampaignsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CampaignSummary> campaigns() {
        Function<ListCampaignsResponse, Iterator> getIterator = response -> {
            if (response != null && response.campaigns() != null) {
                return response.campaigns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCampaignsResponseFetcher
    implements SyncPageFetcher<ListCampaignsResponse> {
        private ListCampaignsResponseFetcher() {
        }

        public boolean hasNextPage(ListCampaignsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCampaignsResponse nextPage(ListCampaignsResponse previousPage) {
            if (previousPage == null) {
                return ListCampaignsIterable.this.client.listCampaigns(ListCampaignsIterable.this.firstRequest);
            }
            return ListCampaignsIterable.this.client.listCampaigns((ListCampaignsRequest)((Object)ListCampaignsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

