/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.BatchSegmentJobInput;
import software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.Tag;
import software.amazon.awssdk.services.personalize.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBatchSegmentJobRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateBatchSegmentJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::jobName)).setter(CreateBatchSegmentJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::solutionVersionArn)).setter(CreateBatchSegmentJobRequest.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::filterArn)).setter(CreateBatchSegmentJobRequest.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numResults").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::numResults)).setter(CreateBatchSegmentJobRequest.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()}).build();
    private static final SdkField<BatchSegmentJobInput> JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobInput").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::jobInput)).setter(CreateBatchSegmentJobRequest.setter(Builder::jobInput)).constructor(BatchSegmentJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()}).build();
    private static final SdkField<BatchSegmentJobOutput> JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobOutput").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::jobOutput)).setter(CreateBatchSegmentJobRequest.setter(Builder::jobOutput)).constructor(BatchSegmentJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::roleArn)).setter(CreateBatchSegmentJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateBatchSegmentJobRequest.getter(CreateBatchSegmentJobRequest::tags)).setter(CreateBatchSegmentJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, SOLUTION_VERSION_ARN_FIELD, FILTER_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private final String jobName;
    private final String solutionVersionArn;
    private final String filterArn;
    private final Integer numResults;
    private final BatchSegmentJobInput jobInput;
    private final BatchSegmentJobOutput jobOutput;
    private final String roleArn;
    private final List<Tag> tags;

    private CreateBatchSegmentJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.filterArn = builder.filterArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public final String filterArn() {
        return this.filterArn;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final BatchSegmentJobInput jobInput() {
        return this.jobInput;
    }

    public final BatchSegmentJobOutput jobOutput() {
        return this.jobOutput;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchSegmentJobRequest)) {
            return false;
        }
        CreateBatchSegmentJobRequest other = (CreateBatchSegmentJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.filterArn(), other.filterArn()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.jobInput(), other.jobInput()) && Objects.equals(this.jobOutput(), other.jobOutput()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBatchSegmentJobRequest").add("JobName", (Object)this.jobName()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("FilterArn", (Object)this.filterArn()).add("NumResults", (Object)this.numResults()).add("JobInput", (Object)this.jobInput()).add("JobOutput", (Object)this.jobOutput()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "numResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "jobInput": {
                return Optional.ofNullable(clazz.cast(this.jobInput()));
            }
            case "jobOutput": {
                return Optional.ofNullable(clazz.cast(this.jobOutput()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchSegmentJobRequest, T> g) {
        return obj -> g.apply((CreateBatchSegmentJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String solutionVersionArn;
        private String filterArn;
        private Integer numResults;
        private BatchSegmentJobInput jobInput;
        private BatchSegmentJobOutput jobOutput;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchSegmentJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.solutionVersionArn(model.solutionVersionArn);
            this.filterArn(model.filterArn);
            this.numResults(model.numResults);
            this.jobInput(model.jobInput);
            this.jobOutput(model.jobOutput);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final BatchSegmentJobInput.Builder getJobInput() {
            return this.jobInput != null ? this.jobInput.toBuilder() : null;
        }

        public final void setJobInput(BatchSegmentJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        @Override
        public final Builder jobInput(BatchSegmentJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final BatchSegmentJobOutput.Builder getJobOutput() {
            return this.jobOutput != null ? this.jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(BatchSegmentJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        public final Builder jobOutput(BatchSegmentJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchSegmentJobRequest build() {
            return new CreateBatchSegmentJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBatchSegmentJobRequest> {
        public Builder jobName(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder filterArn(String var1);

        public Builder numResults(Integer var1);

        public Builder jobInput(BatchSegmentJobInput var1);

        default public Builder jobInput(Consumer<BatchSegmentJobInput.Builder> jobInput) {
            return this.jobInput((BatchSegmentJobInput)((BatchSegmentJobInput.Builder)BatchSegmentJobInput.builder().applyMutation(jobInput)).build());
        }

        public Builder jobOutput(BatchSegmentJobOutput var1);

        default public Builder jobOutput(Consumer<BatchSegmentJobOutput.Builder> jobOutput) {
            return this.jobOutput((BatchSegmentJobOutput)((BatchSegmentJobOutput.Builder)BatchSegmentJobOutput.builder().applyMutation(jobOutput)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

