/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.Algorithm;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlgorithmResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, DescribeAlgorithmResponse> {
    private static final SdkField<Algorithm> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("algorithm").getter(DescribeAlgorithmResponse.getter(DescribeAlgorithmResponse::algorithm)).setter(DescribeAlgorithmResponse.setter(Builder::algorithm)).constructor(Algorithm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD));
    private final Algorithm algorithm;

    private DescribeAlgorithmResponse(BuilderImpl builder) {
        super(builder);
        this.algorithm = builder.algorithm;
    }

    public final Algorithm algorithm() {
        return this.algorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlgorithmResponse)) {
            return false;
        }
        DescribeAlgorithmResponse other = (DescribeAlgorithmResponse)((Object)obj);
        return Objects.equals(this.algorithm(), other.algorithm());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlgorithmResponse").add("Algorithm", (Object)this.algorithm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlgorithmResponse, T> g) {
        return obj -> g.apply((DescribeAlgorithmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private Algorithm algorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlgorithmResponse model) {
            super(model);
            this.algorithm(model.algorithm);
        }

        public final Algorithm.Builder getAlgorithm() {
            return this.algorithm != null ? this.algorithm.toBuilder() : null;
        }

        public final void setAlgorithm(Algorithm.BuilderImpl algorithm) {
            this.algorithm = algorithm != null ? algorithm.build() : null;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public DescribeAlgorithmResponse build() {
            return new DescribeAlgorithmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlgorithmResponse> {
        public Builder algorithm(Algorithm var1);

        default public Builder algorithm(Consumer<Algorithm.Builder> algorithm) {
            return this.algorithm((Algorithm)((Algorithm.Builder)Algorithm.builder().applyMutation(algorithm)).build());
        }
    }
}

