/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse;

public class ListDatasetExportJobsIterable
implements SdkIterable<ListDatasetExportJobsResponse> {
    private final PersonalizeClient client;
    private final ListDatasetExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetExportJobsIterable(PersonalizeClient client, ListDatasetExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatasetExportJobsResponseFetcher();
    }

    public Iterator<ListDatasetExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatasetExportJobSummary> datasetExportJobs() {
        Function<ListDatasetExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetExportJobs() != null) {
                return response.datasetExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatasetExportJobsResponseFetcher
    implements SyncPageFetcher<ListDatasetExportJobsResponse> {
        private ListDatasetExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetExportJobsResponse nextPage(ListDatasetExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetExportJobsIterable.this.client.listDatasetExportJobs(ListDatasetExportJobsIterable.this.firstRequest);
            }
            return ListDatasetExportJobsIterable.this.client.listDatasetExportJobs((ListDatasetExportJobsRequest)((Object)ListDatasetExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

