/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.ArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLConfig> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(AutoMLConfig.getter(AutoMLConfig::metricName)).setter(AutoMLConfig.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<List<String>> RECIPE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recipeList").getter(AutoMLConfig.getter(AutoMLConfig::recipeList)).setter(AutoMLConfig.setter(Builder::recipeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, RECIPE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final List<String> recipeList;

    private AutoMLConfig(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.recipeList = builder.recipeList;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final boolean hasRecipeList() {
        return this.recipeList != null && !(this.recipeList instanceof SdkAutoConstructList);
    }

    public final List<String> recipeList() {
        return this.recipeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipeList() ? this.recipeList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLConfig)) {
            return false;
        }
        AutoMLConfig other = (AutoMLConfig)obj;
        return Objects.equals(this.metricName(), other.metricName()) && this.hasRecipeList() == other.hasRecipeList() && Objects.equals(this.recipeList(), other.recipeList());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLConfig").add("MetricName", (Object)this.metricName()).add("RecipeList", this.hasRecipeList() ? this.recipeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "recipeList": {
                return Optional.ofNullable(clazz.cast(this.recipeList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLConfig, T> g) {
        return obj -> g.apply((AutoMLConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private List<String> recipeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLConfig model) {
            this.metricName(model.metricName);
            this.recipeList(model.recipeList);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Collection<String> getRecipeList() {
            if (this.recipeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recipeList;
        }

        public final void setRecipeList(Collection<String> recipeList) {
            this.recipeList = ArnListCopier.copy(recipeList);
        }

        @Override
        @Transient
        public final Builder recipeList(Collection<String> recipeList) {
            this.recipeList = ArnListCopier.copy(recipeList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recipeList(String ... recipeList) {
            this.recipeList(Arrays.asList(recipeList));
            return this;
        }

        public AutoMLConfig build() {
            return new AutoMLConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLConfig> {
        public Builder metricName(String var1);

        public Builder recipeList(Collection<String> var1);

        public Builder recipeList(String ... var1);
    }
}

