/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.EventTrackerSummary;
import software.amazon.awssdk.services.personalize.model.EventTrackersCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventTrackersResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListEventTrackersResponse> {
    private static final SdkField<List<EventTrackerSummary>> EVENT_TRACKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventTrackers").getter(ListEventTrackersResponse.getter(ListEventTrackersResponse::eventTrackers)).setter(ListEventTrackersResponse.setter(Builder::eventTrackers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTrackers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventTrackerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEventTrackersResponse.getter(ListEventTrackersResponse::nextToken)).setter(ListEventTrackersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TRACKERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventTrackerSummary> eventTrackers;
    private final String nextToken;

    private ListEventTrackersResponse(BuilderImpl builder) {
        super(builder);
        this.eventTrackers = builder.eventTrackers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventTrackers() {
        return this.eventTrackers != null && !(this.eventTrackers instanceof SdkAutoConstructList);
    }

    public final List<EventTrackerSummary> eventTrackers() {
        return this.eventTrackers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTrackers() ? this.eventTrackers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventTrackersResponse)) {
            return false;
        }
        ListEventTrackersResponse other = (ListEventTrackersResponse)((Object)obj);
        return this.hasEventTrackers() == other.hasEventTrackers() && Objects.equals(this.eventTrackers(), other.eventTrackers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventTrackersResponse").add("EventTrackers", this.hasEventTrackers() ? this.eventTrackers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTrackers": {
                return Optional.ofNullable(clazz.cast(this.eventTrackers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventTrackersResponse, T> g) {
        return obj -> g.apply((ListEventTrackersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<EventTrackerSummary> eventTrackers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventTrackersResponse model) {
            super(model);
            this.eventTrackers(model.eventTrackers);
            this.nextToken(model.nextToken);
        }

        public final Collection<EventTrackerSummary.Builder> getEventTrackers() {
            if (this.eventTrackers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTrackers != null ? (Collection)this.eventTrackers.stream().map(EventTrackerSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTrackers(Collection<EventTrackerSummary> eventTrackers) {
            this.eventTrackers = EventTrackersCopier.copy(eventTrackers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTrackers(EventTrackerSummary ... eventTrackers) {
            this.eventTrackers(Arrays.asList(eventTrackers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTrackers(Consumer<EventTrackerSummary.Builder> ... eventTrackers) {
            this.eventTrackers(Stream.of(eventTrackers).map(c -> (EventTrackerSummary)((EventTrackerSummary.Builder)EventTrackerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTrackers(Collection<EventTrackerSummary.BuilderImpl> eventTrackers) {
            this.eventTrackers = EventTrackersCopier.copyFromBuilder(eventTrackers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventTrackersResponse build() {
            return new ListEventTrackersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventTrackersResponse> {
        public Builder eventTrackers(Collection<EventTrackerSummary> var1);

        public Builder eventTrackers(EventTrackerSummary ... var1);

        public Builder eventTrackers(Consumer<EventTrackerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

