/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.SolutionConfig;
import software.amazon.awssdk.services.personalize.model.TrainingMode;
import software.amazon.awssdk.services.personalize.model.TunedHPOParams;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionVersion> {
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::solutionVersionArn)).setter(SolutionVersion.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::solutionArn)).setter(SolutionVersion.setter(Builder::solutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()}).build();
    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SolutionVersion.getter(SolutionVersion::performHPO)).setter(SolutionVersion.setter(Builder::performHPO)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performHPO").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SolutionVersion.getter(SolutionVersion::performAutoML)).setter(SolutionVersion.setter(Builder::performAutoML)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoML").build()}).build();
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::recipeArn)).setter(SolutionVersion.setter(Builder::recipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::eventType)).setter(SolutionVersion.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::datasetGroupArn)).setter(SolutionVersion.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<SolutionConfig> SOLUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SolutionVersion.getter(SolutionVersion::solutionConfig)).setter(SolutionVersion.setter(Builder::solutionConfig)).constructor(SolutionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionConfig").build()}).build();
    private static final SdkField<Double> TRAINING_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(SolutionVersion.getter(SolutionVersion::trainingHours)).setter(SolutionVersion.setter(Builder::trainingHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingHours").build()}).build();
    private static final SdkField<String> TRAINING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::trainingModeAsString)).setter(SolutionVersion.setter(Builder::trainingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMode").build()}).build();
    private static final SdkField<TunedHPOParams> TUNED_HPO_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SolutionVersion.getter(SolutionVersion::tunedHPOParams)).setter(SolutionVersion.setter(Builder::tunedHPOParams)).constructor(TunedHPOParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunedHPOParams").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::status)).setter(SolutionVersion.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SolutionVersion.getter(SolutionVersion::failureReason)).setter(SolutionVersion.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SolutionVersion.getter(SolutionVersion::creationDateTime)).setter(SolutionVersion.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SolutionVersion.getter(SolutionVersion::lastUpdatedDateTime)).setter(SolutionVersion.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_VERSION_ARN_FIELD, SOLUTION_ARN_FIELD, PERFORM_HPO_FIELD, PERFORM_AUTO_ML_FIELD, RECIPE_ARN_FIELD, EVENT_TYPE_FIELD, DATASET_GROUP_ARN_FIELD, SOLUTION_CONFIG_FIELD, TRAINING_HOURS_FIELD, TRAINING_MODE_FIELD, TUNED_HPO_PARAMS_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String solutionVersionArn;
    private final String solutionArn;
    private final Boolean performHPO;
    private final Boolean performAutoML;
    private final String recipeArn;
    private final String eventType;
    private final String datasetGroupArn;
    private final SolutionConfig solutionConfig;
    private final Double trainingHours;
    private final String trainingMode;
    private final TunedHPOParams tunedHPOParams;
    private final String status;
    private final String failureReason;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private SolutionVersion(BuilderImpl builder) {
        this.solutionVersionArn = builder.solutionVersionArn;
        this.solutionArn = builder.solutionArn;
        this.performHPO = builder.performHPO;
        this.performAutoML = builder.performAutoML;
        this.recipeArn = builder.recipeArn;
        this.eventType = builder.eventType;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.solutionConfig = builder.solutionConfig;
        this.trainingHours = builder.trainingHours;
        this.trainingMode = builder.trainingMode;
        this.tunedHPOParams = builder.tunedHPOParams;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public String solutionArn() {
        return this.solutionArn;
    }

    public Boolean performHPO() {
        return this.performHPO;
    }

    public Boolean performAutoML() {
        return this.performAutoML;
    }

    public String recipeArn() {
        return this.recipeArn;
    }

    public String eventType() {
        return this.eventType;
    }

    public String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public SolutionConfig solutionConfig() {
        return this.solutionConfig;
    }

    public Double trainingHours() {
        return this.trainingHours;
    }

    public TrainingMode trainingMode() {
        return TrainingMode.fromValue(this.trainingMode);
    }

    public String trainingModeAsString() {
        return this.trainingMode;
    }

    public TunedHPOParams tunedHPOParams() {
        return this.tunedHPOParams;
    }

    public String status() {
        return this.status;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunedHPOParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionVersion)) {
            return false;
        }
        SolutionVersion other = (SolutionVersion)obj;
        return Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.solutionArn(), other.solutionArn()) && Objects.equals(this.performHPO(), other.performHPO()) && Objects.equals(this.performAutoML(), other.performAutoML()) && Objects.equals(this.recipeArn(), other.recipeArn()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.solutionConfig(), other.solutionConfig()) && Objects.equals(this.trainingHours(), other.trainingHours()) && Objects.equals(this.trainingModeAsString(), other.trainingModeAsString()) && Objects.equals(this.tunedHPOParams(), other.tunedHPOParams()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public String toString() {
        return ToString.builder((String)"SolutionVersion").add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("SolutionArn", (Object)this.solutionArn()).add("PerformHPO", (Object)this.performHPO()).add("PerformAutoML", (Object)this.performAutoML()).add("RecipeArn", (Object)this.recipeArn()).add("EventType", (Object)this.eventType()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("SolutionConfig", (Object)this.solutionConfig()).add("TrainingHours", (Object)this.trainingHours()).add("TrainingMode", (Object)this.trainingModeAsString()).add("TunedHPOParams", (Object)this.tunedHPOParams()).add("Status", (Object)this.status()).add("FailureReason", (Object)this.failureReason()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "solutionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionArn()));
            }
            case "performHPO": {
                return Optional.ofNullable(clazz.cast(this.performHPO()));
            }
            case "performAutoML": {
                return Optional.ofNullable(clazz.cast(this.performAutoML()));
            }
            case "recipeArn": {
                return Optional.ofNullable(clazz.cast(this.recipeArn()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "solutionConfig": {
                return Optional.ofNullable(clazz.cast(this.solutionConfig()));
            }
            case "trainingHours": {
                return Optional.ofNullable(clazz.cast(this.trainingHours()));
            }
            case "trainingMode": {
                return Optional.ofNullable(clazz.cast(this.trainingModeAsString()));
            }
            case "tunedHPOParams": {
                return Optional.ofNullable(clazz.cast(this.tunedHPOParams()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SolutionVersion, T> g) {
        return obj -> g.apply((SolutionVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String solutionVersionArn;
        private String solutionArn;
        private Boolean performHPO;
        private Boolean performAutoML;
        private String recipeArn;
        private String eventType;
        private String datasetGroupArn;
        private SolutionConfig solutionConfig;
        private Double trainingHours;
        private String trainingMode;
        private TunedHPOParams tunedHPOParams;
        private String status;
        private String failureReason;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionVersion model) {
            this.solutionVersionArn(model.solutionVersionArn);
            this.solutionArn(model.solutionArn);
            this.performHPO(model.performHPO);
            this.performAutoML(model.performAutoML);
            this.recipeArn(model.recipeArn);
            this.eventType(model.eventType);
            this.datasetGroupArn(model.datasetGroupArn);
            this.solutionConfig(model.solutionConfig);
            this.trainingHours(model.trainingHours);
            this.trainingMode(model.trainingMode);
            this.tunedHPOParams(model.tunedHPOParams);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final String getSolutionArn() {
            return this.solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        public final Boolean getPerformHPO() {
            return this.performHPO;
        }

        @Override
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        public final Boolean getPerformAutoML() {
            return this.performAutoML;
        }

        @Override
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        public final String getRecipeArn() {
            return this.recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final SolutionConfig.Builder getSolutionConfig() {
            return this.solutionConfig != null ? this.solutionConfig.toBuilder() : null;
        }

        @Override
        public final Builder solutionConfig(SolutionConfig solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        public final void setSolutionConfig(SolutionConfig.BuilderImpl solutionConfig) {
            this.solutionConfig = solutionConfig != null ? solutionConfig.build() : null;
        }

        public final Double getTrainingHours() {
            return this.trainingHours;
        }

        @Override
        public final Builder trainingHours(Double trainingHours) {
            this.trainingHours = trainingHours;
            return this;
        }

        public final void setTrainingHours(Double trainingHours) {
            this.trainingHours = trainingHours;
        }

        public final String getTrainingMode() {
            return this.trainingMode;
        }

        @Override
        public final Builder trainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
            return this;
        }

        @Override
        public final Builder trainingMode(TrainingMode trainingMode) {
            this.trainingMode(trainingMode == null ? null : trainingMode.toString());
            return this;
        }

        public final void setTrainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
        }

        public final TunedHPOParams.Builder getTunedHPOParams() {
            return this.tunedHPOParams != null ? this.tunedHPOParams.toBuilder() : null;
        }

        @Override
        public final Builder tunedHPOParams(TunedHPOParams tunedHPOParams) {
            this.tunedHPOParams = tunedHPOParams;
            return this;
        }

        public final void setTunedHPOParams(TunedHPOParams.BuilderImpl tunedHPOParams) {
            this.tunedHPOParams = tunedHPOParams != null ? tunedHPOParams.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public SolutionVersion build() {
            return new SolutionVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionVersion> {
        public Builder solutionVersionArn(String var1);

        public Builder solutionArn(String var1);

        public Builder performHPO(Boolean var1);

        public Builder performAutoML(Boolean var1);

        public Builder recipeArn(String var1);

        public Builder eventType(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder solutionConfig(SolutionConfig var1);

        default public Builder solutionConfig(Consumer<SolutionConfig.Builder> solutionConfig) {
            return this.solutionConfig((SolutionConfig)((SolutionConfig.Builder)SolutionConfig.builder().applyMutation(solutionConfig)).build());
        }

        public Builder trainingHours(Double var1);

        public Builder trainingMode(String var1);

        public Builder trainingMode(TrainingMode var1);

        public Builder tunedHPOParams(TunedHPOParams var1);

        default public Builder tunedHPOParams(Consumer<TunedHPOParams.Builder> tunedHPOParams) {
            return this.tunedHPOParams((TunedHPOParams)((TunedHPOParams.Builder)TunedHPOParams.builder().applyMutation(tunedHPOParams)).build());
        }

        public Builder status(String var1);

        public Builder failureReason(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

