/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HPOObjective
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HPOObjective> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HPOObjective.getter(HPOObjective::type)).setter(HPOObjective.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HPOObjective.getter(HPOObjective::metricName)).setter(HPOObjective.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> METRIC_REGEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HPOObjective.getter(HPOObjective::metricRegex)).setter(HPOObjective.setter(Builder::metricRegex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricRegex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, METRIC_NAME_FIELD, METRIC_REGEX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String metricName;
    private final String metricRegex;

    private HPOObjective(BuilderImpl builder) {
        this.type = builder.type;
        this.metricName = builder.metricName;
        this.metricRegex = builder.metricRegex;
    }

    public String type() {
        return this.type;
    }

    public String metricName() {
        return this.metricName;
    }

    public String metricRegex() {
        return this.metricRegex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricRegex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOObjective)) {
            return false;
        }
        HPOObjective other = (HPOObjective)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricRegex(), other.metricRegex());
    }

    public String toString() {
        return ToString.builder((String)"HPOObjective").add("Type", (Object)this.type()).add("MetricName", (Object)this.metricName()).add("MetricRegex", (Object)this.metricRegex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "metricRegex": {
                return Optional.ofNullable(clazz.cast(this.metricRegex()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HPOObjective, T> g) {
        return obj -> g.apply((HPOObjective)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String metricName;
        private String metricRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(HPOObjective model) {
            this.type(model.type);
            this.metricName(model.metricName);
            this.metricRegex(model.metricRegex);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricRegex() {
            return this.metricRegex;
        }

        @Override
        public final Builder metricRegex(String metricRegex) {
            this.metricRegex = metricRegex;
            return this;
        }

        public final void setMetricRegex(String metricRegex) {
            this.metricRegex = metricRegex;
        }

        public HPOObjective build() {
            return new HPOObjective(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HPOObjective> {
        public Builder type(String var1);

        public Builder metricName(String var1);

        public Builder metricRegex(String var1);
    }
}

