/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcs.model.AccountingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountingRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateAccountingRequest> {
    private static final SdkField<Integer> DEFAULT_PURGE_TIME_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultPurgeTimeInDays").getter(UpdateAccountingRequest.getter(UpdateAccountingRequest::defaultPurgeTimeInDays)).setter(UpdateAccountingRequest.setter(Builder::defaultPurgeTimeInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPurgeTimeInDays").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(UpdateAccountingRequest.getter(UpdateAccountingRequest::modeAsString)).setter(UpdateAccountingRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_PURGE_TIME_IN_DAYS_FIELD, MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccountingRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer defaultPurgeTimeInDays;
    private final String mode;

    private UpdateAccountingRequest(BuilderImpl builder) {
        this.defaultPurgeTimeInDays = builder.defaultPurgeTimeInDays;
        this.mode = builder.mode;
    }

    public final Integer defaultPurgeTimeInDays() {
        return this.defaultPurgeTimeInDays;
    }

    public final AccountingMode mode() {
        return AccountingMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPurgeTimeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountingRequest)) {
            return false;
        }
        UpdateAccountingRequest other = (UpdateAccountingRequest)obj;
        return Objects.equals(this.defaultPurgeTimeInDays(), other.defaultPurgeTimeInDays()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccountingRequest").add("DefaultPurgeTimeInDays", (Object)this.defaultPurgeTimeInDays()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultPurgeTimeInDays": {
                return Optional.ofNullable(clazz.cast(this.defaultPurgeTimeInDays()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultPurgeTimeInDays", DEFAULT_PURGE_TIME_IN_DAYS_FIELD);
        map.put("mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountingRequest, T> g) {
        return obj -> g.apply((UpdateAccountingRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer defaultPurgeTimeInDays;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountingRequest model) {
            this.defaultPurgeTimeInDays(model.defaultPurgeTimeInDays);
            this.mode(model.mode);
        }

        public final Integer getDefaultPurgeTimeInDays() {
            return this.defaultPurgeTimeInDays;
        }

        public final void setDefaultPurgeTimeInDays(Integer defaultPurgeTimeInDays) {
            this.defaultPurgeTimeInDays = defaultPurgeTimeInDays;
        }

        @Override
        public final Builder defaultPurgeTimeInDays(Integer defaultPurgeTimeInDays) {
            this.defaultPurgeTimeInDays = defaultPurgeTimeInDays;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AccountingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public UpdateAccountingRequest build() {
            return new UpdateAccountingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateAccountingRequest> {
        public Builder defaultPurgeTimeInDays(Integer var1);

        public Builder mode(String var1);

        public Builder mode(AccountingMode var1);
    }
}

