/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfiguration;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupConfigurationListCopier;
import software.amazon.awssdk.services.pcs.model.PcsRequest;
import software.amazon.awssdk.services.pcs.model.RequestTagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQueueRequest
extends PcsRequest
implements ToCopyableBuilder<Builder, CreateQueueRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterIdentifier").getter(CreateQueueRequest.getter(CreateQueueRequest::clusterIdentifier)).setter(CreateQueueRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()}).build();
    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueName").getter(CreateQueueRequest.getter(CreateQueueRequest::queueName)).setter(CreateQueueRequest.setter(Builder::queueName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueName").build()}).build();
    private static final SdkField<List<ComputeNodeGroupConfiguration>> COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computeNodeGroupConfigurations").getter(CreateQueueRequest.getter(CreateQueueRequest::computeNodeGroupConfigurations)).setter(CreateQueueRequest.setter(Builder::computeNodeGroupConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroupConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeNodeGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateQueueRequest.getter(CreateQueueRequest::clientToken)).setter(CreateQueueRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateQueueRequest.getter(CreateQueueRequest::tags)).setter(CreateQueueRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, QUEUE_NAME_FIELD, COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateQueueRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String queueName;
    private final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.queueName = builder.queueName;
        this.computeNodeGroupConfigurations = builder.computeNodeGroupConfigurations;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String queueName() {
        return this.queueName;
    }

    public final boolean hasComputeNodeGroupConfigurations() {
        return this.computeNodeGroupConfigurations != null && !(this.computeNodeGroupConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations() {
        return this.computeNodeGroupConfigurations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeNodeGroupConfigurations() ? this.computeNodeGroupConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.queueName(), other.queueName()) && this.hasComputeNodeGroupConfigurations() == other.hasComputeNodeGroupConfigurations() && Objects.equals(this.computeNodeGroupConfigurations(), other.computeNodeGroupConfigurations()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQueueRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("QueueName", (Object)this.queueName()).add("ComputeNodeGroupConfigurations", this.hasComputeNodeGroupConfigurations() ? this.computeNodeGroupConfigurations() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "queueName": {
                return Optional.ofNullable(clazz.cast(this.queueName()));
            }
            case "computeNodeGroupConfigurations": {
                return Optional.ofNullable(clazz.cast(this.computeNodeGroupConfigurations()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("queueName", QUEUE_NAME_FIELD);
        map.put("computeNodeGroupConfigurations", COMPUTE_NODE_GROUP_CONFIGURATIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueRequest, T> g) {
        return obj -> g.apply((CreateQueueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String queueName;
        private List<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.queueName(model.queueName);
            this.computeNodeGroupConfigurations(model.computeNodeGroupConfigurations);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getQueueName() {
            return this.queueName;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final List<ComputeNodeGroupConfiguration.Builder> getComputeNodeGroupConfigurations() {
            List<ComputeNodeGroupConfiguration.Builder> result = ComputeNodeGroupConfigurationListCopier.copyToBuilder(this.computeNodeGroupConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration.BuilderImpl> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copyFromBuilder(computeNodeGroupConfigurations);
        }

        @Override
        public final Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations = ComputeNodeGroupConfigurationListCopier.copy(computeNodeGroupConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration ... computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations(Arrays.asList(computeNodeGroupConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder> ... computeNodeGroupConfigurations) {
            this.computeNodeGroupConfigurations(Stream.of(computeNodeGroupConfigurations).map(c -> (ComputeNodeGroupConfiguration)((ComputeNodeGroupConfiguration.Builder)ComputeNodeGroupConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQueueRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder queueName(String var1);

        public Builder computeNodeGroupConfigurations(Collection<ComputeNodeGroupConfiguration> var1);

        public Builder computeNodeGroupConfigurations(ComputeNodeGroupConfiguration ... var1);

        public Builder computeNodeGroupConfigurations(Consumer<ComputeNodeGroupConfiguration.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

