/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcs.model.ClusterSlurmConfigurationRequest;
import software.amazon.awssdk.services.pcs.model.NetworkingRequest;
import software.amazon.awssdk.services.pcs.model.PcsRequest;
import software.amazon.awssdk.services.pcs.model.RequestTagMapCopier;
import software.amazon.awssdk.services.pcs.model.SchedulerRequest;
import software.amazon.awssdk.services.pcs.model.Size;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends PcsRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<SchedulerRequest> SCHEDULER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scheduler").getter(CreateClusterRequest.getter(CreateClusterRequest::scheduler)).setter(CreateClusterRequest.setter(Builder::scheduler)).constructor(SchedulerRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduler").build()}).build();
    private static final SdkField<String> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("size").getter(CreateClusterRequest.getter(CreateClusterRequest::sizeAsString)).setter(CreateClusterRequest.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<NetworkingRequest> NETWORKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networking").getter(CreateClusterRequest.getter(CreateClusterRequest::networking)).setter(CreateClusterRequest.setter(Builder::networking)).constructor(NetworkingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networking").build()}).build();
    private static final SdkField<ClusterSlurmConfigurationRequest> SLURM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slurmConfiguration").getter(CreateClusterRequest.getter(CreateClusterRequest::slurmConfiguration)).setter(CreateClusterRequest.setter(Builder::slurmConfiguration)).constructor(ClusterSlurmConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateClusterRequest.getter(CreateClusterRequest::clientToken)).setter(CreateClusterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, SCHEDULER_FIELD, SIZE_FIELD, NETWORKING_FIELD, SLURM_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("scheduler", SCHEDULER_FIELD);
            this.put("size", SIZE_FIELD);
            this.put("networking", NETWORKING_FIELD);
            this.put("slurmConfiguration", SLURM_CONFIGURATION_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clusterName;
    private final SchedulerRequest scheduler;
    private final String size;
    private final NetworkingRequest networking;
    private final ClusterSlurmConfigurationRequest slurmConfiguration;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.scheduler = builder.scheduler;
        this.size = builder.size;
        this.networking = builder.networking;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final SchedulerRequest scheduler() {
        return this.scheduler;
    }

    public final Size size() {
        return Size.fromValue(this.size);
    }

    public final String sizeAsString() {
        return this.size;
    }

    public final NetworkingRequest networking() {
        return this.networking;
    }

    public final ClusterSlurmConfigurationRequest slurmConfiguration() {
        return this.slurmConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduler());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networking());
        hashCode = 31 * hashCode + Objects.hashCode(this.slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.scheduler(), other.scheduler()) && Objects.equals(this.sizeAsString(), other.sizeAsString()) && Objects.equals(this.networking(), other.networking()) && Objects.equals(this.slurmConfiguration(), other.slurmConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("Scheduler", (Object)this.scheduler()).add("Size", (Object)this.sizeAsString()).add("Networking", (Object)this.networking()).add("SlurmConfiguration", (Object)this.slurmConfiguration()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "scheduler": {
                return Optional.ofNullable(clazz.cast(this.scheduler()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.sizeAsString()));
            }
            case "networking": {
                return Optional.ofNullable(clazz.cast(this.networking()));
            }
            case "slurmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.slurmConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private SchedulerRequest scheduler;
        private String size;
        private NetworkingRequest networking;
        private ClusterSlurmConfigurationRequest slurmConfiguration;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.scheduler(model.scheduler);
            this.size(model.size);
            this.networking(model.networking);
            this.slurmConfiguration(model.slurmConfiguration);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final SchedulerRequest.Builder getScheduler() {
            return this.scheduler != null ? this.scheduler.toBuilder() : null;
        }

        public final void setScheduler(SchedulerRequest.BuilderImpl scheduler) {
            this.scheduler = scheduler != null ? scheduler.build() : null;
        }

        @Override
        public final Builder scheduler(SchedulerRequest scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public final String getSize() {
            return this.size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder size(Size size) {
            this.size(size == null ? null : size.toString());
            return this;
        }

        public final NetworkingRequest.Builder getNetworking() {
            return this.networking != null ? this.networking.toBuilder() : null;
        }

        public final void setNetworking(NetworkingRequest.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        @Override
        public final Builder networking(NetworkingRequest networking) {
            this.networking = networking;
            return this;
        }

        public final ClusterSlurmConfigurationRequest.Builder getSlurmConfiguration() {
            return this.slurmConfiguration != null ? this.slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(ClusterSlurmConfigurationRequest.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(ClusterSlurmConfigurationRequest slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder scheduler(SchedulerRequest var1);

        default public Builder scheduler(Consumer<SchedulerRequest.Builder> scheduler) {
            return this.scheduler((SchedulerRequest)((SchedulerRequest.Builder)SchedulerRequest.builder().applyMutation(scheduler)).build());
        }

        public Builder size(String var1);

        public Builder size(Size var1);

        public Builder networking(NetworkingRequest var1);

        default public Builder networking(Consumer<NetworkingRequest.Builder> networking) {
            return this.networking((NetworkingRequest)((NetworkingRequest.Builder)NetworkingRequest.builder().applyMutation(networking)).build());
        }

        public Builder slurmConfiguration(ClusterSlurmConfigurationRequest var1);

        default public Builder slurmConfiguration(Consumer<ClusterSlurmConfigurationRequest.Builder> slurmConfiguration) {
            return this.slurmConfiguration((ClusterSlurmConfigurationRequest)((ClusterSlurmConfigurationRequest.Builder)ClusterSlurmConfigurationRequest.builder().applyMutation(slurmConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

