/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupListCopier;
import software.amazon.awssdk.services.pcs.model.ComputeNodeGroupSummary;
import software.amazon.awssdk.services.pcs.model.PcsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComputeNodeGroupsResponse
extends PcsResponse
implements ToCopyableBuilder<Builder, ListComputeNodeGroupsResponse> {
    private static final SdkField<List<ComputeNodeGroupSummary>> COMPUTE_NODE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computeNodeGroups").getter(ListComputeNodeGroupsResponse.getter(ListComputeNodeGroupsResponse::computeNodeGroups)).setter(ListComputeNodeGroupsResponse.setter(Builder::computeNodeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeNodeGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeNodeGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComputeNodeGroupsResponse.getter(ListComputeNodeGroupsResponse::nextToken)).setter(ListComputeNodeGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_NODE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("computeNodeGroups", COMPUTE_NODE_GROUPS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ComputeNodeGroupSummary> computeNodeGroups;
    private final String nextToken;

    private ListComputeNodeGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.computeNodeGroups = builder.computeNodeGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComputeNodeGroups() {
        return this.computeNodeGroups != null && !(this.computeNodeGroups instanceof SdkAutoConstructList);
    }

    public final List<ComputeNodeGroupSummary> computeNodeGroups() {
        return this.computeNodeGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeNodeGroups() ? this.computeNodeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputeNodeGroupsResponse)) {
            return false;
        }
        ListComputeNodeGroupsResponse other = (ListComputeNodeGroupsResponse)((Object)obj);
        return this.hasComputeNodeGroups() == other.hasComputeNodeGroups() && Objects.equals(this.computeNodeGroups(), other.computeNodeGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComputeNodeGroupsResponse").add("ComputeNodeGroups", this.hasComputeNodeGroups() ? this.computeNodeGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeNodeGroups": {
                return Optional.ofNullable(clazz.cast(this.computeNodeGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListComputeNodeGroupsResponse, T> g) {
        return obj -> g.apply((ListComputeNodeGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsResponse.BuilderImpl
    implements Builder {
        private List<ComputeNodeGroupSummary> computeNodeGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputeNodeGroupsResponse model) {
            super(model);
            this.computeNodeGroups(model.computeNodeGroups);
            this.nextToken(model.nextToken);
        }

        public final List<ComputeNodeGroupSummary.Builder> getComputeNodeGroups() {
            List<ComputeNodeGroupSummary.Builder> result = ComputeNodeGroupListCopier.copyToBuilder(this.computeNodeGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeNodeGroups(Collection<ComputeNodeGroupSummary.BuilderImpl> computeNodeGroups) {
            this.computeNodeGroups = ComputeNodeGroupListCopier.copyFromBuilder(computeNodeGroups);
        }

        @Override
        public final Builder computeNodeGroups(Collection<ComputeNodeGroupSummary> computeNodeGroups) {
            this.computeNodeGroups = ComputeNodeGroupListCopier.copy(computeNodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroups(ComputeNodeGroupSummary ... computeNodeGroups) {
            this.computeNodeGroups(Arrays.asList(computeNodeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeNodeGroups(Consumer<ComputeNodeGroupSummary.Builder> ... computeNodeGroups) {
            this.computeNodeGroups(Stream.of(computeNodeGroups).map(c -> (ComputeNodeGroupSummary)((ComputeNodeGroupSummary.Builder)ComputeNodeGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputeNodeGroupsResponse build() {
            return new ListComputeNodeGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComputeNodeGroupsResponse> {
        public Builder computeNodeGroups(Collection<ComputeNodeGroupSummary> var1);

        public Builder computeNodeGroups(ComputeNodeGroupSummary ... var1);

        public Builder computeNodeGroups(Consumer<ComputeNodeGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

