/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.ClusterSlurmConfiguration;
import software.amazon.awssdk.services.pcs.model.ClusterStatus;
import software.amazon.awssdk.services.pcs.model.Endpoint;
import software.amazon.awssdk.services.pcs.model.EndpointsCopier;
import software.amazon.awssdk.services.pcs.model.ErrorInfo;
import software.amazon.awssdk.services.pcs.model.ErrorInfoListCopier;
import software.amazon.awssdk.services.pcs.model.Networking;
import software.amazon.awssdk.services.pcs.model.Scheduler;
import software.amazon.awssdk.services.pcs.model.Size;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Cluster.getter(Cluster::name)).setter(Cluster.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Cluster.getter(Cluster::id)).setter(Cluster.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Cluster.getter(Cluster::arn)).setter(Cluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Cluster.getter(Cluster::statusAsString)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Cluster.getter(Cluster::createdAt)).setter(Cluster.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Cluster.getter(Cluster::modifiedAt)).setter(Cluster.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Scheduler> SCHEDULER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scheduler").getter(Cluster.getter(Cluster::scheduler)).setter(Cluster.setter(Builder::scheduler)).constructor(Scheduler::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduler").build()}).build();
    private static final SdkField<String> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("size").getter(Cluster.getter(Cluster::sizeAsString)).setter(Cluster.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<ClusterSlurmConfiguration> SLURM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("slurmConfiguration").getter(Cluster.getter(Cluster::slurmConfiguration)).setter(Cluster.setter(Builder::slurmConfiguration)).constructor(ClusterSlurmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slurmConfiguration").build()}).build();
    private static final SdkField<Networking> NETWORKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networking").getter(Cluster.getter(Cluster::networking)).setter(Cluster.setter(Builder::networking)).constructor(Networking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networking").build()}).build();
    private static final SdkField<List<Endpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("endpoints").getter(Cluster.getter(Cluster::endpoints)).setter(Cluster.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorInfo>> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorInfo").getter(Cluster.getter(Cluster::errorInfo)).setter(Cluster.setter(Builder::errorInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, SCHEDULER_FIELD, SIZE_FIELD, SLURM_CONFIGURATION_FIELD, NETWORKING_FIELD, ENDPOINTS_FIELD, ERROR_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Scheduler scheduler;
    private final String size;
    private final ClusterSlurmConfiguration slurmConfiguration;
    private final Networking networking;
    private final List<Endpoint> endpoints;
    private final List<ErrorInfo> errorInfo;

    private Cluster(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.scheduler = builder.scheduler;
        this.size = builder.size;
        this.slurmConfiguration = builder.slurmConfiguration;
        this.networking = builder.networking;
        this.endpoints = builder.endpoints;
        this.errorInfo = builder.errorInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final Scheduler scheduler() {
        return this.scheduler;
    }

    public final Size size() {
        return Size.fromValue(this.size);
    }

    public final String sizeAsString() {
        return this.size;
    }

    public final ClusterSlurmConfiguration slurmConfiguration() {
        return this.slurmConfiguration;
    }

    public final Networking networking() {
        return this.networking;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public final boolean hasErrorInfo() {
        return this.errorInfo != null && !(this.errorInfo instanceof SdkAutoConstructList);
    }

    public final List<ErrorInfo> errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduler());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slurmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networking());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorInfo() ? this.errorInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.scheduler(), other.scheduler()) && Objects.equals(this.sizeAsString(), other.sizeAsString()) && Objects.equals(this.slurmConfiguration(), other.slurmConfiguration()) && Objects.equals(this.networking(), other.networking()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && this.hasErrorInfo() == other.hasErrorInfo() && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Scheduler", (Object)this.scheduler()).add("Size", (Object)this.sizeAsString()).add("SlurmConfiguration", (Object)this.slurmConfiguration()).add("Networking", (Object)this.networking()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("ErrorInfo", this.hasErrorInfo() ? this.errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "scheduler": {
                return Optional.ofNullable(clazz.cast(this.scheduler()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.sizeAsString()));
            }
            case "slurmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.slurmConfiguration()));
            }
            case "networking": {
                return Optional.ofNullable(clazz.cast(this.networking()));
            }
            case "endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private String status;
        private Instant createdAt;
        private Instant modifiedAt;
        private Scheduler scheduler;
        private String size;
        private ClusterSlurmConfiguration slurmConfiguration;
        private Networking networking;
        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.scheduler(model.scheduler);
            this.size(model.size);
            this.slurmConfiguration(model.slurmConfiguration);
            this.networking(model.networking);
            this.endpoints(model.endpoints);
            this.errorInfo(model.errorInfo);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Scheduler.Builder getScheduler() {
            return this.scheduler != null ? this.scheduler.toBuilder() : null;
        }

        public final void setScheduler(Scheduler.BuilderImpl scheduler) {
            this.scheduler = scheduler != null ? scheduler.build() : null;
        }

        @Override
        public final Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public final String getSize() {
            return this.size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder size(Size size) {
            this.size(size == null ? null : size.toString());
            return this;
        }

        public final ClusterSlurmConfiguration.Builder getSlurmConfiguration() {
            return this.slurmConfiguration != null ? this.slurmConfiguration.toBuilder() : null;
        }

        public final void setSlurmConfiguration(ClusterSlurmConfiguration.BuilderImpl slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration != null ? slurmConfiguration.build() : null;
        }

        @Override
        public final Builder slurmConfiguration(ClusterSlurmConfiguration slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        public final Networking.Builder getNetworking() {
            return this.networking != null ? this.networking.toBuilder() : null;
        }

        public final void setNetworking(Networking.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        @Override
        public final Builder networking(Networking networking) {
            this.networking = networking;
            return this;
        }

        public final List<Endpoint.Builder> getEndpoints() {
            List<Endpoint.Builder> result = EndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = EndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorInfo.Builder> getErrorInfo() {
            List<ErrorInfo.Builder> result = ErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<ErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<ErrorInfo> errorInfo) {
            this.errorInfo = ErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(ErrorInfo ... errorInfo) {
            this.errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<ErrorInfo.Builder> ... errorInfo) {
            this.errorInfo(Stream.of(errorInfo).map(c -> (ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder scheduler(Scheduler var1);

        default public Builder scheduler(Consumer<Scheduler.Builder> scheduler) {
            return this.scheduler((Scheduler)((Scheduler.Builder)Scheduler.builder().applyMutation(scheduler)).build());
        }

        public Builder size(String var1);

        public Builder size(Size var1);

        public Builder slurmConfiguration(ClusterSlurmConfiguration var1);

        default public Builder slurmConfiguration(Consumer<ClusterSlurmConfiguration.Builder> slurmConfiguration) {
            return this.slurmConfiguration((ClusterSlurmConfiguration)((ClusterSlurmConfiguration.Builder)ClusterSlurmConfiguration.builder().applyMutation(slurmConfiguration)).build());
        }

        public Builder networking(Networking var1);

        default public Builder networking(Consumer<Networking.Builder> networking) {
            return this.networking((Networking)((Networking.Builder)Networking.builder().applyMutation(networking)).build());
        }

        public Builder endpoints(Collection<Endpoint> var1);

        public Builder endpoints(Endpoint ... var1);

        public Builder endpoints(Consumer<Endpoint.Builder> ... var1);

        public Builder errorInfo(Collection<ErrorInfo> var1);

        public Builder errorInfo(ErrorInfo ... var1);

        public Builder errorInfo(Consumer<ErrorInfo.Builder> ... var1);
    }
}

