/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pcaconnectorscep.PcaConnectorScepClient;
import software.amazon.awssdk.services.pcaconnectorscep.internal.UserAgentUtils;
import software.amazon.awssdk.services.pcaconnectorscep.model.ChallengeMetadataSummary;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataRequest;
import software.amazon.awssdk.services.pcaconnectorscep.model.ListChallengeMetadataResponse;

public class ListChallengeMetadataIterable
implements SdkIterable<ListChallengeMetadataResponse> {
    private final PcaConnectorScepClient client;
    private final ListChallengeMetadataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChallengeMetadataIterable(PcaConnectorScepClient client, ListChallengeMetadataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChallengeMetadataResponseFetcher();
    }

    public Iterator<ListChallengeMetadataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChallengeMetadataSummary> challenges() {
        Function<ListChallengeMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.challenges() != null) {
                return response.challenges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChallengeMetadataResponseFetcher
    implements SyncPageFetcher<ListChallengeMetadataResponse> {
        private ListChallengeMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListChallengeMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChallengeMetadataResponse nextPage(ListChallengeMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListChallengeMetadataIterable.this.client.listChallengeMetadata(ListChallengeMetadataIterable.this.firstRequest);
            }
            return ListChallengeMetadataIterable.this.client.listChallengeMetadata((ListChallengeMetadataRequest)((Object)ListChallengeMetadataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

