/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * v2 template schema that uses Legacy Cryptographic Providers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateV2 implements SdkPojo, Serializable, ToCopyableBuilder<TemplateV2.Builder, TemplateV2> {
    private static final SdkField<CertificateValidity> CERTIFICATE_VALIDITY_FIELD = SdkField
            .<CertificateValidity> builder(MarshallingType.SDK_POJO).memberName("CertificateValidity")
            .getter(getter(TemplateV2::certificateValidity)).setter(setter(Builder::certificateValidity))
            .constructor(CertificateValidity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateValidity").build())
            .build();

    private static final SdkField<EnrollmentFlagsV2> ENROLLMENT_FLAGS_FIELD = SdkField
            .<EnrollmentFlagsV2> builder(MarshallingType.SDK_POJO).memberName("EnrollmentFlags")
            .getter(getter(TemplateV2::enrollmentFlags)).setter(setter(Builder::enrollmentFlags))
            .constructor(EnrollmentFlagsV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentFlags").build()).build();

    private static final SdkField<ExtensionsV2> EXTENSIONS_FIELD = SdkField.<ExtensionsV2> builder(MarshallingType.SDK_POJO)
            .memberName("Extensions").getter(getter(TemplateV2::extensions)).setter(setter(Builder::extensions))
            .constructor(ExtensionsV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extensions").build()).build();

    private static final SdkField<GeneralFlagsV2> GENERAL_FLAGS_FIELD = SdkField
            .<GeneralFlagsV2> builder(MarshallingType.SDK_POJO).memberName("GeneralFlags")
            .getter(getter(TemplateV2::generalFlags)).setter(setter(Builder::generalFlags)).constructor(GeneralFlagsV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralFlags").build()).build();

    private static final SdkField<PrivateKeyAttributesV2> PRIVATE_KEY_ATTRIBUTES_FIELD = SdkField
            .<PrivateKeyAttributesV2> builder(MarshallingType.SDK_POJO).memberName("PrivateKeyAttributes")
            .getter(getter(TemplateV2::privateKeyAttributes)).setter(setter(Builder::privateKeyAttributes))
            .constructor(PrivateKeyAttributesV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyAttributes").build())
            .build();

    private static final SdkField<PrivateKeyFlagsV2> PRIVATE_KEY_FLAGS_FIELD = SdkField
            .<PrivateKeyFlagsV2> builder(MarshallingType.SDK_POJO).memberName("PrivateKeyFlags")
            .getter(getter(TemplateV2::privateKeyFlags)).setter(setter(Builder::privateKeyFlags))
            .constructor(PrivateKeyFlagsV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyFlags").build()).build();

    private static final SdkField<SubjectNameFlagsV2> SUBJECT_NAME_FLAGS_FIELD = SdkField
            .<SubjectNameFlagsV2> builder(MarshallingType.SDK_POJO).memberName("SubjectNameFlags")
            .getter(getter(TemplateV2::subjectNameFlags)).setter(setter(Builder::subjectNameFlags))
            .constructor(SubjectNameFlagsV2::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectNameFlags").build()).build();

    private static final SdkField<List<String>> SUPERSEDED_TEMPLATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupersededTemplates")
            .getter(getter(TemplateV2::supersededTemplates))
            .setter(setter(Builder::supersededTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupersededTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_VALIDITY_FIELD,
            ENROLLMENT_FLAGS_FIELD, EXTENSIONS_FIELD, GENERAL_FLAGS_FIELD, PRIVATE_KEY_ATTRIBUTES_FIELD, PRIVATE_KEY_FLAGS_FIELD,
            SUBJECT_NAME_FLAGS_FIELD, SUPERSEDED_TEMPLATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CertificateValidity certificateValidity;

    private final EnrollmentFlagsV2 enrollmentFlags;

    private final ExtensionsV2 extensions;

    private final GeneralFlagsV2 generalFlags;

    private final PrivateKeyAttributesV2 privateKeyAttributes;

    private final PrivateKeyFlagsV2 privateKeyFlags;

    private final SubjectNameFlagsV2 subjectNameFlags;

    private final List<String> supersededTemplates;

    private TemplateV2(BuilderImpl builder) {
        this.certificateValidity = builder.certificateValidity;
        this.enrollmentFlags = builder.enrollmentFlags;
        this.extensions = builder.extensions;
        this.generalFlags = builder.generalFlags;
        this.privateKeyAttributes = builder.privateKeyAttributes;
        this.privateKeyFlags = builder.privateKeyFlags;
        this.subjectNameFlags = builder.subjectNameFlags;
        this.supersededTemplates = builder.supersededTemplates;
    }

    /**
     * <p>
     * Certificate validity describes the validity and renewal periods of a certificate.
     * </p>
     * 
     * @return Certificate validity describes the validity and renewal periods of a certificate.
     */
    public final CertificateValidity certificateValidity() {
        return certificateValidity;
    }

    /**
     * <p>
     * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and
     * deleting expired or revoked certificates.
     * </p>
     * 
     * @return Enrollment flags describe the enrollment settings for certificates such as using the existing private key
     *         and deleting expired or revoked certificates.
     */
    public final EnrollmentFlagsV2 enrollmentFlags() {
        return enrollmentFlags;
    }

    /**
     * <p>
     * Extensions describe the key usage extensions and application policies for a template.
     * </p>
     * 
     * @return Extensions describe the key usage extensions and application policies for a template.
     */
    public final ExtensionsV2 extensions() {
        return extensions;
    }

    /**
     * <p>
     * General flags describe whether the template is used for computers or users and if the template can be used with
     * autoenrollment.
     * </p>
     * 
     * @return General flags describe whether the template is used for computers or users and if the template can be
     *         used with autoenrollment.
     */
    public final GeneralFlagsV2 generalFlags() {
        return generalFlags;
    }

    /**
     * <p>
     * Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for the
     * private key of a certificate for v2 templates. V2 templates allow you to use Legacy Cryptographic Service
     * Providers.
     * </p>
     * 
     * @return Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers
     *         for the private key of a certificate for v2 templates. V2 templates allow you to use Legacy Cryptographic
     *         Service Providers.
     */
    public final PrivateKeyAttributesV2 privateKeyAttributes() {
        return privateKeyAttributes;
    }

    /**
     * <p>
     * Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if
     * user input is required when using a private key.
     * </p>
     * 
     * @return Private key flags for v2 templates specify the client compatibility, if the private key can be exported,
     *         and if user input is required when using a private key.
     */
    public final PrivateKeyFlagsV2 privateKeyFlags() {
        return privateKeyFlags;
    }

    /**
     * <p>
     * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
     * </p>
     * 
     * @return Subject name flags describe the subject name and subject alternate name that is included in a
     *         certificate.
     */
    public final SubjectNameFlagsV2 subjectNameFlags() {
        return subjectNameFlags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupersededTemplates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupersededTemplates() {
        return supersededTemplates != null && !(supersededTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of templates in Active Directory that are superseded by this template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupersededTemplates} method.
     * </p>
     * 
     * @return List of templates in Active Directory that are superseded by this template.
     */
    public final List<String> supersededTemplates() {
        return supersededTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateValidity());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentFlags());
        hashCode = 31 * hashCode + Objects.hashCode(extensions());
        hashCode = 31 * hashCode + Objects.hashCode(generalFlags());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyFlags());
        hashCode = 31 * hashCode + Objects.hashCode(subjectNameFlags());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupersededTemplates() ? supersededTemplates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateV2)) {
            return false;
        }
        TemplateV2 other = (TemplateV2) obj;
        return Objects.equals(certificateValidity(), other.certificateValidity())
                && Objects.equals(enrollmentFlags(), other.enrollmentFlags()) && Objects.equals(extensions(), other.extensions())
                && Objects.equals(generalFlags(), other.generalFlags())
                && Objects.equals(privateKeyAttributes(), other.privateKeyAttributes())
                && Objects.equals(privateKeyFlags(), other.privateKeyFlags())
                && Objects.equals(subjectNameFlags(), other.subjectNameFlags())
                && hasSupersededTemplates() == other.hasSupersededTemplates()
                && Objects.equals(supersededTemplates(), other.supersededTemplates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateV2").add("CertificateValidity", certificateValidity())
                .add("EnrollmentFlags", enrollmentFlags()).add("Extensions", extensions()).add("GeneralFlags", generalFlags())
                .add("PrivateKeyAttributes", privateKeyAttributes()).add("PrivateKeyFlags", privateKeyFlags())
                .add("SubjectNameFlags", subjectNameFlags())
                .add("SupersededTemplates", hasSupersededTemplates() ? supersededTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateValidity":
            return Optional.ofNullable(clazz.cast(certificateValidity()));
        case "EnrollmentFlags":
            return Optional.ofNullable(clazz.cast(enrollmentFlags()));
        case "Extensions":
            return Optional.ofNullable(clazz.cast(extensions()));
        case "GeneralFlags":
            return Optional.ofNullable(clazz.cast(generalFlags()));
        case "PrivateKeyAttributes":
            return Optional.ofNullable(clazz.cast(privateKeyAttributes()));
        case "PrivateKeyFlags":
            return Optional.ofNullable(clazz.cast(privateKeyFlags()));
        case "SubjectNameFlags":
            return Optional.ofNullable(clazz.cast(subjectNameFlags()));
        case "SupersededTemplates":
            return Optional.ofNullable(clazz.cast(supersededTemplates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateValidity", CERTIFICATE_VALIDITY_FIELD);
        map.put("EnrollmentFlags", ENROLLMENT_FLAGS_FIELD);
        map.put("Extensions", EXTENSIONS_FIELD);
        map.put("GeneralFlags", GENERAL_FLAGS_FIELD);
        map.put("PrivateKeyAttributes", PRIVATE_KEY_ATTRIBUTES_FIELD);
        map.put("PrivateKeyFlags", PRIVATE_KEY_FLAGS_FIELD);
        map.put("SubjectNameFlags", SUBJECT_NAME_FLAGS_FIELD);
        map.put("SupersededTemplates", SUPERSEDED_TEMPLATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateV2, T> g) {
        return obj -> g.apply((TemplateV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateV2> {
        /**
         * <p>
         * Certificate validity describes the validity and renewal periods of a certificate.
         * </p>
         * 
         * @param certificateValidity
         *        Certificate validity describes the validity and renewal periods of a certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateValidity(CertificateValidity certificateValidity);

        /**
         * <p>
         * Certificate validity describes the validity and renewal periods of a certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateValidity.Builder} avoiding the
         * need to create one manually via {@link CertificateValidity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateValidity.Builder#build()} is called immediately and
         * its result is passed to {@link #certificateValidity(CertificateValidity)}.
         * 
         * @param certificateValidity
         *        a consumer that will call methods on {@link CertificateValidity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateValidity(CertificateValidity)
         */
        default Builder certificateValidity(Consumer<CertificateValidity.Builder> certificateValidity) {
            return certificateValidity(CertificateValidity.builder().applyMutation(certificateValidity).build());
        }

        /**
         * <p>
         * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and
         * deleting expired or revoked certificates.
         * </p>
         * 
         * @param enrollmentFlags
         *        Enrollment flags describe the enrollment settings for certificates such as using the existing private
         *        key and deleting expired or revoked certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentFlags(EnrollmentFlagsV2 enrollmentFlags);

        /**
         * <p>
         * Enrollment flags describe the enrollment settings for certificates such as using the existing private key and
         * deleting expired or revoked certificates.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnrollmentFlagsV2.Builder} avoiding the
         * need to create one manually via {@link EnrollmentFlagsV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnrollmentFlagsV2.Builder#build()} is called immediately and its
         * result is passed to {@link #enrollmentFlags(EnrollmentFlagsV2)}.
         * 
         * @param enrollmentFlags
         *        a consumer that will call methods on {@link EnrollmentFlagsV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrollmentFlags(EnrollmentFlagsV2)
         */
        default Builder enrollmentFlags(Consumer<EnrollmentFlagsV2.Builder> enrollmentFlags) {
            return enrollmentFlags(EnrollmentFlagsV2.builder().applyMutation(enrollmentFlags).build());
        }

        /**
         * <p>
         * Extensions describe the key usage extensions and application policies for a template.
         * </p>
         * 
         * @param extensions
         *        Extensions describe the key usage extensions and application policies for a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensions(ExtensionsV2 extensions);

        /**
         * <p>
         * Extensions describe the key usage extensions and application policies for a template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtensionsV2.Builder} avoiding the need
         * to create one manually via {@link ExtensionsV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtensionsV2.Builder#build()} is called immediately and its
         * result is passed to {@link #extensions(ExtensionsV2)}.
         * 
         * @param extensions
         *        a consumer that will call methods on {@link ExtensionsV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extensions(ExtensionsV2)
         */
        default Builder extensions(Consumer<ExtensionsV2.Builder> extensions) {
            return extensions(ExtensionsV2.builder().applyMutation(extensions).build());
        }

        /**
         * <p>
         * General flags describe whether the template is used for computers or users and if the template can be used
         * with autoenrollment.
         * </p>
         * 
         * @param generalFlags
         *        General flags describe whether the template is used for computers or users and if the template can be
         *        used with autoenrollment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generalFlags(GeneralFlagsV2 generalFlags);

        /**
         * <p>
         * General flags describe whether the template is used for computers or users and if the template can be used
         * with autoenrollment.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneralFlagsV2.Builder} avoiding the need
         * to create one manually via {@link GeneralFlagsV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneralFlagsV2.Builder#build()} is called immediately and its
         * result is passed to {@link #generalFlags(GeneralFlagsV2)}.
         * 
         * @param generalFlags
         *        a consumer that will call methods on {@link GeneralFlagsV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generalFlags(GeneralFlagsV2)
         */
        default Builder generalFlags(Consumer<GeneralFlagsV2.Builder> generalFlags) {
            return generalFlags(GeneralFlagsV2.builder().applyMutation(generalFlags).build());
        }

        /**
         * <p>
         * Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for
         * the private key of a certificate for v2 templates. V2 templates allow you to use Legacy Cryptographic Service
         * Providers.
         * </p>
         * 
         * @param privateKeyAttributes
         *        Private key attributes allow you to specify the minimal key length, key spec, and cryptographic
         *        providers for the private key of a certificate for v2 templates. V2 templates allow you to use Legacy
         *        Cryptographic Service Providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyAttributes(PrivateKeyAttributesV2 privateKeyAttributes);

        /**
         * <p>
         * Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for
         * the private key of a certificate for v2 templates. V2 templates allow you to use Legacy Cryptographic Service
         * Providers.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateKeyAttributesV2.Builder} avoiding
         * the need to create one manually via {@link PrivateKeyAttributesV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateKeyAttributesV2.Builder#build()} is called immediately and
         * its result is passed to {@link #privateKeyAttributes(PrivateKeyAttributesV2)}.
         * 
         * @param privateKeyAttributes
         *        a consumer that will call methods on {@link PrivateKeyAttributesV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateKeyAttributes(PrivateKeyAttributesV2)
         */
        default Builder privateKeyAttributes(Consumer<PrivateKeyAttributesV2.Builder> privateKeyAttributes) {
            return privateKeyAttributes(PrivateKeyAttributesV2.builder().applyMutation(privateKeyAttributes).build());
        }

        /**
         * <p>
         * Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and
         * if user input is required when using a private key.
         * </p>
         * 
         * @param privateKeyFlags
         *        Private key flags for v2 templates specify the client compatibility, if the private key can be
         *        exported, and if user input is required when using a private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyFlags(PrivateKeyFlagsV2 privateKeyFlags);

        /**
         * <p>
         * Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and
         * if user input is required when using a private key.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateKeyFlagsV2.Builder} avoiding the
         * need to create one manually via {@link PrivateKeyFlagsV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateKeyFlagsV2.Builder#build()} is called immediately and its
         * result is passed to {@link #privateKeyFlags(PrivateKeyFlagsV2)}.
         * 
         * @param privateKeyFlags
         *        a consumer that will call methods on {@link PrivateKeyFlagsV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateKeyFlags(PrivateKeyFlagsV2)
         */
        default Builder privateKeyFlags(Consumer<PrivateKeyFlagsV2.Builder> privateKeyFlags) {
            return privateKeyFlags(PrivateKeyFlagsV2.builder().applyMutation(privateKeyFlags).build());
        }

        /**
         * <p>
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * </p>
         * 
         * @param subjectNameFlags
         *        Subject name flags describe the subject name and subject alternate name that is included in a
         *        certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectNameFlags(SubjectNameFlagsV2 subjectNameFlags);

        /**
         * <p>
         * Subject name flags describe the subject name and subject alternate name that is included in a certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubjectNameFlagsV2.Builder} avoiding the
         * need to create one manually via {@link SubjectNameFlagsV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubjectNameFlagsV2.Builder#build()} is called immediately and its
         * result is passed to {@link #subjectNameFlags(SubjectNameFlagsV2)}.
         * 
         * @param subjectNameFlags
         *        a consumer that will call methods on {@link SubjectNameFlagsV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjectNameFlags(SubjectNameFlagsV2)
         */
        default Builder subjectNameFlags(Consumer<SubjectNameFlagsV2.Builder> subjectNameFlags) {
            return subjectNameFlags(SubjectNameFlagsV2.builder().applyMutation(subjectNameFlags).build());
        }

        /**
         * <p>
         * List of templates in Active Directory that are superseded by this template.
         * </p>
         * 
         * @param supersededTemplates
         *        List of templates in Active Directory that are superseded by this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supersededTemplates(Collection<String> supersededTemplates);

        /**
         * <p>
         * List of templates in Active Directory that are superseded by this template.
         * </p>
         * 
         * @param supersededTemplates
         *        List of templates in Active Directory that are superseded by this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supersededTemplates(String... supersededTemplates);
    }

    static final class BuilderImpl implements Builder {
        private CertificateValidity certificateValidity;

        private EnrollmentFlagsV2 enrollmentFlags;

        private ExtensionsV2 extensions;

        private GeneralFlagsV2 generalFlags;

        private PrivateKeyAttributesV2 privateKeyAttributes;

        private PrivateKeyFlagsV2 privateKeyFlags;

        private SubjectNameFlagsV2 subjectNameFlags;

        private List<String> supersededTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateV2 model) {
            certificateValidity(model.certificateValidity);
            enrollmentFlags(model.enrollmentFlags);
            extensions(model.extensions);
            generalFlags(model.generalFlags);
            privateKeyAttributes(model.privateKeyAttributes);
            privateKeyFlags(model.privateKeyFlags);
            subjectNameFlags(model.subjectNameFlags);
            supersededTemplates(model.supersededTemplates);
        }

        public final CertificateValidity.Builder getCertificateValidity() {
            return certificateValidity != null ? certificateValidity.toBuilder() : null;
        }

        public final void setCertificateValidity(CertificateValidity.BuilderImpl certificateValidity) {
            this.certificateValidity = certificateValidity != null ? certificateValidity.build() : null;
        }

        @Override
        public final Builder certificateValidity(CertificateValidity certificateValidity) {
            this.certificateValidity = certificateValidity;
            return this;
        }

        public final EnrollmentFlagsV2.Builder getEnrollmentFlags() {
            return enrollmentFlags != null ? enrollmentFlags.toBuilder() : null;
        }

        public final void setEnrollmentFlags(EnrollmentFlagsV2.BuilderImpl enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags != null ? enrollmentFlags.build() : null;
        }

        @Override
        public final Builder enrollmentFlags(EnrollmentFlagsV2 enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags;
            return this;
        }

        public final ExtensionsV2.Builder getExtensions() {
            return extensions != null ? extensions.toBuilder() : null;
        }

        public final void setExtensions(ExtensionsV2.BuilderImpl extensions) {
            this.extensions = extensions != null ? extensions.build() : null;
        }

        @Override
        public final Builder extensions(ExtensionsV2 extensions) {
            this.extensions = extensions;
            return this;
        }

        public final GeneralFlagsV2.Builder getGeneralFlags() {
            return generalFlags != null ? generalFlags.toBuilder() : null;
        }

        public final void setGeneralFlags(GeneralFlagsV2.BuilderImpl generalFlags) {
            this.generalFlags = generalFlags != null ? generalFlags.build() : null;
        }

        @Override
        public final Builder generalFlags(GeneralFlagsV2 generalFlags) {
            this.generalFlags = generalFlags;
            return this;
        }

        public final PrivateKeyAttributesV2.Builder getPrivateKeyAttributes() {
            return privateKeyAttributes != null ? privateKeyAttributes.toBuilder() : null;
        }

        public final void setPrivateKeyAttributes(PrivateKeyAttributesV2.BuilderImpl privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes != null ? privateKeyAttributes.build() : null;
        }

        @Override
        public final Builder privateKeyAttributes(PrivateKeyAttributesV2 privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes;
            return this;
        }

        public final PrivateKeyFlagsV2.Builder getPrivateKeyFlags() {
            return privateKeyFlags != null ? privateKeyFlags.toBuilder() : null;
        }

        public final void setPrivateKeyFlags(PrivateKeyFlagsV2.BuilderImpl privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags != null ? privateKeyFlags.build() : null;
        }

        @Override
        public final Builder privateKeyFlags(PrivateKeyFlagsV2 privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags;
            return this;
        }

        public final SubjectNameFlagsV2.Builder getSubjectNameFlags() {
            return subjectNameFlags != null ? subjectNameFlags.toBuilder() : null;
        }

        public final void setSubjectNameFlags(SubjectNameFlagsV2.BuilderImpl subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags != null ? subjectNameFlags.build() : null;
        }

        @Override
        public final Builder subjectNameFlags(SubjectNameFlagsV2 subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags;
            return this;
        }

        public final Collection<String> getSupersededTemplates() {
            if (supersededTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return supersededTemplates;
        }

        public final void setSupersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
        }

        @Override
        public final Builder supersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supersededTemplates(String... supersededTemplates) {
            supersededTemplates(Arrays.asList(supersededTemplates));
            return this;
        }

        @Override
        public TemplateV2 build() {
            return new TemplateV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
