/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information to include in the subject name and alternate subject name of the certificate. The subject name can be
 * common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name
 * for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject
 * alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name
 * (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a
 * subject name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubjectNameFlagsV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<SubjectNameFlagsV2.Builder, SubjectNameFlagsV2> {
    private static final SdkField<Boolean> REQUIRE_COMMON_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireCommonName").getter(getter(SubjectNameFlagsV2::requireCommonName))
            .setter(setter(Builder::requireCommonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireCommonName").build()).build();

    private static final SdkField<Boolean> REQUIRE_DIRECTORY_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireDirectoryPath").getter(getter(SubjectNameFlagsV2::requireDirectoryPath))
            .setter(setter(Builder::requireDirectoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireDirectoryPath").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_DNS_AS_CN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireDnsAsCn").getter(getter(SubjectNameFlagsV2::requireDnsAsCn))
            .setter(setter(Builder::requireDnsAsCn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireDnsAsCn").build()).build();

    private static final SdkField<Boolean> REQUIRE_EMAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireEmail").getter(getter(SubjectNameFlagsV2::requireEmail)).setter(setter(Builder::requireEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireEmail").build()).build();

    private static final SdkField<Boolean> SAN_REQUIRE_DIRECTORY_GUID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SanRequireDirectoryGuid").getter(getter(SubjectNameFlagsV2::sanRequireDirectoryGuid))
            .setter(setter(Builder::sanRequireDirectoryGuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SanRequireDirectoryGuid").build())
            .build();

    private static final SdkField<Boolean> SAN_REQUIRE_DNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SanRequireDns").getter(getter(SubjectNameFlagsV2::sanRequireDns)).setter(setter(Builder::sanRequireDns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SanRequireDns").build()).build();

    private static final SdkField<Boolean> SAN_REQUIRE_DOMAIN_DNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SanRequireDomainDns").getter(getter(SubjectNameFlagsV2::sanRequireDomainDns))
            .setter(setter(Builder::sanRequireDomainDns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SanRequireDomainDns").build())
            .build();

    private static final SdkField<Boolean> SAN_REQUIRE_EMAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SanRequireEmail").getter(getter(SubjectNameFlagsV2::sanRequireEmail))
            .setter(setter(Builder::sanRequireEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SanRequireEmail").build()).build();

    private static final SdkField<Boolean> SAN_REQUIRE_SPN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SanRequireSpn").getter(getter(SubjectNameFlagsV2::sanRequireSpn)).setter(setter(Builder::sanRequireSpn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SanRequireSpn").build()).build();

    private static final SdkField<Boolean> SAN_REQUIRE_UPN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SanRequireUpn").getter(getter(SubjectNameFlagsV2::sanRequireUpn)).setter(setter(Builder::sanRequireUpn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SanRequireUpn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRE_COMMON_NAME_FIELD,
            REQUIRE_DIRECTORY_PATH_FIELD, REQUIRE_DNS_AS_CN_FIELD, REQUIRE_EMAIL_FIELD, SAN_REQUIRE_DIRECTORY_GUID_FIELD,
            SAN_REQUIRE_DNS_FIELD, SAN_REQUIRE_DOMAIN_DNS_FIELD, SAN_REQUIRE_EMAIL_FIELD, SAN_REQUIRE_SPN_FIELD,
            SAN_REQUIRE_UPN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean requireCommonName;

    private final Boolean requireDirectoryPath;

    private final Boolean requireDnsAsCn;

    private final Boolean requireEmail;

    private final Boolean sanRequireDirectoryGuid;

    private final Boolean sanRequireDns;

    private final Boolean sanRequireDomainDns;

    private final Boolean sanRequireEmail;

    private final Boolean sanRequireSpn;

    private final Boolean sanRequireUpn;

    private SubjectNameFlagsV2(BuilderImpl builder) {
        this.requireCommonName = builder.requireCommonName;
        this.requireDirectoryPath = builder.requireDirectoryPath;
        this.requireDnsAsCn = builder.requireDnsAsCn;
        this.requireEmail = builder.requireEmail;
        this.sanRequireDirectoryGuid = builder.sanRequireDirectoryGuid;
        this.sanRequireDns = builder.sanRequireDns;
        this.sanRequireDomainDns = builder.sanRequireDomainDns;
        this.sanRequireEmail = builder.sanRequireEmail;
        this.sanRequireSpn = builder.sanRequireSpn;
        this.sanRequireUpn = builder.sanRequireUpn;
    }

    /**
     * <p>
     * Include the common name in the subject name.
     * </p>
     * 
     * @return Include the common name in the subject name.
     */
    public final Boolean requireCommonName() {
        return requireCommonName;
    }

    /**
     * <p>
     * Include the directory path in the subject name.
     * </p>
     * 
     * @return Include the directory path in the subject name.
     */
    public final Boolean requireDirectoryPath() {
        return requireDirectoryPath;
    }

    /**
     * <p>
     * Include the DNS as common name in the subject name.
     * </p>
     * 
     * @return Include the DNS as common name in the subject name.
     */
    public final Boolean requireDnsAsCn() {
        return requireDnsAsCn;
    }

    /**
     * <p>
     * Include the subject's email in the subject name.
     * </p>
     * 
     * @return Include the subject's email in the subject name.
     */
    public final Boolean requireEmail() {
        return requireEmail;
    }

    /**
     * <p>
     * Include the globally unique identifier (GUID) in the subject alternate name.
     * </p>
     * 
     * @return Include the globally unique identifier (GUID) in the subject alternate name.
     */
    public final Boolean sanRequireDirectoryGuid() {
        return sanRequireDirectoryGuid;
    }

    /**
     * <p>
     * Include the DNS in the subject alternate name.
     * </p>
     * 
     * @return Include the DNS in the subject alternate name.
     */
    public final Boolean sanRequireDns() {
        return sanRequireDns;
    }

    /**
     * <p>
     * Include the domain DNS in the subject alternate name.
     * </p>
     * 
     * @return Include the domain DNS in the subject alternate name.
     */
    public final Boolean sanRequireDomainDns() {
        return sanRequireDomainDns;
    }

    /**
     * <p>
     * Include the subject's email in the subject alternate name.
     * </p>
     * 
     * @return Include the subject's email in the subject alternate name.
     */
    public final Boolean sanRequireEmail() {
        return sanRequireEmail;
    }

    /**
     * <p>
     * Include the service principal name (SPN) in the subject alternate name.
     * </p>
     * 
     * @return Include the service principal name (SPN) in the subject alternate name.
     */
    public final Boolean sanRequireSpn() {
        return sanRequireSpn;
    }

    /**
     * <p>
     * Include the user principal name (UPN) in the subject alternate name.
     * </p>
     * 
     * @return Include the user principal name (UPN) in the subject alternate name.
     */
    public final Boolean sanRequireUpn() {
        return sanRequireUpn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requireCommonName());
        hashCode = 31 * hashCode + Objects.hashCode(requireDirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(requireDnsAsCn());
        hashCode = 31 * hashCode + Objects.hashCode(requireEmail());
        hashCode = 31 * hashCode + Objects.hashCode(sanRequireDirectoryGuid());
        hashCode = 31 * hashCode + Objects.hashCode(sanRequireDns());
        hashCode = 31 * hashCode + Objects.hashCode(sanRequireDomainDns());
        hashCode = 31 * hashCode + Objects.hashCode(sanRequireEmail());
        hashCode = 31 * hashCode + Objects.hashCode(sanRequireSpn());
        hashCode = 31 * hashCode + Objects.hashCode(sanRequireUpn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectNameFlagsV2)) {
            return false;
        }
        SubjectNameFlagsV2 other = (SubjectNameFlagsV2) obj;
        return Objects.equals(requireCommonName(), other.requireCommonName())
                && Objects.equals(requireDirectoryPath(), other.requireDirectoryPath())
                && Objects.equals(requireDnsAsCn(), other.requireDnsAsCn())
                && Objects.equals(requireEmail(), other.requireEmail())
                && Objects.equals(sanRequireDirectoryGuid(), other.sanRequireDirectoryGuid())
                && Objects.equals(sanRequireDns(), other.sanRequireDns())
                && Objects.equals(sanRequireDomainDns(), other.sanRequireDomainDns())
                && Objects.equals(sanRequireEmail(), other.sanRequireEmail())
                && Objects.equals(sanRequireSpn(), other.sanRequireSpn())
                && Objects.equals(sanRequireUpn(), other.sanRequireUpn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubjectNameFlagsV2").add("RequireCommonName", requireCommonName())
                .add("RequireDirectoryPath", requireDirectoryPath()).add("RequireDnsAsCn", requireDnsAsCn())
                .add("RequireEmail", requireEmail()).add("SanRequireDirectoryGuid", sanRequireDirectoryGuid())
                .add("SanRequireDns", sanRequireDns()).add("SanRequireDomainDns", sanRequireDomainDns())
                .add("SanRequireEmail", sanRequireEmail()).add("SanRequireSpn", sanRequireSpn())
                .add("SanRequireUpn", sanRequireUpn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequireCommonName":
            return Optional.ofNullable(clazz.cast(requireCommonName()));
        case "RequireDirectoryPath":
            return Optional.ofNullable(clazz.cast(requireDirectoryPath()));
        case "RequireDnsAsCn":
            return Optional.ofNullable(clazz.cast(requireDnsAsCn()));
        case "RequireEmail":
            return Optional.ofNullable(clazz.cast(requireEmail()));
        case "SanRequireDirectoryGuid":
            return Optional.ofNullable(clazz.cast(sanRequireDirectoryGuid()));
        case "SanRequireDns":
            return Optional.ofNullable(clazz.cast(sanRequireDns()));
        case "SanRequireDomainDns":
            return Optional.ofNullable(clazz.cast(sanRequireDomainDns()));
        case "SanRequireEmail":
            return Optional.ofNullable(clazz.cast(sanRequireEmail()));
        case "SanRequireSpn":
            return Optional.ofNullable(clazz.cast(sanRequireSpn()));
        case "SanRequireUpn":
            return Optional.ofNullable(clazz.cast(sanRequireUpn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequireCommonName", REQUIRE_COMMON_NAME_FIELD);
        map.put("RequireDirectoryPath", REQUIRE_DIRECTORY_PATH_FIELD);
        map.put("RequireDnsAsCn", REQUIRE_DNS_AS_CN_FIELD);
        map.put("RequireEmail", REQUIRE_EMAIL_FIELD);
        map.put("SanRequireDirectoryGuid", SAN_REQUIRE_DIRECTORY_GUID_FIELD);
        map.put("SanRequireDns", SAN_REQUIRE_DNS_FIELD);
        map.put("SanRequireDomainDns", SAN_REQUIRE_DOMAIN_DNS_FIELD);
        map.put("SanRequireEmail", SAN_REQUIRE_EMAIL_FIELD);
        map.put("SanRequireSpn", SAN_REQUIRE_SPN_FIELD);
        map.put("SanRequireUpn", SAN_REQUIRE_UPN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubjectNameFlagsV2, T> g) {
        return obj -> g.apply((SubjectNameFlagsV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubjectNameFlagsV2> {
        /**
         * <p>
         * Include the common name in the subject name.
         * </p>
         * 
         * @param requireCommonName
         *        Include the common name in the subject name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireCommonName(Boolean requireCommonName);

        /**
         * <p>
         * Include the directory path in the subject name.
         * </p>
         * 
         * @param requireDirectoryPath
         *        Include the directory path in the subject name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireDirectoryPath(Boolean requireDirectoryPath);

        /**
         * <p>
         * Include the DNS as common name in the subject name.
         * </p>
         * 
         * @param requireDnsAsCn
         *        Include the DNS as common name in the subject name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireDnsAsCn(Boolean requireDnsAsCn);

        /**
         * <p>
         * Include the subject's email in the subject name.
         * </p>
         * 
         * @param requireEmail
         *        Include the subject's email in the subject name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireEmail(Boolean requireEmail);

        /**
         * <p>
         * Include the globally unique identifier (GUID) in the subject alternate name.
         * </p>
         * 
         * @param sanRequireDirectoryGuid
         *        Include the globally unique identifier (GUID) in the subject alternate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sanRequireDirectoryGuid(Boolean sanRequireDirectoryGuid);

        /**
         * <p>
         * Include the DNS in the subject alternate name.
         * </p>
         * 
         * @param sanRequireDns
         *        Include the DNS in the subject alternate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sanRequireDns(Boolean sanRequireDns);

        /**
         * <p>
         * Include the domain DNS in the subject alternate name.
         * </p>
         * 
         * @param sanRequireDomainDns
         *        Include the domain DNS in the subject alternate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sanRequireDomainDns(Boolean sanRequireDomainDns);

        /**
         * <p>
         * Include the subject's email in the subject alternate name.
         * </p>
         * 
         * @param sanRequireEmail
         *        Include the subject's email in the subject alternate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sanRequireEmail(Boolean sanRequireEmail);

        /**
         * <p>
         * Include the service principal name (SPN) in the subject alternate name.
         * </p>
         * 
         * @param sanRequireSpn
         *        Include the service principal name (SPN) in the subject alternate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sanRequireSpn(Boolean sanRequireSpn);

        /**
         * <p>
         * Include the user principal name (UPN) in the subject alternate name.
         * </p>
         * 
         * @param sanRequireUpn
         *        Include the user principal name (UPN) in the subject alternate name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sanRequireUpn(Boolean sanRequireUpn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean requireCommonName;

        private Boolean requireDirectoryPath;

        private Boolean requireDnsAsCn;

        private Boolean requireEmail;

        private Boolean sanRequireDirectoryGuid;

        private Boolean sanRequireDns;

        private Boolean sanRequireDomainDns;

        private Boolean sanRequireEmail;

        private Boolean sanRequireSpn;

        private Boolean sanRequireUpn;

        private BuilderImpl() {
        }

        private BuilderImpl(SubjectNameFlagsV2 model) {
            requireCommonName(model.requireCommonName);
            requireDirectoryPath(model.requireDirectoryPath);
            requireDnsAsCn(model.requireDnsAsCn);
            requireEmail(model.requireEmail);
            sanRequireDirectoryGuid(model.sanRequireDirectoryGuid);
            sanRequireDns(model.sanRequireDns);
            sanRequireDomainDns(model.sanRequireDomainDns);
            sanRequireEmail(model.sanRequireEmail);
            sanRequireSpn(model.sanRequireSpn);
            sanRequireUpn(model.sanRequireUpn);
        }

        public final Boolean getRequireCommonName() {
            return requireCommonName;
        }

        public final void setRequireCommonName(Boolean requireCommonName) {
            this.requireCommonName = requireCommonName;
        }

        @Override
        public final Builder requireCommonName(Boolean requireCommonName) {
            this.requireCommonName = requireCommonName;
            return this;
        }

        public final Boolean getRequireDirectoryPath() {
            return requireDirectoryPath;
        }

        public final void setRequireDirectoryPath(Boolean requireDirectoryPath) {
            this.requireDirectoryPath = requireDirectoryPath;
        }

        @Override
        public final Builder requireDirectoryPath(Boolean requireDirectoryPath) {
            this.requireDirectoryPath = requireDirectoryPath;
            return this;
        }

        public final Boolean getRequireDnsAsCn() {
            return requireDnsAsCn;
        }

        public final void setRequireDnsAsCn(Boolean requireDnsAsCn) {
            this.requireDnsAsCn = requireDnsAsCn;
        }

        @Override
        public final Builder requireDnsAsCn(Boolean requireDnsAsCn) {
            this.requireDnsAsCn = requireDnsAsCn;
            return this;
        }

        public final Boolean getRequireEmail() {
            return requireEmail;
        }

        public final void setRequireEmail(Boolean requireEmail) {
            this.requireEmail = requireEmail;
        }

        @Override
        public final Builder requireEmail(Boolean requireEmail) {
            this.requireEmail = requireEmail;
            return this;
        }

        public final Boolean getSanRequireDirectoryGuid() {
            return sanRequireDirectoryGuid;
        }

        public final void setSanRequireDirectoryGuid(Boolean sanRequireDirectoryGuid) {
            this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
        }

        @Override
        public final Builder sanRequireDirectoryGuid(Boolean sanRequireDirectoryGuid) {
            this.sanRequireDirectoryGuid = sanRequireDirectoryGuid;
            return this;
        }

        public final Boolean getSanRequireDns() {
            return sanRequireDns;
        }

        public final void setSanRequireDns(Boolean sanRequireDns) {
            this.sanRequireDns = sanRequireDns;
        }

        @Override
        public final Builder sanRequireDns(Boolean sanRequireDns) {
            this.sanRequireDns = sanRequireDns;
            return this;
        }

        public final Boolean getSanRequireDomainDns() {
            return sanRequireDomainDns;
        }

        public final void setSanRequireDomainDns(Boolean sanRequireDomainDns) {
            this.sanRequireDomainDns = sanRequireDomainDns;
        }

        @Override
        public final Builder sanRequireDomainDns(Boolean sanRequireDomainDns) {
            this.sanRequireDomainDns = sanRequireDomainDns;
            return this;
        }

        public final Boolean getSanRequireEmail() {
            return sanRequireEmail;
        }

        public final void setSanRequireEmail(Boolean sanRequireEmail) {
            this.sanRequireEmail = sanRequireEmail;
        }

        @Override
        public final Builder sanRequireEmail(Boolean sanRequireEmail) {
            this.sanRequireEmail = sanRequireEmail;
            return this;
        }

        public final Boolean getSanRequireSpn() {
            return sanRequireSpn;
        }

        public final void setSanRequireSpn(Boolean sanRequireSpn) {
            this.sanRequireSpn = sanRequireSpn;
        }

        @Override
        public final Builder sanRequireSpn(Boolean sanRequireSpn) {
            this.sanRequireSpn = sanRequireSpn;
            return this;
        }

        public final Boolean getSanRequireUpn() {
            return sanRequireUpn;
        }

        public final void setSanRequireUpn(Boolean sanRequireUpn) {
            this.sanRequireUpn = sanRequireUpn;
        }

        @Override
        public final Builder sanRequireUpn(Boolean sanRequireUpn) {
            this.sanRequireUpn = sanRequireUpn;
            return this;
        }

        @Override
        public SubjectNameFlagsV2 build() {
            return new SubjectNameFlagsV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
