/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service principal name that the connector uses to authenticate with Active Directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServicePrincipalNameSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServicePrincipalNameSummary.Builder, ServicePrincipalNameSummary> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorArn").getter(getter(ServicePrincipalNameSummary::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ServicePrincipalNameSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DIRECTORY_REGISTRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryRegistrationArn").getter(getter(ServicePrincipalNameSummary::directoryRegistrationArn))
            .setter(setter(Builder::directoryRegistrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryRegistrationArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ServicePrincipalNameSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(ServicePrincipalNameSummary::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ServicePrincipalNameSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CREATED_AT_FIELD, DIRECTORY_REGISTRATION_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorArn;

    private final Instant createdAt;

    private final String directoryRegistrationArn;

    private final String status;

    private final String statusReason;

    private final Instant updatedAt;

    private ServicePrincipalNameSummary(BuilderImpl builder) {
        this.connectorArn = builder.connectorArn;
        this.createdAt = builder.createdAt;
        this.directoryRegistrationArn = builder.directoryRegistrationArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     * >CreateConnector</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
     *         >CreateConnector</a>.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The date and time that the service principal name was created.
     * </p>
     * 
     * @return The date and time that the service principal name was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     * >CreateDirectoryRegistration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
     *         >CreateDirectoryRegistration</a>.
     */
    public final String directoryRegistrationArn() {
        return directoryRegistrationArn;
    }

    /**
     * <p>
     * The status of a service principal name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServicePrincipalNameStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a service principal name.
     * @see ServicePrincipalNameStatus
     */
    public final ServicePrincipalNameStatus status() {
        return ServicePrincipalNameStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a service principal name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServicePrincipalNameStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a service principal name.
     * @see ServicePrincipalNameStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information for the status of a service principal name if the status is failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ServicePrincipalNameStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Additional information for the status of a service principal name if the status is failed.
     * @see ServicePrincipalNameStatusReason
     */
    public final ServicePrincipalNameStatusReason statusReason() {
        return ServicePrincipalNameStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * Additional information for the status of a service principal name if the status is failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link ServicePrincipalNameStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusReasonAsString}.
     * </p>
     * 
     * @return Additional information for the status of a service principal name if the status is failed.
     * @see ServicePrincipalNameStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * Time when the service principal name was updated.
     * </p>
     * 
     * @return Time when the service principal name was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(directoryRegistrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServicePrincipalNameSummary)) {
            return false;
        }
        ServicePrincipalNameSummary other = (ServicePrincipalNameSummary) obj;
        return Objects.equals(connectorArn(), other.connectorArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(directoryRegistrationArn(), other.directoryRegistrationArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServicePrincipalNameSummary").add("ConnectorArn", connectorArn()).add("CreatedAt", createdAt())
                .add("DirectoryRegistrationArn", directoryRegistrationArn()).add("Status", statusAsString())
                .add("StatusReason", statusReasonAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DirectoryRegistrationArn":
            return Optional.ofNullable(clazz.cast(directoryRegistrationArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DirectoryRegistrationArn", DIRECTORY_REGISTRATION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServicePrincipalNameSummary, T> g) {
        return obj -> g.apply((ServicePrincipalNameSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServicePrincipalNameSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         * >CreateConnector</a>.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html"
         *        >CreateConnector</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The date and time that the service principal name was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the service principal name was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a href=
         * "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         * >CreateDirectoryRegistration</a>.
         * </p>
         * 
         * @param directoryRegistrationArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a href=
         *        "https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html"
         *        >CreateDirectoryRegistration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryRegistrationArn(String directoryRegistrationArn);

        /**
         * <p>
         * The status of a service principal name.
         * </p>
         * 
         * @param status
         *        The status of a service principal name.
         * @see ServicePrincipalNameStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServicePrincipalNameStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a service principal name.
         * </p>
         * 
         * @param status
         *        The status of a service principal name.
         * @see ServicePrincipalNameStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServicePrincipalNameStatus
         */
        Builder status(ServicePrincipalNameStatus status);

        /**
         * <p>
         * Additional information for the status of a service principal name if the status is failed.
         * </p>
         * 
         * @param statusReason
         *        Additional information for the status of a service principal name if the status is failed.
         * @see ServicePrincipalNameStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServicePrincipalNameStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Additional information for the status of a service principal name if the status is failed.
         * </p>
         * 
         * @param statusReason
         *        Additional information for the status of a service principal name if the status is failed.
         * @see ServicePrincipalNameStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServicePrincipalNameStatusReason
         */
        Builder statusReason(ServicePrincipalNameStatusReason statusReason);

        /**
         * <p>
         * Time when the service principal name was updated.
         * </p>
         * 
         * @param updatedAt
         *        Time when the service principal name was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String connectorArn;

        private Instant createdAt;

        private String directoryRegistrationArn;

        private String status;

        private String statusReason;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServicePrincipalNameSummary model) {
            connectorArn(model.connectorArn);
            createdAt(model.createdAt);
            directoryRegistrationArn(model.directoryRegistrationArn);
            status(model.status);
            statusReason(model.statusReason);
            updatedAt(model.updatedAt);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDirectoryRegistrationArn() {
            return directoryRegistrationArn;
        }

        public final void setDirectoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
        }

        @Override
        public final Builder directoryRegistrationArn(String directoryRegistrationArn) {
            this.directoryRegistrationArn = directoryRegistrationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServicePrincipalNameStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(ServicePrincipalNameStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ServicePrincipalNameSummary build() {
            return new ServicePrincipalNameSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
