/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user
 * input is required when using a private key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateKeyFlagsV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateKeyFlagsV2.Builder, PrivateKeyFlagsV2> {
    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientVersion").getter(getter(PrivateKeyFlagsV2::clientVersionAsString))
            .setter(setter(Builder::clientVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()).build();

    private static final SdkField<Boolean> EXPORTABLE_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExportableKey").getter(getter(PrivateKeyFlagsV2::exportableKey)).setter(setter(Builder::exportableKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableKey").build()).build();

    private static final SdkField<Boolean> STRONG_KEY_PROTECTION_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StrongKeyProtectionRequired")
            .getter(getter(PrivateKeyFlagsV2::strongKeyProtectionRequired))
            .setter(setter(Builder::strongKeyProtectionRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrongKeyProtectionRequired")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VERSION_FIELD,
            EXPORTABLE_KEY_FIELD, STRONG_KEY_PROTECTION_REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientVersion;

    private final Boolean exportableKey;

    private final Boolean strongKeyProtectionRequired;

    private PrivateKeyFlagsV2(BuilderImpl builder) {
        this.clientVersion = builder.clientVersion;
        this.exportableKey = builder.exportableKey;
        this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
    }

    /**
     * <p>
     * Defines the minimum client compatibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientCompatibilityV2#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #clientVersionAsString}.
     * </p>
     * 
     * @return Defines the minimum client compatibility.
     * @see ClientCompatibilityV2
     */
    public final ClientCompatibilityV2 clientVersion() {
        return ClientCompatibilityV2.fromValue(clientVersion);
    }

    /**
     * <p>
     * Defines the minimum client compatibility.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientVersion}
     * will return {@link ClientCompatibilityV2#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #clientVersionAsString}.
     * </p>
     * 
     * @return Defines the minimum client compatibility.
     * @see ClientCompatibilityV2
     */
    public final String clientVersionAsString() {
        return clientVersion;
    }

    /**
     * <p>
     * Allows the private key to be exported.
     * </p>
     * 
     * @return Allows the private key to be exported.
     */
    public final Boolean exportableKey() {
        return exportableKey;
    }

    /**
     * <p>
     * Require user input when using the private key for enrollment.
     * </p>
     * 
     * @return Require user input when using the private key for enrollment.
     */
    public final Boolean strongKeyProtectionRequired() {
        return strongKeyProtectionRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportableKey());
        hashCode = 31 * hashCode + Objects.hashCode(strongKeyProtectionRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyFlagsV2)) {
            return false;
        }
        PrivateKeyFlagsV2 other = (PrivateKeyFlagsV2) obj;
        return Objects.equals(clientVersionAsString(), other.clientVersionAsString())
                && Objects.equals(exportableKey(), other.exportableKey())
                && Objects.equals(strongKeyProtectionRequired(), other.strongKeyProtectionRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateKeyFlagsV2").add("ClientVersion", clientVersionAsString())
                .add("ExportableKey", exportableKey()).add("StrongKeyProtectionRequired", strongKeyProtectionRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVersion":
            return Optional.ofNullable(clazz.cast(clientVersionAsString()));
        case "ExportableKey":
            return Optional.ofNullable(clazz.cast(exportableKey()));
        case "StrongKeyProtectionRequired":
            return Optional.ofNullable(clazz.cast(strongKeyProtectionRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientVersion", CLIENT_VERSION_FIELD);
        map.put("ExportableKey", EXPORTABLE_KEY_FIELD);
        map.put("StrongKeyProtectionRequired", STRONG_KEY_PROTECTION_REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyFlagsV2, T> g) {
        return obj -> g.apply((PrivateKeyFlagsV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateKeyFlagsV2> {
        /**
         * <p>
         * Defines the minimum client compatibility.
         * </p>
         * 
         * @param clientVersion
         *        Defines the minimum client compatibility.
         * @see ClientCompatibilityV2
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCompatibilityV2
         */
        Builder clientVersion(String clientVersion);

        /**
         * <p>
         * Defines the minimum client compatibility.
         * </p>
         * 
         * @param clientVersion
         *        Defines the minimum client compatibility.
         * @see ClientCompatibilityV2
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCompatibilityV2
         */
        Builder clientVersion(ClientCompatibilityV2 clientVersion);

        /**
         * <p>
         * Allows the private key to be exported.
         * </p>
         * 
         * @param exportableKey
         *        Allows the private key to be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableKey(Boolean exportableKey);

        /**
         * <p>
         * Require user input when using the private key for enrollment.
         * </p>
         * 
         * @param strongKeyProtectionRequired
         *        Require user input when using the private key for enrollment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired);
    }

    static final class BuilderImpl implements Builder {
        private String clientVersion;

        private Boolean exportableKey;

        private Boolean strongKeyProtectionRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyFlagsV2 model) {
            clientVersion(model.clientVersion);
            exportableKey(model.exportableKey);
            strongKeyProtectionRequired(model.strongKeyProtectionRequired);
        }

        public final String getClientVersion() {
            return clientVersion;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientCompatibilityV2 clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final Boolean getExportableKey() {
            return exportableKey;
        }

        public final void setExportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
        }

        @Override
        public final Builder exportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
            return this;
        }

        public final Boolean getStrongKeyProtectionRequired() {
            return strongKeyProtectionRequired;
        }

        public final void setStrongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
        }

        @Override
        public final Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
            return this;
        }

        @Override
        public PrivateKeyFlagsV2 build() {
            return new PrivateKeyFlagsV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
