/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplateGroupAccessControlEntriesResponse extends PcaConnectorAdResponse implements
        ToCopyableBuilder<ListTemplateGroupAccessControlEntriesResponse.Builder, ListTemplateGroupAccessControlEntriesResponse> {
    private static final SdkField<List<AccessControlEntrySummary>> ACCESS_CONTROL_ENTRIES_FIELD = SdkField
            .<List<AccessControlEntrySummary>> builder(MarshallingType.LIST)
            .memberName("AccessControlEntries")
            .getter(getter(ListTemplateGroupAccessControlEntriesResponse::accessControlEntries))
            .setter(setter(Builder::accessControlEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessControlEntrySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessControlEntrySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTemplateGroupAccessControlEntriesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccessControlEntrySummary> accessControlEntries;

    private final String nextToken;

    private ListTemplateGroupAccessControlEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.accessControlEntries = builder.accessControlEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessControlEntries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessControlEntries() {
        return accessControlEntries != null && !(accessControlEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An access control entry grants or denies permission to an Active Directory group to enroll certificates for a
     * template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessControlEntries} method.
     * </p>
     * 
     * @return An access control entry grants or denies permission to an Active Directory group to enroll certificates
     *         for a template.
     */
    public final List<AccessControlEntrySummary> accessControlEntries() {
        return accessControlEntries;
    }

    /**
     * <p>
     * Use this parameter when paginating results in a subsequent request after you receive a response with truncated
     * results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.
     * </p>
     * 
     * @return Use this parameter when paginating results in a subsequent request after you receive a response with
     *         truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just
     *         received.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessControlEntries() ? accessControlEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateGroupAccessControlEntriesResponse)) {
            return false;
        }
        ListTemplateGroupAccessControlEntriesResponse other = (ListTemplateGroupAccessControlEntriesResponse) obj;
        return hasAccessControlEntries() == other.hasAccessControlEntries()
                && Objects.equals(accessControlEntries(), other.accessControlEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplateGroupAccessControlEntriesResponse")
                .add("AccessControlEntries", hasAccessControlEntries() ? accessControlEntries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControlEntries":
            return Optional.ofNullable(clazz.cast(accessControlEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessControlEntries", ACCESS_CONTROL_ENTRIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateGroupAccessControlEntriesResponse, T> g) {
        return obj -> g.apply((ListTemplateGroupAccessControlEntriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcaConnectorAdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTemplateGroupAccessControlEntriesResponse> {
        /**
         * <p>
         * An access control entry grants or denies permission to an Active Directory group to enroll certificates for a
         * template.
         * </p>
         * 
         * @param accessControlEntries
         *        An access control entry grants or denies permission to an Active Directory group to enroll
         *        certificates for a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlEntries(Collection<AccessControlEntrySummary> accessControlEntries);

        /**
         * <p>
         * An access control entry grants or denies permission to an Active Directory group to enroll certificates for a
         * template.
         * </p>
         * 
         * @param accessControlEntries
         *        An access control entry grants or denies permission to an Active Directory group to enroll
         *        certificates for a template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlEntries(AccessControlEntrySummary... accessControlEntries);

        /**
         * <p>
         * An access control entry grants or denies permission to an Active Directory group to enroll certificates for a
         * template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary.Builder#build()} is
         * called immediately and its result is passed to {@link #accessControlEntries(List<AccessControlEntrySummary>)}.
         * 
         * @param accessControlEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcaconnectorad.model.AccessControlEntrySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlEntries(java.util.Collection<AccessControlEntrySummary>)
         */
        Builder accessControlEntries(Consumer<AccessControlEntrySummary.Builder>... accessControlEntries);

        /**
         * <p>
         * Use this parameter when paginating results in a subsequent request after you receive a response with
         * truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just
         * received.
         * </p>
         * 
         * @param nextToken
         *        Use this parameter when paginating results in a subsequent request after you receive a response with
         *        truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you
         *        just received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PcaConnectorAdResponse.BuilderImpl implements Builder {
        private List<AccessControlEntrySummary> accessControlEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateGroupAccessControlEntriesResponse model) {
            super(model);
            accessControlEntries(model.accessControlEntries);
            nextToken(model.nextToken);
        }

        public final List<AccessControlEntrySummary.Builder> getAccessControlEntries() {
            List<AccessControlEntrySummary.Builder> result = AccessControlEntryListCopier
                    .copyToBuilder(this.accessControlEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlEntries(Collection<AccessControlEntrySummary.BuilderImpl> accessControlEntries) {
            this.accessControlEntries = AccessControlEntryListCopier.copyFromBuilder(accessControlEntries);
        }

        @Override
        public final Builder accessControlEntries(Collection<AccessControlEntrySummary> accessControlEntries) {
            this.accessControlEntries = AccessControlEntryListCopier.copy(accessControlEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlEntries(AccessControlEntrySummary... accessControlEntries) {
            accessControlEntries(Arrays.asList(accessControlEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlEntries(Consumer<AccessControlEntrySummary.Builder>... accessControlEntries) {
            accessControlEntries(Stream.of(accessControlEntries)
                    .map(c -> AccessControlEntrySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTemplateGroupAccessControlEntriesResponse build() {
            return new ListTemplateGroupAccessControlEntriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
