/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * General flags for v2 template schema that defines if the template is for a machine or a user and if the template can
 * be issued using autoenrollment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneralFlagsV2 implements SdkPojo, Serializable, ToCopyableBuilder<GeneralFlagsV2.Builder, GeneralFlagsV2> {
    private static final SdkField<Boolean> AUTO_ENROLLMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnrollment").getter(getter(GeneralFlagsV2::autoEnrollment)).setter(setter(Builder::autoEnrollment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoEnrollment").build()).build();

    private static final SdkField<Boolean> MACHINE_TYPE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MachineType").getter(getter(GeneralFlagsV2::machineType)).setter(setter(Builder::machineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MachineType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENROLLMENT_FIELD,
            MACHINE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean autoEnrollment;

    private final Boolean machineType;

    private GeneralFlagsV2(BuilderImpl builder) {
        this.autoEnrollment = builder.autoEnrollment;
        this.machineType = builder.machineType;
    }

    /**
     * <p>
     * Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
     * </p>
     * 
     * @return Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
     */
    public final Boolean autoEnrollment() {
        return autoEnrollment;
    }

    /**
     * <p>
     * Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to FALSE if
     * the template is for users.
     * </p>
     * 
     * @return Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to
     *         FALSE if the template is for users.
     */
    public final Boolean machineType() {
        return machineType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoEnrollment());
        hashCode = 31 * hashCode + Objects.hashCode(machineType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneralFlagsV2)) {
            return false;
        }
        GeneralFlagsV2 other = (GeneralFlagsV2) obj;
        return Objects.equals(autoEnrollment(), other.autoEnrollment()) && Objects.equals(machineType(), other.machineType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneralFlagsV2").add("AutoEnrollment", autoEnrollment()).add("MachineType", machineType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoEnrollment":
            return Optional.ofNullable(clazz.cast(autoEnrollment()));
        case "MachineType":
            return Optional.ofNullable(clazz.cast(machineType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoEnrollment", AUTO_ENROLLMENT_FIELD);
        map.put("MachineType", MACHINE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneralFlagsV2, T> g) {
        return obj -> g.apply((GeneralFlagsV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneralFlagsV2> {
        /**
         * <p>
         * Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
         * </p>
         * 
         * @param autoEnrollment
         *        Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnrollment(Boolean autoEnrollment);

        /**
         * <p>
         * Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to FALSE
         * if the template is for users.
         * </p>
         * 
         * @param machineType
         *        Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to
         *        FALSE if the template is for users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder machineType(Boolean machineType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoEnrollment;

        private Boolean machineType;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneralFlagsV2 model) {
            autoEnrollment(model.autoEnrollment);
            machineType(model.machineType);
        }

        public final Boolean getAutoEnrollment() {
            return autoEnrollment;
        }

        public final void setAutoEnrollment(Boolean autoEnrollment) {
            this.autoEnrollment = autoEnrollment;
        }

        @Override
        public final Builder autoEnrollment(Boolean autoEnrollment) {
            this.autoEnrollment = autoEnrollment;
            return this;
        }

        public final Boolean getMachineType() {
            return machineType;
        }

        public final void setMachineType(Boolean machineType) {
            this.machineType = machineType;
        }

        @Override
        public final Builder machineType(Boolean machineType) {
            this.machineType = machineType;
            return this;
        }

        @Override
        public GeneralFlagsV2 build() {
            return new GeneralFlagsV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
