/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.ClientCompatibilityV4;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivateKeyFlagsV4
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivateKeyFlagsV4> {
    private static final SdkField<String> CLIENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVersion").getter(PrivateKeyFlagsV4.getter(PrivateKeyFlagsV4::clientVersionAsString)).setter(PrivateKeyFlagsV4.setter(Builder::clientVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVersion").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExportableKey").getter(PrivateKeyFlagsV4.getter(PrivateKeyFlagsV4::exportableKey)).setter(PrivateKeyFlagsV4.setter(Builder::exportableKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableKey").build()}).build();
    private static final SdkField<Boolean> REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireAlternateSignatureAlgorithm").getter(PrivateKeyFlagsV4.getter(PrivateKeyFlagsV4::requireAlternateSignatureAlgorithm)).setter(PrivateKeyFlagsV4.setter(Builder::requireAlternateSignatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireAlternateSignatureAlgorithm").build()}).build();
    private static final SdkField<Boolean> REQUIRE_SAME_KEY_RENEWAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireSameKeyRenewal").getter(PrivateKeyFlagsV4.getter(PrivateKeyFlagsV4::requireSameKeyRenewal)).setter(PrivateKeyFlagsV4.setter(Builder::requireSameKeyRenewal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSameKeyRenewal").build()}).build();
    private static final SdkField<Boolean> STRONG_KEY_PROTECTION_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StrongKeyProtectionRequired").getter(PrivateKeyFlagsV4.getter(PrivateKeyFlagsV4::strongKeyProtectionRequired)).setter(PrivateKeyFlagsV4.setter(Builder::strongKeyProtectionRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrongKeyProtectionRequired").build()}).build();
    private static final SdkField<Boolean> USE_LEGACY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLegacyProvider").getter(PrivateKeyFlagsV4.getter(PrivateKeyFlagsV4::useLegacyProvider)).setter(PrivateKeyFlagsV4.setter(Builder::useLegacyProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLegacyProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VERSION_FIELD, EXPORTABLE_KEY_FIELD, REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD, REQUIRE_SAME_KEY_RENEWAL_FIELD, STRONG_KEY_PROTECTION_REQUIRED_FIELD, USE_LEGACY_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrivateKeyFlagsV4.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientVersion;
    private final Boolean exportableKey;
    private final Boolean requireAlternateSignatureAlgorithm;
    private final Boolean requireSameKeyRenewal;
    private final Boolean strongKeyProtectionRequired;
    private final Boolean useLegacyProvider;

    private PrivateKeyFlagsV4(BuilderImpl builder) {
        this.clientVersion = builder.clientVersion;
        this.exportableKey = builder.exportableKey;
        this.requireAlternateSignatureAlgorithm = builder.requireAlternateSignatureAlgorithm;
        this.requireSameKeyRenewal = builder.requireSameKeyRenewal;
        this.strongKeyProtectionRequired = builder.strongKeyProtectionRequired;
        this.useLegacyProvider = builder.useLegacyProvider;
    }

    public final ClientCompatibilityV4 clientVersion() {
        return ClientCompatibilityV4.fromValue(this.clientVersion);
    }

    public final String clientVersionAsString() {
        return this.clientVersion;
    }

    public final Boolean exportableKey() {
        return this.exportableKey;
    }

    public final Boolean requireAlternateSignatureAlgorithm() {
        return this.requireAlternateSignatureAlgorithm;
    }

    public final Boolean requireSameKeyRenewal() {
        return this.requireSameKeyRenewal;
    }

    public final Boolean strongKeyProtectionRequired() {
        return this.strongKeyProtectionRequired;
    }

    public final Boolean useLegacyProvider() {
        return this.useLegacyProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportableKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireAlternateSignatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireSameKeyRenewal());
        hashCode = 31 * hashCode + Objects.hashCode(this.strongKeyProtectionRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLegacyProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyFlagsV4)) {
            return false;
        }
        PrivateKeyFlagsV4 other = (PrivateKeyFlagsV4)obj;
        return Objects.equals(this.clientVersionAsString(), other.clientVersionAsString()) && Objects.equals(this.exportableKey(), other.exportableKey()) && Objects.equals(this.requireAlternateSignatureAlgorithm(), other.requireAlternateSignatureAlgorithm()) && Objects.equals(this.requireSameKeyRenewal(), other.requireSameKeyRenewal()) && Objects.equals(this.strongKeyProtectionRequired(), other.strongKeyProtectionRequired()) && Objects.equals(this.useLegacyProvider(), other.useLegacyProvider());
    }

    public final String toString() {
        return ToString.builder((String)"PrivateKeyFlagsV4").add("ClientVersion", (Object)this.clientVersionAsString()).add("ExportableKey", (Object)this.exportableKey()).add("RequireAlternateSignatureAlgorithm", (Object)this.requireAlternateSignatureAlgorithm()).add("RequireSameKeyRenewal", (Object)this.requireSameKeyRenewal()).add("StrongKeyProtectionRequired", (Object)this.strongKeyProtectionRequired()).add("UseLegacyProvider", (Object)this.useLegacyProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVersion": {
                return Optional.ofNullable(clazz.cast(this.clientVersionAsString()));
            }
            case "ExportableKey": {
                return Optional.ofNullable(clazz.cast(this.exportableKey()));
            }
            case "RequireAlternateSignatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.requireAlternateSignatureAlgorithm()));
            }
            case "RequireSameKeyRenewal": {
                return Optional.ofNullable(clazz.cast(this.requireSameKeyRenewal()));
            }
            case "StrongKeyProtectionRequired": {
                return Optional.ofNullable(clazz.cast(this.strongKeyProtectionRequired()));
            }
            case "UseLegacyProvider": {
                return Optional.ofNullable(clazz.cast(this.useLegacyProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientVersion", CLIENT_VERSION_FIELD);
        map.put("ExportableKey", EXPORTABLE_KEY_FIELD);
        map.put("RequireAlternateSignatureAlgorithm", REQUIRE_ALTERNATE_SIGNATURE_ALGORITHM_FIELD);
        map.put("RequireSameKeyRenewal", REQUIRE_SAME_KEY_RENEWAL_FIELD);
        map.put("StrongKeyProtectionRequired", STRONG_KEY_PROTECTION_REQUIRED_FIELD);
        map.put("UseLegacyProvider", USE_LEGACY_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateKeyFlagsV4, T> g) {
        return obj -> g.apply((PrivateKeyFlagsV4)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVersion;
        private Boolean exportableKey;
        private Boolean requireAlternateSignatureAlgorithm;
        private Boolean requireSameKeyRenewal;
        private Boolean strongKeyProtectionRequired;
        private Boolean useLegacyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateKeyFlagsV4 model) {
            this.clientVersion(model.clientVersion);
            this.exportableKey(model.exportableKey);
            this.requireAlternateSignatureAlgorithm(model.requireAlternateSignatureAlgorithm);
            this.requireSameKeyRenewal(model.requireSameKeyRenewal);
            this.strongKeyProtectionRequired(model.strongKeyProtectionRequired);
            this.useLegacyProvider(model.useLegacyProvider);
        }

        public final String getClientVersion() {
            return this.clientVersion;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientCompatibilityV4 clientVersion) {
            this.clientVersion(clientVersion == null ? null : clientVersion.toString());
            return this;
        }

        public final Boolean getExportableKey() {
            return this.exportableKey;
        }

        public final void setExportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
        }

        @Override
        public final Builder exportableKey(Boolean exportableKey) {
            this.exportableKey = exportableKey;
            return this;
        }

        public final Boolean getRequireAlternateSignatureAlgorithm() {
            return this.requireAlternateSignatureAlgorithm;
        }

        public final void setRequireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
        }

        @Override
        public final Builder requireAlternateSignatureAlgorithm(Boolean requireAlternateSignatureAlgorithm) {
            this.requireAlternateSignatureAlgorithm = requireAlternateSignatureAlgorithm;
            return this;
        }

        public final Boolean getRequireSameKeyRenewal() {
            return this.requireSameKeyRenewal;
        }

        public final void setRequireSameKeyRenewal(Boolean requireSameKeyRenewal) {
            this.requireSameKeyRenewal = requireSameKeyRenewal;
        }

        @Override
        public final Builder requireSameKeyRenewal(Boolean requireSameKeyRenewal) {
            this.requireSameKeyRenewal = requireSameKeyRenewal;
            return this;
        }

        public final Boolean getStrongKeyProtectionRequired() {
            return this.strongKeyProtectionRequired;
        }

        public final void setStrongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
        }

        @Override
        public final Builder strongKeyProtectionRequired(Boolean strongKeyProtectionRequired) {
            this.strongKeyProtectionRequired = strongKeyProtectionRequired;
            return this;
        }

        public final Boolean getUseLegacyProvider() {
            return this.useLegacyProvider;
        }

        public final void setUseLegacyProvider(Boolean useLegacyProvider) {
            this.useLegacyProvider = useLegacyProvider;
        }

        @Override
        public final Builder useLegacyProvider(Boolean useLegacyProvider) {
            this.useLegacyProvider = useLegacyProvider;
            return this;
        }

        public PrivateKeyFlagsV4 build() {
            return new PrivateKeyFlagsV4(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivateKeyFlagsV4> {
        public Builder clientVersion(String var1);

        public Builder clientVersion(ClientCompatibilityV4 var1);

        public Builder exportableKey(Boolean var1);

        public Builder requireAlternateSignatureAlgorithm(Boolean var1);

        public Builder requireSameKeyRenewal(Boolean var1);

        public Builder strongKeyProtectionRequired(Boolean var1);

        public Builder useLegacyProvider(Boolean var1);
    }
}

