/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.ValidityPeriodType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidityPeriod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidityPeriod> {
    private static final SdkField<Long> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Period").getter(ValidityPeriod.getter(ValidityPeriod::period)).setter(ValidityPeriod.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> PERIOD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeriodType").getter(ValidityPeriod.getter(ValidityPeriod::periodTypeAsString)).setter(ValidityPeriod.setter(Builder::periodType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_FIELD, PERIOD_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidityPeriod.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long period;
    private final String periodType;

    private ValidityPeriod(BuilderImpl builder) {
        this.period = builder.period;
        this.periodType = builder.periodType;
    }

    public final Long period() {
        return this.period;
    }

    public final ValidityPeriodType periodType() {
        return ValidityPeriodType.fromValue(this.periodType);
    }

    public final String periodTypeAsString() {
        return this.periodType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidityPeriod)) {
            return false;
        }
        ValidityPeriod other = (ValidityPeriod)obj;
        return Objects.equals(this.period(), other.period()) && Objects.equals(this.periodTypeAsString(), other.periodTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ValidityPeriod").add("Period", (Object)this.period()).add("PeriodType", (Object)this.periodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "PeriodType": {
                return Optional.ofNullable(clazz.cast(this.periodTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Period", PERIOD_FIELD);
        map.put("PeriodType", PERIOD_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidityPeriod, T> g) {
        return obj -> g.apply((ValidityPeriod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long period;
        private String periodType;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidityPeriod model) {
            this.period(model.period);
            this.periodType(model.periodType);
        }

        public final Long getPeriod() {
            return this.period;
        }

        public final void setPeriod(Long period) {
            this.period = period;
        }

        @Override
        public final Builder period(Long period) {
            this.period = period;
            return this;
        }

        public final String getPeriodType() {
            return this.periodType;
        }

        public final void setPeriodType(String periodType) {
            this.periodType = periodType;
        }

        @Override
        public final Builder periodType(String periodType) {
            this.periodType = periodType;
            return this;
        }

        @Override
        public final Builder periodType(ValidityPeriodType periodType) {
            this.periodType(periodType == null ? null : periodType.toString());
            return this;
        }

        public ValidityPeriod build() {
            return new ValidityPeriod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidityPeriod> {
        public Builder period(Long var1);

        public Builder periodType(String var1);

        public Builder periodType(ValidityPeriodType var1);
    }
}

