/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationListCopier;
import software.amazon.awssdk.services.pcaconnectorad.model.DirectoryRegistrationSummary;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDirectoryRegistrationsResponse
extends PcaConnectorAdResponse
implements ToCopyableBuilder<Builder, ListDirectoryRegistrationsResponse> {
    private static final SdkField<List<DirectoryRegistrationSummary>> DIRECTORY_REGISTRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DirectoryRegistrations").getter(ListDirectoryRegistrationsResponse.getter(ListDirectoryRegistrationsResponse::directoryRegistrations)).setter(ListDirectoryRegistrationsResponse.setter(Builder::directoryRegistrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryRegistrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectoryRegistrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDirectoryRegistrationsResponse.getter(ListDirectoryRegistrationsResponse::nextToken)).setter(ListDirectoryRegistrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_REGISTRATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDirectoryRegistrationsResponse.memberNameToFieldInitializer();
    private final List<DirectoryRegistrationSummary> directoryRegistrations;
    private final String nextToken;

    private ListDirectoryRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryRegistrations = builder.directoryRegistrations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDirectoryRegistrations() {
        return this.directoryRegistrations != null && !(this.directoryRegistrations instanceof SdkAutoConstructList);
    }

    public final List<DirectoryRegistrationSummary> directoryRegistrations() {
        return this.directoryRegistrations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectoryRegistrations() ? this.directoryRegistrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoryRegistrationsResponse)) {
            return false;
        }
        ListDirectoryRegistrationsResponse other = (ListDirectoryRegistrationsResponse)((Object)obj);
        return this.hasDirectoryRegistrations() == other.hasDirectoryRegistrations() && Objects.equals(this.directoryRegistrations(), other.directoryRegistrations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDirectoryRegistrationsResponse").add("DirectoryRegistrations", this.hasDirectoryRegistrations() ? this.directoryRegistrations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryRegistrations": {
                return Optional.ofNullable(clazz.cast(this.directoryRegistrations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryRegistrations", DIRECTORY_REGISTRATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDirectoryRegistrationsResponse, T> g) {
        return obj -> g.apply((ListDirectoryRegistrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdResponse.BuilderImpl
    implements Builder {
        private List<DirectoryRegistrationSummary> directoryRegistrations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoryRegistrationsResponse model) {
            super(model);
            this.directoryRegistrations(model.directoryRegistrations);
            this.nextToken(model.nextToken);
        }

        public final List<DirectoryRegistrationSummary.Builder> getDirectoryRegistrations() {
            List<DirectoryRegistrationSummary.Builder> result = DirectoryRegistrationListCopier.copyToBuilder(this.directoryRegistrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectoryRegistrations(Collection<DirectoryRegistrationSummary.BuilderImpl> directoryRegistrations) {
            this.directoryRegistrations = DirectoryRegistrationListCopier.copyFromBuilder(directoryRegistrations);
        }

        @Override
        public final Builder directoryRegistrations(Collection<DirectoryRegistrationSummary> directoryRegistrations) {
            this.directoryRegistrations = DirectoryRegistrationListCopier.copy(directoryRegistrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryRegistrations(DirectoryRegistrationSummary ... directoryRegistrations) {
            this.directoryRegistrations(Arrays.asList(directoryRegistrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryRegistrations(Consumer<DirectoryRegistrationSummary.Builder> ... directoryRegistrations) {
            this.directoryRegistrations(Stream.of(directoryRegistrations).map(c -> (DirectoryRegistrationSummary)((DirectoryRegistrationSummary.Builder)DirectoryRegistrationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDirectoryRegistrationsResponse build() {
            return new ListDirectoryRegistrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PcaConnectorAdResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDirectoryRegistrationsResponse> {
        public Builder directoryRegistrations(Collection<DirectoryRegistrationSummary> var1);

        public Builder directoryRegistrations(DirectoryRegistrationSummary ... var1);

        public Builder directoryRegistrations(Consumer<DirectoryRegistrationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

