/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcaconnectorad.model.CertificateValidity;
import software.amazon.awssdk.services.pcaconnectorad.model.EnrollmentFlagsV4;
import software.amazon.awssdk.services.pcaconnectorad.model.ExtensionsV4;
import software.amazon.awssdk.services.pcaconnectorad.model.GeneralFlagsV4;
import software.amazon.awssdk.services.pcaconnectorad.model.HashAlgorithm;
import software.amazon.awssdk.services.pcaconnectorad.model.PrivateKeyAttributesV4;
import software.amazon.awssdk.services.pcaconnectorad.model.PrivateKeyFlagsV4;
import software.amazon.awssdk.services.pcaconnectorad.model.SubjectNameFlagsV4;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateV4
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateV4> {
    private static final SdkField<CertificateValidity> CERTIFICATE_VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateValidity").getter(TemplateV4.getter(TemplateV4::certificateValidity)).setter(TemplateV4.setter(Builder::certificateValidity)).constructor(CertificateValidity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateValidity").build()}).build();
    private static final SdkField<EnrollmentFlagsV4> ENROLLMENT_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnrollmentFlags").getter(TemplateV4.getter(TemplateV4::enrollmentFlags)).setter(TemplateV4.setter(Builder::enrollmentFlags)).constructor(EnrollmentFlagsV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentFlags").build()}).build();
    private static final SdkField<ExtensionsV4> EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Extensions").getter(TemplateV4.getter(TemplateV4::extensions)).setter(TemplateV4.setter(Builder::extensions)).constructor(ExtensionsV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extensions").build()}).build();
    private static final SdkField<GeneralFlagsV4> GENERAL_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeneralFlags").getter(TemplateV4.getter(TemplateV4::generalFlags)).setter(TemplateV4.setter(Builder::generalFlags)).constructor(GeneralFlagsV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralFlags").build()}).build();
    private static final SdkField<String> HASH_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HashAlgorithm").getter(TemplateV4.getter(TemplateV4::hashAlgorithmAsString)).setter(TemplateV4.setter(Builder::hashAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashAlgorithm").build()}).build();
    private static final SdkField<PrivateKeyAttributesV4> PRIVATE_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateKeyAttributes").getter(TemplateV4.getter(TemplateV4::privateKeyAttributes)).setter(TemplateV4.setter(Builder::privateKeyAttributes)).constructor(PrivateKeyAttributesV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyAttributes").build()}).build();
    private static final SdkField<PrivateKeyFlagsV4> PRIVATE_KEY_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateKeyFlags").getter(TemplateV4.getter(TemplateV4::privateKeyFlags)).setter(TemplateV4.setter(Builder::privateKeyFlags)).constructor(PrivateKeyFlagsV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyFlags").build()}).build();
    private static final SdkField<SubjectNameFlagsV4> SUBJECT_NAME_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubjectNameFlags").getter(TemplateV4.getter(TemplateV4::subjectNameFlags)).setter(TemplateV4.setter(Builder::subjectNameFlags)).constructor(SubjectNameFlagsV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectNameFlags").build()}).build();
    private static final SdkField<List<String>> SUPERSEDED_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupersededTemplates").getter(TemplateV4.getter(TemplateV4::supersededTemplates)).setter(TemplateV4.setter(Builder::supersededTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupersededTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_VALIDITY_FIELD, ENROLLMENT_FLAGS_FIELD, EXTENSIONS_FIELD, GENERAL_FLAGS_FIELD, HASH_ALGORITHM_FIELD, PRIVATE_KEY_ATTRIBUTES_FIELD, PRIVATE_KEY_FLAGS_FIELD, SUBJECT_NAME_FLAGS_FIELD, SUPERSEDED_TEMPLATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateV4.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CertificateValidity certificateValidity;
    private final EnrollmentFlagsV4 enrollmentFlags;
    private final ExtensionsV4 extensions;
    private final GeneralFlagsV4 generalFlags;
    private final String hashAlgorithm;
    private final PrivateKeyAttributesV4 privateKeyAttributes;
    private final PrivateKeyFlagsV4 privateKeyFlags;
    private final SubjectNameFlagsV4 subjectNameFlags;
    private final List<String> supersededTemplates;

    private TemplateV4(BuilderImpl builder) {
        this.certificateValidity = builder.certificateValidity;
        this.enrollmentFlags = builder.enrollmentFlags;
        this.extensions = builder.extensions;
        this.generalFlags = builder.generalFlags;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.privateKeyAttributes = builder.privateKeyAttributes;
        this.privateKeyFlags = builder.privateKeyFlags;
        this.subjectNameFlags = builder.subjectNameFlags;
        this.supersededTemplates = builder.supersededTemplates;
    }

    public final CertificateValidity certificateValidity() {
        return this.certificateValidity;
    }

    public final EnrollmentFlagsV4 enrollmentFlags() {
        return this.enrollmentFlags;
    }

    public final ExtensionsV4 extensions() {
        return this.extensions;
    }

    public final GeneralFlagsV4 generalFlags() {
        return this.generalFlags;
    }

    public final HashAlgorithm hashAlgorithm() {
        return HashAlgorithm.fromValue(this.hashAlgorithm);
    }

    public final String hashAlgorithmAsString() {
        return this.hashAlgorithm;
    }

    public final PrivateKeyAttributesV4 privateKeyAttributes() {
        return this.privateKeyAttributes;
    }

    public final PrivateKeyFlagsV4 privateKeyFlags() {
        return this.privateKeyFlags;
    }

    public final SubjectNameFlagsV4 subjectNameFlags() {
        return this.subjectNameFlags;
    }

    public final boolean hasSupersededTemplates() {
        return this.supersededTemplates != null && !(this.supersededTemplates instanceof SdkAutoConstructList);
    }

    public final List<String> supersededTemplates() {
        return this.supersededTemplates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.generalFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectNameFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupersededTemplates() ? this.supersededTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateV4)) {
            return false;
        }
        TemplateV4 other = (TemplateV4)obj;
        return Objects.equals(this.certificateValidity(), other.certificateValidity()) && Objects.equals(this.enrollmentFlags(), other.enrollmentFlags()) && Objects.equals(this.extensions(), other.extensions()) && Objects.equals(this.generalFlags(), other.generalFlags()) && Objects.equals(this.hashAlgorithmAsString(), other.hashAlgorithmAsString()) && Objects.equals(this.privateKeyAttributes(), other.privateKeyAttributes()) && Objects.equals(this.privateKeyFlags(), other.privateKeyFlags()) && Objects.equals(this.subjectNameFlags(), other.subjectNameFlags()) && this.hasSupersededTemplates() == other.hasSupersededTemplates() && Objects.equals(this.supersededTemplates(), other.supersededTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateV4").add("CertificateValidity", (Object)this.certificateValidity()).add("EnrollmentFlags", (Object)this.enrollmentFlags()).add("Extensions", (Object)this.extensions()).add("GeneralFlags", (Object)this.generalFlags()).add("HashAlgorithm", (Object)this.hashAlgorithmAsString()).add("PrivateKeyAttributes", (Object)this.privateKeyAttributes()).add("PrivateKeyFlags", (Object)this.privateKeyFlags()).add("SubjectNameFlags", (Object)this.subjectNameFlags()).add("SupersededTemplates", this.hasSupersededTemplates() ? this.supersededTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateValidity": {
                return Optional.ofNullable(clazz.cast(this.certificateValidity()));
            }
            case "EnrollmentFlags": {
                return Optional.ofNullable(clazz.cast(this.enrollmentFlags()));
            }
            case "Extensions": {
                return Optional.ofNullable(clazz.cast(this.extensions()));
            }
            case "GeneralFlags": {
                return Optional.ofNullable(clazz.cast(this.generalFlags()));
            }
            case "HashAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.hashAlgorithmAsString()));
            }
            case "PrivateKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.privateKeyAttributes()));
            }
            case "PrivateKeyFlags": {
                return Optional.ofNullable(clazz.cast(this.privateKeyFlags()));
            }
            case "SubjectNameFlags": {
                return Optional.ofNullable(clazz.cast(this.subjectNameFlags()));
            }
            case "SupersededTemplates": {
                return Optional.ofNullable(clazz.cast(this.supersededTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateValidity", CERTIFICATE_VALIDITY_FIELD);
        map.put("EnrollmentFlags", ENROLLMENT_FLAGS_FIELD);
        map.put("Extensions", EXTENSIONS_FIELD);
        map.put("GeneralFlags", GENERAL_FLAGS_FIELD);
        map.put("HashAlgorithm", HASH_ALGORITHM_FIELD);
        map.put("PrivateKeyAttributes", PRIVATE_KEY_ATTRIBUTES_FIELD);
        map.put("PrivateKeyFlags", PRIVATE_KEY_FLAGS_FIELD);
        map.put("SubjectNameFlags", SUBJECT_NAME_FLAGS_FIELD);
        map.put("SupersededTemplates", SUPERSEDED_TEMPLATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateV4, T> g) {
        return obj -> g.apply((TemplateV4)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CertificateValidity certificateValidity;
        private EnrollmentFlagsV4 enrollmentFlags;
        private ExtensionsV4 extensions;
        private GeneralFlagsV4 generalFlags;
        private String hashAlgorithm;
        private PrivateKeyAttributesV4 privateKeyAttributes;
        private PrivateKeyFlagsV4 privateKeyFlags;
        private SubjectNameFlagsV4 subjectNameFlags;
        private List<String> supersededTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateV4 model) {
            this.certificateValidity(model.certificateValidity);
            this.enrollmentFlags(model.enrollmentFlags);
            this.extensions(model.extensions);
            this.generalFlags(model.generalFlags);
            this.hashAlgorithm(model.hashAlgorithm);
            this.privateKeyAttributes(model.privateKeyAttributes);
            this.privateKeyFlags(model.privateKeyFlags);
            this.subjectNameFlags(model.subjectNameFlags);
            this.supersededTemplates(model.supersededTemplates);
        }

        public final CertificateValidity.Builder getCertificateValidity() {
            return this.certificateValidity != null ? this.certificateValidity.toBuilder() : null;
        }

        public final void setCertificateValidity(CertificateValidity.BuilderImpl certificateValidity) {
            this.certificateValidity = certificateValidity != null ? certificateValidity.build() : null;
        }

        @Override
        public final Builder certificateValidity(CertificateValidity certificateValidity) {
            this.certificateValidity = certificateValidity;
            return this;
        }

        public final EnrollmentFlagsV4.Builder getEnrollmentFlags() {
            return this.enrollmentFlags != null ? this.enrollmentFlags.toBuilder() : null;
        }

        public final void setEnrollmentFlags(EnrollmentFlagsV4.BuilderImpl enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags != null ? enrollmentFlags.build() : null;
        }

        @Override
        public final Builder enrollmentFlags(EnrollmentFlagsV4 enrollmentFlags) {
            this.enrollmentFlags = enrollmentFlags;
            return this;
        }

        public final ExtensionsV4.Builder getExtensions() {
            return this.extensions != null ? this.extensions.toBuilder() : null;
        }

        public final void setExtensions(ExtensionsV4.BuilderImpl extensions) {
            this.extensions = extensions != null ? extensions.build() : null;
        }

        @Override
        public final Builder extensions(ExtensionsV4 extensions) {
            this.extensions = extensions;
            return this;
        }

        public final GeneralFlagsV4.Builder getGeneralFlags() {
            return this.generalFlags != null ? this.generalFlags.toBuilder() : null;
        }

        public final void setGeneralFlags(GeneralFlagsV4.BuilderImpl generalFlags) {
            this.generalFlags = generalFlags != null ? generalFlags.build() : null;
        }

        @Override
        public final Builder generalFlags(GeneralFlagsV4 generalFlags) {
            this.generalFlags = generalFlags;
            return this;
        }

        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        public final void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        @Override
        public final Builder hashAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm(hashAlgorithm == null ? null : hashAlgorithm.toString());
            return this;
        }

        public final PrivateKeyAttributesV4.Builder getPrivateKeyAttributes() {
            return this.privateKeyAttributes != null ? this.privateKeyAttributes.toBuilder() : null;
        }

        public final void setPrivateKeyAttributes(PrivateKeyAttributesV4.BuilderImpl privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes != null ? privateKeyAttributes.build() : null;
        }

        @Override
        public final Builder privateKeyAttributes(PrivateKeyAttributesV4 privateKeyAttributes) {
            this.privateKeyAttributes = privateKeyAttributes;
            return this;
        }

        public final PrivateKeyFlagsV4.Builder getPrivateKeyFlags() {
            return this.privateKeyFlags != null ? this.privateKeyFlags.toBuilder() : null;
        }

        public final void setPrivateKeyFlags(PrivateKeyFlagsV4.BuilderImpl privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags != null ? privateKeyFlags.build() : null;
        }

        @Override
        public final Builder privateKeyFlags(PrivateKeyFlagsV4 privateKeyFlags) {
            this.privateKeyFlags = privateKeyFlags;
            return this;
        }

        public final SubjectNameFlagsV4.Builder getSubjectNameFlags() {
            return this.subjectNameFlags != null ? this.subjectNameFlags.toBuilder() : null;
        }

        public final void setSubjectNameFlags(SubjectNameFlagsV4.BuilderImpl subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags != null ? subjectNameFlags.build() : null;
        }

        @Override
        public final Builder subjectNameFlags(SubjectNameFlagsV4 subjectNameFlags) {
            this.subjectNameFlags = subjectNameFlags;
            return this;
        }

        public final Collection<String> getSupersededTemplates() {
            if (this.supersededTemplates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supersededTemplates;
        }

        public final void setSupersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
        }

        @Override
        public final Builder supersededTemplates(Collection<String> supersededTemplates) {
            this.supersededTemplates = TemplateNameListCopier.copy(supersededTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supersededTemplates(String ... supersededTemplates) {
            this.supersededTemplates(Arrays.asList(supersededTemplates));
            return this;
        }

        public TemplateV4 build() {
            return new TemplateV4(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateV4> {
        public Builder certificateValidity(CertificateValidity var1);

        default public Builder certificateValidity(Consumer<CertificateValidity.Builder> certificateValidity) {
            return this.certificateValidity((CertificateValidity)((CertificateValidity.Builder)CertificateValidity.builder().applyMutation(certificateValidity)).build());
        }

        public Builder enrollmentFlags(EnrollmentFlagsV4 var1);

        default public Builder enrollmentFlags(Consumer<EnrollmentFlagsV4.Builder> enrollmentFlags) {
            return this.enrollmentFlags((EnrollmentFlagsV4)((EnrollmentFlagsV4.Builder)EnrollmentFlagsV4.builder().applyMutation(enrollmentFlags)).build());
        }

        public Builder extensions(ExtensionsV4 var1);

        default public Builder extensions(Consumer<ExtensionsV4.Builder> extensions) {
            return this.extensions((ExtensionsV4)((ExtensionsV4.Builder)ExtensionsV4.builder().applyMutation(extensions)).build());
        }

        public Builder generalFlags(GeneralFlagsV4 var1);

        default public Builder generalFlags(Consumer<GeneralFlagsV4.Builder> generalFlags) {
            return this.generalFlags((GeneralFlagsV4)((GeneralFlagsV4.Builder)GeneralFlagsV4.builder().applyMutation(generalFlags)).build());
        }

        public Builder hashAlgorithm(String var1);

        public Builder hashAlgorithm(HashAlgorithm var1);

        public Builder privateKeyAttributes(PrivateKeyAttributesV4 var1);

        default public Builder privateKeyAttributes(Consumer<PrivateKeyAttributesV4.Builder> privateKeyAttributes) {
            return this.privateKeyAttributes((PrivateKeyAttributesV4)((PrivateKeyAttributesV4.Builder)PrivateKeyAttributesV4.builder().applyMutation(privateKeyAttributes)).build());
        }

        public Builder privateKeyFlags(PrivateKeyFlagsV4 var1);

        default public Builder privateKeyFlags(Consumer<PrivateKeyFlagsV4.Builder> privateKeyFlags) {
            return this.privateKeyFlags((PrivateKeyFlagsV4)((PrivateKeyFlagsV4.Builder)PrivateKeyFlagsV4.builder().applyMutation(privateKeyFlags)).build());
        }

        public Builder subjectNameFlags(SubjectNameFlagsV4 var1);

        default public Builder subjectNameFlags(Consumer<SubjectNameFlagsV4.Builder> subjectNameFlags) {
            return this.subjectNameFlags((SubjectNameFlagsV4)((SubjectNameFlagsV4.Builder)SubjectNameFlagsV4.builder().applyMutation(subjectNameFlags)).build());
        }

        public Builder supersededTemplates(Collection<String> var1);

        public Builder supersededTemplates(String ... var1);
    }
}

