/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationPolicy> {
    private static final SdkField<String> POLICY_OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyObjectIdentifier").getter(ApplicationPolicy.getter(ApplicationPolicy::policyObjectIdentifier)).setter(ApplicationPolicy.setter(Builder::policyObjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyObjectIdentifier").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(ApplicationPolicy.getter(ApplicationPolicy::policyTypeAsString)).setter(ApplicationPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_OBJECT_IDENTIFIER_FIELD, POLICY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyObjectIdentifier;
    private final String policyType;
    private final Type type;

    private ApplicationPolicy(BuilderImpl builder) {
        this.policyObjectIdentifier = builder.policyObjectIdentifier;
        this.policyType = builder.policyType;
        this.type = builder.type;
    }

    public final String policyObjectIdentifier() {
        return this.policyObjectIdentifier;
    }

    public final ApplicationPolicyType policyType() {
        return ApplicationPolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyObjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicy)) {
            return false;
        }
        ApplicationPolicy other = (ApplicationPolicy)obj;
        return Objects.equals(this.policyObjectIdentifier(), other.policyObjectIdentifier()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationPolicy").add("PolicyObjectIdentifier", (Object)this.policyObjectIdentifier()).add("PolicyType", (Object)this.policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.policyObjectIdentifier()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public static ApplicationPolicy fromPolicyObjectIdentifier(String policyObjectIdentifier) {
        return (ApplicationPolicy)ApplicationPolicy.builder().policyObjectIdentifier(policyObjectIdentifier).build();
    }

    public static ApplicationPolicy fromPolicyType(String policyType) {
        return (ApplicationPolicy)ApplicationPolicy.builder().policyType(policyType).build();
    }

    public static ApplicationPolicy fromPolicyType(ApplicationPolicyType policyType) {
        return (ApplicationPolicy)ApplicationPolicy.builder().policyType(policyType).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PolicyObjectIdentifier", POLICY_OBJECT_IDENTIFIER_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPolicy, T> g) {
        return obj -> g.apply((ApplicationPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        POLICY_OBJECT_IDENTIFIER,
        POLICY_TYPE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String policyObjectIdentifier;
        private String policyType;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicy model) {
            this.policyObjectIdentifier(model.policyObjectIdentifier);
            this.policyType(model.policyType);
        }

        public final String getPolicyObjectIdentifier() {
            return this.policyObjectIdentifier;
        }

        public final void setPolicyObjectIdentifier(String policyObjectIdentifier) {
            String oldValue = this.policyObjectIdentifier;
            this.policyObjectIdentifier = policyObjectIdentifier;
            this.handleUnionValueChange(Type.POLICY_OBJECT_IDENTIFIER, oldValue, this.policyObjectIdentifier);
        }

        @Override
        public final Builder policyObjectIdentifier(String policyObjectIdentifier) {
            String oldValue = this.policyObjectIdentifier;
            this.policyObjectIdentifier = policyObjectIdentifier;
            this.handleUnionValueChange(Type.POLICY_OBJECT_IDENTIFIER, oldValue, this.policyObjectIdentifier);
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            String oldValue = this.policyType;
            this.policyType = policyType;
            this.handleUnionValueChange(Type.POLICY_TYPE, oldValue, this.policyType);
        }

        @Override
        public final Builder policyType(String policyType) {
            String oldValue = this.policyType;
            this.policyType = policyType;
            this.handleUnionValueChange(Type.POLICY_TYPE, oldValue, this.policyType);
            return this;
        }

        @Override
        public final Builder policyType(ApplicationPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public ApplicationPolicy build() {
            return new ApplicationPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationPolicy> {
        public Builder policyObjectIdentifier(String var1);

        public Builder policyType(String var1);

        public Builder policyType(ApplicationPolicyType var1);
    }
}

